/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BatchResults;
import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.IntegerBatchResults;
import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.LongBatchResults;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGParameterMetaData;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGResultSetMetaData;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.PreparedStatementDescription;
import com.impossibl.postgres.jdbc.StatementCacheKey;
import com.impossibl.postgres.jdbc.StatementDescription;
import com.impossibl.postgres.jdbc.Unwrapping;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.RequestExecutorHandlers;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class PGPreparedStatement
extends PGStatement
implements PreparedStatement {
    String sqlText;
    Type[] parameterTypes;
    Type[] parameterTypesParsed;
    FieldFormat[] parameterFormats;
    ByteBuf[] parameterBuffers;
    private int parameterCount;
    private boolean[] parameterSet;
    private List<Type[]> batchParameterTypes;
    private List<FieldFormat[]> batchParameterFormats;
    private List<ByteBuf[]> batchParameterBuffers;
    private boolean wantsGeneratedKeys;
    protected boolean parsed;

    PGPreparedStatement(PGDirectConnection connection, int type, int concurrency, int holdability, String sqlText, int parameterCount, String cursorName) {
        super(connection, type, concurrency, holdability, null, null);
        this.sqlText = sqlText;
        this.parameterCount = parameterCount;
        this.parameterTypes = new Type[parameterCount];
        this.parameterFormats = new FieldFormat[parameterCount];
        this.parameterBuffers = new ByteBuf[parameterCount];
        this.parameterSet = new boolean[parameterCount];
        this.cursorName = cursorName;
    }

    void setWantsGeneratedKeys() {
        this.wantsGeneratedKeys = true;
    }

    private int checkParameterIndex(int parameterIdx) throws SQLException {
        if (parameterIdx < 1 || parameterIdx > this.parameterTypes.length) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
        return parameterIdx - 1;
    }

    private Type resolveType(int parameterIdx, SQLType sqlType, Object value) throws SQLException {
        this.describeIfNeeded();
        Type suggestedType = JDBCTypeMapping.getType(sqlType, value, this.connection.getRegistry());
        Type parsedType = this.parameterTypesParsed[parameterIdx];
        Type type = suggestedType;
        if (suggestedType == null || parsedType.getCategory() != Type.Category.String) {
            type = parsedType;
        }
        return type;
    }

    void set(int parameterIdx, Object source, SQLType sqlType) throws SQLException {
        this.set(parameterIdx, source, null, sqlType);
    }

    void set(int parameterIdx, Object source, Object sourceContext, SQLType sqlType) throws SQLException {
        this.checkClosed();
        parameterIdx = this.checkParameterIndex(parameterIdx);
        Type paramType = this.resolveType(parameterIdx, sqlType, source);
        FieldFormat paramFormat = paramType.getCategory() == Type.Category.String ? FieldFormat.Text : paramType.getParameterFormat();
        this.parameterTypes[parameterIdx] = paramType;
        this.parameterFormats[parameterIdx] = paramFormat;
        ReferenceCountUtil.release((Object)this.parameterBuffers[parameterIdx]);
        this.parameterBuffers[parameterIdx] = null;
        if (source != null) {
            try {
                switch (paramFormat) {
                    case Text: {
                        StringBuilder out = new StringBuilder();
                        paramType.getTextCodec().getEncoder().encode(this.connection, paramType, source, sourceContext, out);
                        this.parameterBuffers[parameterIdx] = ByteBufUtil.writeUtf8((ByteBufAllocator)this.connection.getAllocator(), (CharSequence)out);
                        break;
                    }
                    case Binary: {
                        ByteBuf out = this.connection.getAllocator().buffer();
                        paramType.getBinaryCodec().getEncoder().encode(this.connection, paramType, source, sourceContext, out);
                        this.parameterBuffers[parameterIdx] = out;
                    }
                }
            }
            catch (IOException e) {
                throw ErrorUtils.makeSQLException(e);
            }
        }
        if (this.parameterCount > 0) {
            this.parameterSet[parameterIdx] = true;
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        ByteBufs.releaseAll(this.parameterBuffers);
        this.parameterBuffers = null;
        if (this.batchParameterBuffers != null) {
            this.batchParameterBuffers.forEach(ByteBufs::releaseAll);
            this.batchParameterBuffers = null;
        }
        this.parameterTypes = null;
        this.parameterSet = null;
    }

    void verifyParameterSet() throws SQLException {
        if (this.parameterCount > 0) {
            int count = 0;
            for (boolean b : this.parameterSet) {
                if (!b) continue;
                ++count;
            }
            if (count != this.parameterCount) {
                throw new SQLException("Incorrect parameter count, was " + count + ", expected: " + this.parameterCount);
            }
        }
    }

    private void describeIfNeeded() throws SQLException {
        if (this.parameterTypesParsed != null) {
            return;
        }
        StatementDescription cachedDescription = this.connection.getCachedStatementDescription(this.sqlText, () -> {
            RequestExecutorHandlers.PrepareResult result = this.connection.execute((long timeout) -> {
                RequestExecutorHandlers.PrepareResult handler = new RequestExecutorHandlers.PrepareResult();
                this.connection.getRequestExecutor().prepare(null, this.sqlText, Empty.EMPTY_TYPES, handler);
                handler.await(timeout, TimeUnit.MILLISECONDS);
                return handler;
            });
            return new StatementDescription(result.getDescribedParameterTypes(this.connection), result.getDescribedResultFields());
        });
        if (cachedDescription != null) {
            this.parameterTypesParsed = cachedDescription.parameterTypes;
        }
    }

    void parseIfNeeded() throws SQLException {
        if (this.query != null) {
            PGPreparedStatement.closeCursor(this.connection, this.cursorName);
        }
        if (!this.parsed) {
            StatementCacheKey key;
            PreparedStatementDescription cachedStatement;
            if (this.name != null && !this.name.startsWith("cached-")) {
                try {
                    this.connection.getRequestExecutor().close(ServerObjectType.Statement, this.name);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((cachedStatement = this.connection.getCachedPreparedStatement(key = new StatementCacheKey(this.sqlText, this.parameterTypes), () -> {
                ResultField[] describedResultFields;
                String name = this.connection.isCacheEnabled() ? "cached-" + Integer.toHexString(key.hashCode()) : "nocache-" + Integer.toHexString(key.hashCode());
                RequestExecutorHandlers.PrepareResult prep = this.connection.execute((long timeout) -> {
                    RequestExecutorHandlers.PrepareResult handler = new RequestExecutorHandlers.PrepareResult();
                    this.connection.getRequestExecutor().prepare(name, this.sqlText, this.parameterTypes, handler);
                    handler.await(timeout, TimeUnit.MILLISECONDS);
                    return handler;
                });
                this.warningChain = ErrorUtils.chainWarnings(this.warningChain, prep);
                for (ResultField describedResultField : describedResultFields = (ResultField[])prep.getDescribedResultFields().clone()) {
                    Type type = this.connection.getRegistry().resolve(describedResultField.getTypeRef());
                    if (type == null) continue;
                    describedResultField.setFormat(type.getResultFormat());
                }
                return new PreparedStatementDescription(name, prep.getDescribedParameterTypes(this.connection), describedResultFields);
            })) != null) {
                this.name = cachedStatement.name;
                this.parameterTypesParsed = cachedStatement.parameterTypes;
                this.resultFields = cachedStatement.resultFields;
                this.parsed = true;
            }
        }
    }

    boolean allowBatchSelects() {
        return false;
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        this.closeResultSets();
        this.verifyParameterSet();
        boolean res = this.name == null ? super.executeDirect(this.sqlText, this.parameterFormats, this.parameterBuffers, this.resultFields) : super.executeStatement(this.name, this.parameterFormats, this.parameterBuffers);
        if (this.cursorName != null) {
            res = super.executeDirect("FETCH ABSOLUTE 0 FROM " + this.cursorName, null, null, this.resultFields);
        }
        if (this.wantsGeneratedKeys) {
            this.generatedKeysResultSet = this.getResultSet();
            res = false;
        }
        return res;
    }

    @Override
    public PGResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw Exceptions.NO_RESULT_SET_AVAILABLE;
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        long count = this.executeLargeUpdate();
        return (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.execute()) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchParameterTypes == null) {
            this.batchParameterTypes = new ArrayList<Type[]>();
        }
        if (this.batchParameterFormats == null) {
            this.batchParameterFormats = new ArrayList<FieldFormat[]>();
        }
        if (this.batchParameterBuffers == null) {
            this.batchParameterBuffers = new ArrayList<ByteBuf[]>();
        }
        this.batchParameterTypes.add((Type[])this.parameterTypes.clone());
        this.batchParameterFormats.add((FieldFormat[])this.parameterFormats.clone());
        this.batchParameterBuffers.add(ByteBufs.retainedDuplicateAll(this.parameterBuffers));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchParameterBuffers != null) {
            this.batchParameterBuffers.forEach(ByteBufs::releaseAll);
            this.batchParameterBuffers = null;
        }
        this.batchParameterTypes = null;
        this.batchParameterFormats = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        IntegerBatchResults results = new IntegerBatchResults(this.connection.isStrictMode());
        this.executeBatch(results);
        return results.counts;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClosed();
        LongBatchResults results = new LongBatchResults(this.connection.isStrictMode());
        this.executeBatch(results);
        return results.counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(BatchResults results) throws SQLException {
        this.closeResultSets();
        try {
            this.warningChain = null;
            if (this.batchParameterBuffers == null || this.batchParameterBuffers.isEmpty()) {
                return;
            }
            results.setBatchSize(this.batchParameterBuffers.size());
            RowDataSet generatedKeys = new RowDataSet();
            if (!this.connection.autoCommit && this.connection.getTransactionStatus() == TransactionStatus.Idle) {
                this.connection.execute((long timeout) -> this.connection.getRequestExecutor().lazyExecute("TC"));
            }
            Type[] lastParameterTypes = null;
            FieldFormatRef[] lastResultFields = null;
            AtomicInteger completedBatchIdx = new AtomicInteger(0);
            int sz = this.batchParameterBuffers.size();
            try {
                RequestExecutor requestExecutor = this.connection.getRequestExecutor();
                ArrayList<RequestExecutorHandlers.ExecuteResult> requestHandlers = new ArrayList<RequestExecutorHandlers.ExecuteResult>();
                for (int batchIdx = 0; batchIdx < sz; ++batchIdx) {
                    Type[] suggestedParameterTypes = this.mergedTypes(this.batchParameterTypes.get(batchIdx), lastParameterTypes);
                    if (lastParameterTypes == null || !Arrays.equals(lastParameterTypes, this.parameterTypes)) {
                        RequestExecutorHandlers.PrepareResult prep = this.connection.execute((long timeout) -> {
                            RequestExecutorHandlers.PrepareResult handler = new RequestExecutorHandlers.PrepareResult();
                            requestExecutor.prepare(null, this.sqlText, suggestedParameterTypes, handler);
                            handler.await(timeout, TimeUnit.MILLISECONDS);
                            return handler;
                        });
                        this.warningChain = ErrorUtils.chainWarnings(this.warningChain, prep);
                        lastParameterTypes = this.parameterTypes = prep.getDescribedParameterTypes(this.connection);
                        lastResultFields = prep.getDescribedResultFields();
                    }
                    FieldFormatRef[] parameterFormats = this.batchParameterFormats.get(batchIdx);
                    ByteBuf[] parameterBuffers = this.batchParameterBuffers.get(batchIdx);
                    FieldFormatRef[] resultFields = lastResultFields;
                    RequestExecutorHandlers.ExecuteResult handler = new RequestExecutorHandlers.ExecuteResult((ResultField[])resultFields);
                    requestExecutor.execute(null, null, parameterFormats, parameterBuffers, resultFields, 0, handler);
                    requestHandlers.add(handler);
                    this.finishCompletedRequests(requestHandlers, completedBatchIdx, results, generatedKeys);
                }
                this.finishRequests(requestHandlers, completedBatchIdx, results, generatedKeys);
            }
            catch (IOException | SQLException se) {
                throw results.getException(completedBatchIdx.get(), null, se);
            }
            this.generatedKeysResultSet = this.createResultSet((ResultField[])lastResultFields, generatedKeys, true, this.connection.getTypeMap());
        }
        finally {
            this.batchParameterTypes = null;
            if (this.batchParameterBuffers != null) {
                this.batchParameterBuffers.forEach(ByteBufs::releaseAll);
                this.batchParameterBuffers = null;
            }
        }
    }

    private void finishRequest(AtomicInteger batchIdx, RequestExecutorHandlers.ExecuteResult request, BatchResults results, RowDataSet generatedKeys) throws BatchUpdateException {
        this.warningChain = ErrorUtils.chainWarnings(this.warningChain, request);
        Throwable error = request.getError();
        if (error != null) {
            throw results.getException(batchIdx.get(), null, (Exception)error);
        }
        try (ResultBatch resultBatch = request.getBatch();){
            if (!this.allowBatchSelects() && resultBatch.getCommand().equals("SELECT")) {
                throw results.getException(batchIdx.get(), "SELECT in executeBatch", null);
            }
            if (resultBatch.getRowsAffected() != null) {
                results.setUpdateCount(batchIdx.get(), resultBatch.getRowsAffected());
            } else {
                results.setUpdateCount(batchIdx.get(), -2L);
            }
            if (this.wantsGeneratedKeys) {
                generatedKeys.add(resultBatch.borrowRows().take(0));
            }
        }
    }

    private void finishCompletedRequests(List<RequestExecutorHandlers.ExecuteResult> batchRequests, AtomicInteger batchIdx, BatchResults results, RowDataSet generatedKeys) throws BatchUpdateException {
        while (!batchRequests.isEmpty() && batchRequests.get(0).isCompleted()) {
            RequestExecutorHandlers.ExecuteResult request = batchRequests.remove(0);
            this.finishRequest(batchIdx, request, results, generatedKeys);
            batchIdx.incrementAndGet();
        }
    }

    private void finishRequests(List<RequestExecutorHandlers.ExecuteResult> batchRequests, AtomicInteger batchIdx, BatchResults results, RowDataSet generatedKeys) throws SQLException {
        while (!batchRequests.isEmpty()) {
            RequestExecutorHandlers.ExecuteResult request = batchRequests.remove(0);
            this.connection.execute((long timeout) -> request.await(timeout, TimeUnit.MILLISECONDS));
            this.finishRequest(batchIdx, request, results, generatedKeys);
            batchIdx.incrementAndGet();
        }
    }

    private Type[] mergedTypes(Type[] types, Type[] defaultTypes) {
        types = (Type[])types.clone();
        this.mergeTypes(types, defaultTypes);
        return types;
    }

    private void mergeTypes(Type[] types, Type[] defaultTypes) {
        if (defaultTypes == null) {
            return;
        }
        for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            if (types[typeIdx] != null) continue;
            types[typeIdx] = defaultTypes[typeIdx];
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkClosed();
        ByteBufs.releaseAll(this.parameterBuffers);
        for (int parameterIdx = 0; parameterIdx < this.parameterSet.length; ++parameterIdx) {
            this.parameterSet[parameterIdx] = Boolean.FALSE;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        return new PGParameterMetaData(this.parameterTypesParsed, this.connection.getTypeMap());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        return new PGResultSetMetaData(this.connection, this.resultFields, this.connection.getTypeMap());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.set(parameterIndex, null, JDBCType.valueOf(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.BOOLEAN);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.TINYINT);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.SMALLINT);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.INTEGER);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.BIGINT);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.set(parameterIndex, Float.valueOf(x), JDBCType.FLOAT);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.DOUBLE);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.DECIMAL);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.VARCHAR);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.BINARY);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.set(parameterIndex, x, cal, JDBCType.DATE);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.set(parameterIndex, x, cal, JDBCType.TIME);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.set(parameterIndex, x, cal, JDBCType.TIMESTAMP);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.BINARY);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (length < 0) {
            throw new SQLException("Invalid length");
        }
        if (x == null && length != 0) {
            throw new SQLException("Invalid length");
        }
        this.set(parameterIndex, x, length, JDBCType.BINARY);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("Invalid length");
        }
        if (x == null && length != 0L) {
            throw new SQLException("Invalid length");
        }
        this.set(parameterIndex, x, length, JDBCType.BINARY);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        InputStreamReader reader = new InputStreamReader(x, StandardCharsets.UTF_8);
        this.setCharacterStream(parameterIndex, (Reader)reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1L);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        InputStreamReader reader = new InputStreamReader(x, StandardCharsets.US_ASCII);
        this.setCharacterStream(parameterIndex, (Reader)reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1L);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        StringWriter writer = new StringWriter();
        try {
            CharStreams.copy(reader, writer);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, writer.toString(), JDBCType.VARCHAR);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), JDBCTypeMapping.getJDBCType(x));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), null, JDBCType.valueOf(targetSqlType));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), scaleOrLength, JDBCType.valueOf(targetSqlType));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), scaleOrLength, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), null, targetSqlType);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapBlob(this.connection, x), JDBCType.BLOB);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBlob(parameterIndex, ByteStreams.limit(inputStream, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        Blob blob = this.connection.createBlob();
        try {
            ByteStreams.copy(inputStream, blob.setBinaryStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, blob, JDBCType.BLOB);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.set(parameterIndex, Unwrapping.unwrapClob(this.connection, x), JDBCType.CLOB);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, CharStreams.limit(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        Clob clob = this.connection.createClob();
        try {
            CharStreams.copy(reader, clob.setCharacterStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, clob, JDBCType.CLOB);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.ARRAY);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.set(parameterIndex, null, JDBCType.valueOf(sqlType));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.set(parameterIndex, x, JDBCType.VARCHAR);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.set(parameterIndex, Unwrapping.unwrapXML(xmlObject), JDBCType.SQLXML);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.set(parameterIndex, Unwrapping.unwrapRowId(x), JDBCType.ROWID);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }
}

