/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils;

/**
 * This class is intended to be used as anonymous 
 * inner class
 * 
 * 
 * @author Toni Kalajainen
 */
public class RunnableWithObject implements Runnable {

    protected Object object, object2;
    
    protected Object objs[];
    
    public RunnableWithObject(Object o) {
        object = o;
        objs = new Object[] {o};
    }

    public RunnableWithObject(Object o, Object o2) {
        object = o;
        object2 = o2;
        objs = new Object[] {o, o2};
    }

    public RunnableWithObject(Object... objs) {
        this.objs = objs;
        if (objs.length>=1)
            object = objs[0];
        if (objs.length>=2)
            object2 = objs[1];
    }
    
    public void run() {
    }
    
    public Object getObject() {
        return object;
    }
    
    public int count() {
        return objs.length;
    }
    
    public Object getObject(int index) {
        return objs[index];
    }

}
