package org.simantics.utils;

/**
 * An asynchronous operation returning some result.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface IOperation<Result, E extends Exception> {
    /**
     * Waits that operation is completed. Either returns the
     * result or throws an exception if the operation fails.
     * If operation has already been completed when the method is called,
     * returns immediately.
     */
    Result waitFor() throws E;

    /**
     * Tells whether the operation is already completed.
     */
    boolean isDone();

    /**
     * Adds a listener that is notified when the operation
     * is completed. If the operation has already been completed
     * when the method is called, calls the listener immediately
     * (but asynchronously).
     */
    void addListener(IOperationListener<Result, E> listener);
}