package org.simantics.ui.workspace.tracker.internal.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.Preferences;
import org.simantics.ui.workspace.tracker.IWorkspaceSizeTrackerConstants;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class WorkspaceSizeTrackingPreferenceInitializer extends AbstractPreferenceInitializer {

	public WorkspaceSizeTrackingPreferenceInitializer() {
	}

	@Override
	public void initializeDefaultPreferences() {
		IScopeContext context = DefaultScope.INSTANCE;
		Preferences node = context.getNode(IWorkspaceSizeTrackerConstants.P_NODE);
		node.putBoolean(IWorkspaceSizeTrackerConstants.PREF_SHOW_MONITOR, IWorkspaceSizeTrackerConstants.DEFAULT_SHOW_MONITOR);
		node.putInt(IWorkspaceSizeTrackerConstants.PREF_UPDATE_INTERVAL, IWorkspaceSizeTrackerConstants.DEFAULT_UPDATE_INTERVAL);
		node.putBoolean(IWorkspaceSizeTrackerConstants.PREF_HIGHLIGHT_LOW_SPACE, IWorkspaceSizeTrackerConstants.DEFAULT_HIGHLIGHT_LOW_SPACE);
		node.putLong(IWorkspaceSizeTrackerConstants.PREF_LOW_SPACE_THRESHOLD, IWorkspaceSizeTrackerConstants.DEFAULT_LOW_SPACE_THRESHOLD);
	}

}
