package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.ui.browser.SCLDefinitionSelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSCLDefinition extends AbstractHandler {

    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSCLDefinition.class);

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLDefinitionSelectionDialog dialog = new SCLDefinitionSelectionDialog(
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if(dialog.open() == SCLDefinitionSelectionDialog.OK) {
            SCLValue value = (SCLValue)dialog.getFirstResult();
            if(value != null)
                scheduleOpenDefinition(value.getName().module, value.definitionLocation);
        }
        return null;
    }

    public static void openDefinition(SCLValue value) {
        openDefinition(value.getName().module, value.definitionLocation);
    }

    public static Runnable openDefinition(String moduleName, long location) {
        return () -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if(page == null)
                return;
            SCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
            try {
                SCLModuleEditor2 editor = (SCLModuleEditor2)page.openEditor(input, "org.simantics.scl.ui.editor2"); //$NON-NLS-1$
                if(location != Locations.NO_LOCATION) {
                    int begin = Locations.beginOf(location);
                    int end = Locations.endOf(location);
                    editor.selectAndReveal(begin, end-begin);
                }
            } catch (PartInitException e) {
                LOGGER.error("", e); //$NON-NLS-1$
            }
        };
    }
    
    public static void scheduleOpenDefinition(String moduleName, long location) {
        Display.getCurrent().asyncExec(openDefinition(moduleName, location));
    }

}
