/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;

/**
 * Rendering quality hints
 * 
 * @author Toni Kalajainen
 */
public class QualityHints {

    public static final QualityHints HIGH_QUALITY_HINTS =
        new QualityHints(RenderingHints.VALUE_RENDER_QUALITY,
                RenderingHints.VALUE_ANTIALIAS_ON,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON,
                RenderingHints.VALUE_INTERPOLATION_BICUBIC);

    public static final QualityHints GOOD_QUALITY_HINTS =
        new QualityHints(RenderingHints.VALUE_RENDER_DEFAULT,
                RenderingHints.VALUE_ANTIALIAS_ON,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON,
                RenderingHints.VALUE_INTERPOLATION_BILINEAR);

    public static final QualityHints LOW_QUALITY_HINTS =
        new QualityHints(RenderingHints.VALUE_RENDER_SPEED,
                RenderingHints.VALUE_ANTIALIAS_OFF,
                RenderingHints.VALUE_TEXT_ANTIALIAS_OFF,
                RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

    public static QualityHints getHints(Quality forQuality) {
        if (forQuality == null)
            return null;
        switch (forQuality) {
            case GOOD: return GOOD_QUALITY_HINTS;
            case HIGH: return HIGH_QUALITY_HINTS;
            case LOW: return LOW_QUALITY_HINTS;
            default: return HIGH_QUALITY_HINTS;
        }
    }

    public final Object rendering;
    public final Object antialiasing;
    public final Object textAntiAliasing;
    public final Object interpolation;

    public QualityHints(Object rendering, Object antialiasing, Object textAntiAliasing, Object interpolation) {
        this.rendering = rendering;
        this.antialiasing = antialiasing;
        this.textAntiAliasing = textAntiAliasing;
        this.interpolation = interpolation;
    }

    public void setQuality(Graphics2D g) {
        if (rendering!=null)
            g.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
        if (antialiasing!=null)
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        if (textAntiAliasing!=null)
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAliasing);
        if (interpolation!=null)
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
    }

    public static QualityHints getQuality(Graphics2D g) {
        return new QualityHints(
                g.getRenderingHint(RenderingHints.KEY_RENDERING),
                g.getRenderingHint(RenderingHints.KEY_ANTIALIASING),
                g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING),
                g.getRenderingHint(RenderingHints.KEY_INTERPOLATION)
        );
    }

}
