/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DParentNode;

/**
 * @author Tuukka Lehtonen
 */
public class ClippingNode extends G2DParentNode {

    private static final long serialVersionUID = -1064240485806430485L;

    protected Shape clipShape;

    @SyncField({"clipShape"})
    public void setClip(Shape shape) {
        this.clipShape = shape;
    }

    public Shape getClip() {
        return clipShape;
    }

    @Override
    public void render(Graphics2D g2d) {
        Shape prevClip = g2d.getClip();
        try {
            g2d.setClip(clipShape);
            super.render(g2d);
        } finally {
            g2d.setClip(prevClip);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[clip shape=" + clipShape + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (clipShape == null)
            return null;
       return clipShape.getBounds2D();
    }

}