/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.scenegraph.g2d.events;

/**
 * @author Toni Kalajainen
 */
public interface IEventHandler {

    /**
     * Returns a bit mask based on the constants in {@link EventTypes} to
     * restrict which type of events should be propagated to this event handler.
     * The value returned by this method must be constant, it must not change
     * during the handler's life cycle.
     * 
     * @return a bit mask defining the events to propagate to this handler
     * @see EventTypes
     */
    int getEventMask();

    /**
     * Process an event. If this method returns true, the event will be eaten
     * and not sent to lower levels of the handler stack.
     * 
     * @return true if the handler consumed the event. Consumed events are not
     *         propagated further.
     */
    boolean handleEvent(Event e);

}
