/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.structural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.db.Resource;
import org.simantics.g3d.scenegraph.structural.IComponentNode;
import org.simantics.objmap.structural.IStructuralObject;

public abstract class Connection<T extends Connection<T, T2>, T2 extends IComponentNode<T, T2>>
implements IStructuralObject {
    private List<T2> connects = new ArrayList<T2>();
    private List<IStructuralObject> ctx = new ArrayList<IStructuralObject>(1);

    public void addConnect(T2 node) {
        if (!this.connects.contains(node)) {
            this.connects.add(node);
        }
        this.fireChanged(node, true);
    }

    protected void fireChanged(T2 node, boolean add) {
        for (IComponentNode n : this.connects) {
            n.connectionChanged(this, node, add);
        }
    }

    public Collection<T2> getConnected() {
        return this.connects;
    }

    public void removeConnect(T2 node) {
        this.connects.remove(node);
        this.fireChanged(node, false);
    }

    public void remove() {
        ArrayList<T2> toRemove = new ArrayList<T2>(this.connects.size());
        toRemove.addAll(this.connects);
        for (IComponentNode node : toRemove) {
            node.removeConnection(this);
        }
    }

    public T2 getOther(IComponentNode<T, T2> node) {
        if (this.connects.size() != 2) {
            return null;
        }
        if (((IComponentNode)this.connects.get(0)).equals(node)) {
            return (T2)((IComponentNode)this.connects.get(1));
        }
        if (((IComponentNode)this.connects.get(1)).equals(node)) {
            return (T2)((IComponentNode)this.connects.get(0));
        }
        return null;
    }

    public void setType(Resource type) {
    }

    public Resource getType() {
        return null;
    }

    public List<IStructuralObject> getContext() {
        return this.ctx;
    }

    public void setContext(List<IStructuralObject> object) {
        this.ctx = object;
    }
}

