/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;

public class DoubleArrayPropertyManipulator2
implements PropertyManipulator {
    ValueProvider provider;
    Object input;
    boolean editMode;
    double[] editValue = null;

    public DoubleArrayPropertyManipulator2(ValueProvider provider, Object input) {
        this.provider = provider;
        this.input = input;
    }

    @Override
    public int getValueCount() {
        return this.getValue().length + 1;
    }

    @Override
    public String getDescription(int i) {
        return "Value " + i;
    }

    private double[] getValue() {
        try {
            return (double[])this.provider.getValue(this.input);
        }
        catch (Exception e) {
            return new double[0];
        }
    }

    @Override
    public String getValue(int i) {
        double[] val;
        block9: {
            block8: {
                block7: {
                    if (this.editMode) {
                        if (i < this.editValue.length) {
                            return Double.toString(this.editValue[i]);
                        }
                        return "";
                    }
                    try {
                        val = this.getValue();
                        if (val != null) break block7;
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if (val.length != i) break block8;
                return "New";
            }
            if (val.length >= i) break block9;
            return null;
        }
        return Double.toString(MathTools.round(val[i], 10));
    }

    @Override
    public String setValue(String value, int i) {
        try {
            double[] val = this.editValue;
            if (value.length() == 0 && i == val.length - 1) {
                double[] newVal = new double[val.length - 1];
                System.arraycopy(val, 0, newVal, 0, val.length - 1);
                val = newVal;
            } else if (i < val.length) {
                val[i] = Double.parseDouble(value);
            } else if (i == val.length) {
                double[] newVal = new double[val.length + 1];
                System.arraycopy(val, 0, newVal, 0, val.length);
                val = newVal;
            }
            this.provider.setValue(this.input, val);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
        if (this.editMode) {
            try {
                this.editValue = this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

