package ${packageName};

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ${className} {
    
    <#list resources as resource>
    <#if resource.deprecated>@Deprecated </#if>public final Resource ${resource.javaName};
    </#list>
        
    public static class URIs {
        <#list resources as resource>
        <#if resource.deprecated>@Deprecated </#if>public static final String ${resource.javaName} = "${resource.uri}";
        </#list>
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ${className}(ReadGraph graph) {
        <#list resources as resource>
        ${resource.javaName} = getResourceOrNull(graph, URIs.${resource.javaName});
        </#list>
    }
    
    public static ${className} getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ${className} ret = session.peekService(${className}.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ${className}(qc.getIndependentGraph(graph));
            session.registerService(${className}.class, ret);
        }
        return ret;
    }
    
    public static ${className} getInstance(RequestProcessor session) throws DatabaseException {
        ${className} ret = session.peekService(${className}.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<${className}>() {
                public ${className} perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ${className}(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(${className}.class, ret);
        }
        return ret;
    }
    
}

