/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncContextProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.procore.cluster.ResourceTableSmall;
import org.simantics.db.procore.cluster.ValueTableSmall;
import org.simantics.db.service.DirectQuerySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectQuerySupportImpl
implements DirectQuerySupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectQuerySupportImpl.class);
    private final SessionImplSocket session;

    DirectQuerySupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public final DirectStatements getDirectPersistentStatements(ReadGraph graph, Resource subject) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.getDirectStatements(impl, subject, true);
    }

    public final DirectStatements getDirectStatements(ReadGraph graph, Resource subject) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.getDirectStatements(impl, subject, false);
    }

    public RelationInfo getRelationInfo(ReadGraph graph, Resource subject) throws DatabaseException {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        return impl.processor.getRelationInfo(impl, subject);
    }

    public SyncMultiProcedure<Resource> compileForEachObject(ReadGraph graph, Resource relation, SyncMultiProcedure<Resource> user) throws DatabaseException {
        RelationInfo info = this.getRelationInfo(graph, relation);
        int predicateKey = ((ResourceImpl)relation).id;
        return new ForEachObjectProcedure(predicateKey, info, this.session.queryProvider2, user);
    }

    public <C> SyncContextMultiProcedure<C, Resource> compileForEachObject(ReadGraph graph, Resource relation, SyncContextMultiProcedure<C, Resource> user) throws DatabaseException {
        RelationInfo info = this.getRelationInfo(graph, relation);
        int predicateKey = ((ResourceImpl)relation).id;
        return new ForEachObjectContextProcedure(predicateKey, info, this.session.queryProvider2, user);
    }

    public <T> SyncProcedure<T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, SyncProcedure<T> user) throws DatabaseException {
        RelationInfo info = this.getRelationInfo(graph, relation);
        int predicateKey = ((ResourceImpl)relation).id;
        return new ForPossibleRelatedValueProcedure(predicateKey, info, user);
    }

    public <C, T> SyncContextProcedure<C, T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, SyncContextProcedure<C, T> user) throws DatabaseException {
        RelationInfo info = this.getRelationInfo(graph, relation);
        int predicateKey = ((ResourceImpl)relation).id;
        return new ForPossibleRelatedValueContextProcedure(predicateKey, info, user);
    }

    public void forEachObjectCompiled(ReadGraph graph, Resource subject, SyncMultiProcedure<Resource> procedure) {
        assert (subject != null);
        ForEachObjectProcedure proc = (ForEachObjectProcedure)procedure;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        this.session.querySupport.getObjects4(impl, subjectId, proc);
    }

    public <C> void forEachObjectCompiled(ReadGraph graph, Resource subject, C context, SyncContextMultiProcedure<C, Resource> procedure) {
        assert (subject != null);
        ForEachObjectContextProcedure proc = (ForEachObjectContextProcedure)procedure;
        RelationInfo info = proc.info;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        if (info.isFunctional) {
            this.session.querySupport.getObjects4(impl, subjectId, context, proc);
        } else {
            this.session.querySupport.getObjects4(impl, subjectId, context, proc);
        }
    }

    public <T> void forPossibleRelatedValueCompiled(ReadGraph graph, Resource subject, SyncProcedure<T> procedure) {
        assert (subject != null);
        ForPossibleRelatedValueProcedure proc = (ForPossibleRelatedValueProcedure)procedure;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        try {
            T result = this.getRelatedValue4(impl, subjectId, proc);
            try {
                proc.execute(graph, result);
            }
            catch (DatabaseException e2) {
                LOGGER.error("Unexpected exception while handling related value", (Throwable)e2);
            }
        }
        catch (DatabaseException e) {
            try {
                proc.exception(graph, (Throwable)e);
            }
            catch (DatabaseException e2) {
                LOGGER.error("Unexpected exception while handling related value", (Throwable)e2);
            }
        }
    }

    public <C, T> void forPossibleRelatedValueCompiled(ReadGraph graph, Resource subject, C context, SyncContextProcedure<C, T> procedure) {
        assert (subject != null);
        ForPossibleRelatedValueContextProcedure proc = (ForPossibleRelatedValueContextProcedure)procedure;
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        try {
            T result = this.getRelatedValue4(impl, subjectId, context, proc);
            proc.execute(graph, context, result);
        }
        catch (DatabaseException databaseException) {
            proc.execute(graph, context, null);
        }
    }

    public <C> void forPossibleDirectType(ReadGraph graph, Resource subject, C context, SyncContextProcedure<C, Resource> procedure) {
        assert (subject != null);
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        int subjectId = ((ResourceImpl)subject).id;
        try {
            Object cluster = this.session.clusterTable.getClusterByResourceKey(subjectId);
            if (!cluster.isLoaded()) {
                this.session.queryProvider2.requestCluster(impl, cluster.getClusterId(), new Runnable((ClusterI)cluster, subjectId, (SyncContextProcedure)procedure, graph, context){
                    private final /* synthetic */ ClusterI val$cluster;
                    private final /* synthetic */ int val$subjectId;
                    private final /* synthetic */ SyncContextProcedure val$procedure;
                    private final /* synthetic */ ReadGraph val$graph;
                    private final /* synthetic */ Object val$context;
                    {
                        this.val$cluster = clusterI;
                        this.val$subjectId = n;
                        this.val$procedure = syncContextProcedure;
                        this.val$graph = readGraph;
                        this.val$context = object;
                    }

                    @Override
                    public void run() {
                        try {
                            ClusterI.CompleteTypeEnum type = this.val$cluster.getCompleteType(this.val$subjectId, (ClusterSupport)DirectQuerySupportImpl.this.session.clusterTranslator);
                            if (ClusterI.CompleteTypeEnum.InstanceOf == type) {
                                int result = this.val$cluster.getCompleteObjectKey(this.val$subjectId, (ClusterSupport)DirectQuerySupportImpl.this.session.clusterTranslator);
                                this.val$procedure.execute(this.val$graph, this.val$context, (Object)new ResourceImpl((ResourceSupport)DirectQuerySupportImpl.this.session.resourceSupport, result));
                            } else {
                                this.val$procedure.execute(this.val$graph, this.val$context, null);
                            }
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("forPossibleDirectType requestCluster callback failed", (Throwable)e);
                        }
                    }
                });
            } else {
                ClusterI.CompleteTypeEnum type = cluster.getCompleteType(subjectId, (ClusterSupport)this.session.clusterTranslator);
                if (ClusterI.CompleteTypeEnum.InstanceOf == type) {
                    int result = cluster.getCompleteObjectKey(subjectId, (ClusterSupport)this.session.clusterTranslator);
                    procedure.execute(graph, context, (Object)new ResourceImpl((ResourceSupport)this.session.resourceSupport, result));
                } else {
                    procedure.execute(graph, context, null);
                }
            }
        }
        catch (DatabaseException databaseException) {
            procedure.execute(graph, context, null);
        }
        catch (Throwable t) {
            LOGGER.error("forPossibleDirectType failed unexpectedly", t);
            procedure.execute(graph, context, null);
        }
    }

    private <C, T> T getRelatedValue4(ReadGraphImpl graph, int subject, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) throws DatabaseException {
        int result = 0;
        int predicate = procedure.predicateKey;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, g -> {});
                return this.getRelatedValue4(graph, subject, context, procedure);
            }
            for (TransientGraph g2 : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g2.getObjects(subject, predicate);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (result != 0) {
                        throw new DatabaseException("Multiple objects");
                    }
                    result = id;
                    ++n2;
                }
            }
            if (result == 0) {
                throw new DatabaseException("No objects for " + subject);
            }
            return this.getValue4(graph, null, result, context, procedure);
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            cluster.load();
            return this.getRelatedValue4(graph, subject, context, procedure);
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, g -> {});
                return this.getRelatedValue4(graph, subject, context, procedure);
            }
            for (TransientGraph g3 : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g3.getObjects(subject, predicate);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    if (result != 0) {
                        throw new DatabaseException("Multiple objects");
                    }
                    result = id;
                    ++n3;
                }
            }
            return this.getRelatedDirectValue4(graph, cluster, subject, result, context, procedure);
        }
        return this.getRelatedDirectValue4(graph, cluster, subject, 0, context, procedure);
    }

    private <T> T getValue4(ReadGraphImpl graph, ClusterImpl containerCluster, int subject, ForPossibleRelatedValueProcedure<T> procedure) throws DatabaseException {
        byte[] result = null;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, g -> {});
                return this.getValue4(graph, containerCluster, subject, procedure);
            }
            for (TransientGraph g2 : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g2.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    throw new DatabaseException("Multiple values");
                }
                result = value;
            }
            return (T)"name";
        }
        ClusterImpl cluster = containerCluster;
        if (!containerCluster.contains(subject) && !(cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject))).isLoaded()) {
            cluster.load();
            return this.getValue4(graph, containerCluster, subject, procedure);
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, g -> {});
                return this.getValue4(graph, containerCluster, subject, procedure);
            }
            for (TransientGraph g3 : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g3.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    throw new DatabaseException("Multiple values");
                }
                result = value;
            }
            if (result != null) {
                return (T)result;
            }
            if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
                return this.getDirectValue4(graph, (ClusterSmall)cluster, subject);
            }
            return this.getDirectValue4(graph, (ClusterBig)cluster, subject);
        }
        if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
            return this.getDirectValue4(graph, (ClusterSmall)cluster, subject);
        }
        return this.getDirectValue4(graph, (ClusterBig)cluster, subject);
    }

    private <C, T> T getValue4(ReadGraphImpl graph, ClusterImpl containerCluster, int subject, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) throws DatabaseException {
        byte[] result = null;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, g -> {});
                return this.getValue4(graph, containerCluster, subject, context, procedure);
            }
            for (TransientGraph g2 : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g2.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    throw new DatabaseException("Multiple values");
                }
                result = value;
            }
            return (T)"name";
        }
        ClusterImpl cluster = containerCluster;
        if (!containerCluster.contains(subject) && !(cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject))).isLoaded()) {
            cluster.load();
            return this.getValue4(graph, containerCluster, subject, context, procedure);
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, g -> {});
                return this.getValue4(graph, containerCluster, subject, context, procedure);
            }
            for (TransientGraph g3 : this.session.virtualGraphServerSupport.providers) {
                byte[] value = g3.getValue(subject);
                if (value == null) continue;
                if (result != null) {
                    throw new DatabaseException("Multiple values");
                }
                result = value;
            }
            if (result != null) {
                return (T)result;
            }
            if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
                return this.getDirectValue4(graph, (ClusterSmall)cluster, subject);
            }
            return this.getDirectValue4(graph, (ClusterBig)cluster, subject);
        }
        if (ClusterI.ClusterTypeEnum.SMALL == cluster.getType()) {
            return this.getDirectValue4(graph, (ClusterSmall)cluster, subject);
        }
        return this.getDirectValue4(graph, (ClusterBig)cluster, subject);
    }

    private <T> T getRelatedDirectValue4(ReadGraphImpl graph, ClusterImpl cluster, int subject, int result, ForPossibleRelatedValueProcedure<T> procedure) throws DatabaseException {
        int so = cluster.getSingleObject(subject, procedure, (ClusterSupport)this.session.clusterTranslator);
        if (so == 0) {
            if (result == 0) {
                throw new DatabaseException("No objects " + subject + " " + procedure.predicateKey);
            }
            return this.getValue4(graph, cluster, result, procedure);
        }
        if (result == 0) {
            return this.getValue4(graph, cluster, so, procedure);
        }
        throw new DatabaseException("Multiple objects");
    }

    private <C, T> T getRelatedDirectValue4(ReadGraphImpl graph, ClusterImpl cluster, int subject, int result, C context, ForPossibleRelatedValueContextProcedure<C, T> procedure) throws DatabaseException {
        int so = cluster.getSingleObject(subject, procedure, (ClusterSupport)this.session.clusterTranslator);
        if (so == 0) {
            if (result == 0) {
                throw new NoSingleResultException("No objects " + subject + " " + procedure.predicateKey, result);
            }
            return this.getValue4(graph, cluster, result, context, procedure);
        }
        if (result == 0) {
            return this.getValue4(graph, cluster, so, context, procedure);
        }
        throw new NoSingleResultException("Multiple objects for " + subject + " " + procedure.predicateKey, result);
    }

    public <T> T getRelatedValue4(ReadGraphImpl graph, int subject, ForPossibleRelatedValueProcedure<T> procedure) throws DatabaseException {
        int result = 0;
        int predicate = procedure.predicateKey;
        if (subject < 0) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, g -> {});
                return this.getRelatedValue4(graph, subject, procedure);
            }
            for (TransientGraph g2 : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g2.getObjects(subject, predicate);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    if (result != 0) {
                        throw new DatabaseException("Multiple objects");
                    }
                    result = id;
                    ++n2;
                }
            }
            if (result == 0) {
                throw new DatabaseException("No objects for " + subject);
            }
            return this.getValue4(graph, null, result, procedure);
        }
        ClusterImpl cluster = (ClusterImpl)((Object)this.session.clusterTable.getClusterByResourceKey(subject));
        if (!cluster.isLoaded()) {
            cluster.load();
            return this.getRelatedValue4(graph, subject, procedure);
        }
        if (cluster.hasVirtual() && this.session.virtualGraphServerSupport.virtuals.contains(subject)) {
            if (!SessionImplSocket.areVirtualStatementsLoaded(this.session.virtualGraphServerSupport, subject, predicate)) {
                SessionImplSocket.loadVirtualStatements(this.session.virtualGraphServerSupport, graph, subject, predicate, g -> {});
                return this.getRelatedValue4(graph, subject, procedure);
            }
            for (TransientGraph g3 : this.session.virtualGraphServerSupport.providers) {
                int[] nArray = g3.getObjects(subject, predicate);
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int id = nArray[n3];
                    if (result != 0) {
                        throw new DatabaseException("Multiple objects");
                    }
                    result = id;
                    ++n3;
                }
            }
            return this.getRelatedDirectValue4(graph, cluster, subject, result, procedure);
        }
        return this.getRelatedDirectValue4(graph, cluster, subject, 0, procedure);
    }

    private <T> T getDirectValue4(ReadGraphImpl graph, ClusterBig cluster, int subject) throws DatabaseException {
        byte[] bytes = cluster.getValue(subject, (ClusterSupport)this.session.clusterTranslator);
        return (T)DirectQuerySupportImpl.utf(bytes, 0);
    }

    private <T> T getDirectValue4(ReadGraphImpl graph, ClusterSmall cluster, int subject) throws DatabaseException {
        int size;
        ResourceTableSmall rt = cluster.resourceTable;
        ValueTableSmall vt = cluster.valueTable;
        byte[] bs = (byte[])vt.table;
        long[] ls = (long[])rt.table;
        int index = ((subject & 0xFFF) << 1) - 1 + rt.offset;
        int valueIndex = ((int)(ls[index] >>> 24) & 0x3FFFFF) + vt.offset;
        if ((size = bs[valueIndex++]) < 0) {
            size = (size & 0x7F) << 8 | bs[valueIndex++] & 0xFF;
        }
        if (size <= 0) {
            throw new DatabaseException("No value for " + subject);
        }
        return (T)DirectQuerySupportImpl.utf(bs, valueIndex);
    }

    private static final String utf(byte[] bytes, int offset) throws AssumptionException {
        int c;
        int length;
        if (bytes == null) {
            return null;
        }
        int index = offset;
        if ((length = bytes[index++] & 0xFF) >= 128) {
            if (length >= 192) {
                if (length >= 224) {
                    if (length >= 240) {
                        length &= 0xF;
                        length += (bytes[index++] & 0xFF) << 3;
                        length += (bytes[index++] & 0xFF) << 11;
                        length += (bytes[index++] & 0xFF) << 19;
                        length += 270549120;
                    } else {
                        length &= 0x1F;
                        length += (bytes[index++] & 0xFF) << 4;
                        length += (bytes[index++] & 0xFF) << 12;
                        length += (bytes[index++] & 0xFF) << 20;
                        length += 2113664;
                    }
                } else {
                    length &= 0x3F;
                    length += (bytes[index++] & 0xFF) << 5;
                    length += (bytes[index++] & 0xFF) << 13;
                    length += 16512;
                }
            } else {
                length &= 0x7F;
                length += (bytes[index++] & 0xFF) << 6;
                length += 128;
            }
        }
        int utflen = length;
        char[] chararr = new char[utflen];
        int count = index;
        int target = index + length;
        int chararr_count = 0;
        while (count < target) {
            c = bytes[count] & 0xFF;
            if (c > 127) break;
            ++count;
            chararr[chararr_count++] = (char)c;
        }
        while (count < target) {
            c = bytes[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > target) {
                        throw new AssumptionException("malformed input: partial character at end (" + (count - index) + " > " + utflen + ")");
                    }
                    byte char2 = bytes[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new AssumptionException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > target) {
                        throw new AssumptionException("malformed input: partial character at end (" + (count - index) + " > " + utflen + ")");
                    }
                    byte char2 = bytes[count - 2];
                    byte char3 = bytes[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new AssumptionException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new AssumptionException("malformed input around byte " + count);
                }
            }
        }
        return new String(chararr, 0, chararr_count);
    }
}

