/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.processor.MergingGraphRequestProcessor;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteOnly;
import org.simantics.project.IProject;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.IProjectFeature;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.disposable.IDisposeListener;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Project
extends HintContext
implements IProject {
    private static final Logger LOGGER = LoggerFactory.getLogger(Project.class);
    private static IProjectFeature[] NONE = new IProjectFeature[0];
    private IProjectFeature[] features = NONE;
    private final LinkedList<IProjectFeature> featureSet = new LinkedList();
    private final LinkedList<IProjectFeature> inactiveFeatures = new LinkedList();
    private final LinkedList<IProjectFeature> activeFeatures = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean active = new AtomicBoolean(false);
    protected Session session;
    protected Resource resource;
    SyncListenerList<IDisposeListener> disposeListeners = null;
    private volatile DisposeState disposeStatus = DisposeState.Alive;
    private static final Method onDisposed = SyncListenerList.getMethod(IDisposeListener.class, (String)"onDisposed");

    public Project(Session session, Resource resource) {
        if (session == null) {
            throw new NullPointerException("null session");
        }
        if (resource == null) {
            throw new NullPointerException("null resource");
        }
        this.session = session;
        this.resource = resource;
    }

    public void doDispose() {
        this.lock.lock();
        try {
            try {
                this.deactivate();
                this.featureSet.clear();
                this.features = NONE;
            }
            catch (ProjectException e1) {
                e1.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IProjectFeature[] getFeatures() {
        this.assertNotDisposed();
        IProjectFeature[] features = this.features;
        return Arrays.copyOf(features, features.length);
    }

    public void addFeature(IProjectFeature feature) {
        this.assertNotDisposed();
        this.lock.lock();
        try {
            if (!this.featureSet.contains(feature)) {
                this.featureSet.add(feature);
                this.inactiveFeatures.add(feature);
                this.features = this.featureSet.toArray(new IProjectFeature[this.featureSet.size()]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void activate() throws ProjectException {
        if (this.isDisposed()) {
            throw new IllegalStateException("project is disposed, cannot activate " + this + " (" + System.identityHashCode(this) + ")");
        }
        this.lock.lock();
        try {
            if (this.active.get()) {
                this.lock.unlock();
                return;
            }
            if (true) ** GOTO lbl28
        }
        catch (Throwable var4_5) {
            this.lock.unlock();
            throw var4_5;
        }
        do {
            feature = this.inactiveFeatures.getFirst();
            success = false;
            try {
                Project.LOGGER.info("Configuring project feature {}", (Object)feature);
                feature.setProjectElement(this);
                feature.configure();
                this.inactiveFeatures.removeFirst();
                this.activeFeatures.addLast(feature);
                success = true;
            }
            finally {
                if (!success) {
                    feature.setProjectElement(null);
                }
            }
lbl28:
            // 2 sources

        } while (!this.inactiveFeatures.isEmpty());
        try {
            this.transactionBarrier();
        }
        finally {
            this.active.set(true);
        }
        this.lock.unlock();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deactivate() throws ProjectException {
        if (this.isDisposed()) {
            throw new IllegalStateException("project is disposed, cannot deactivate " + this + " (" + System.identityHashCode(this) + ")");
        }
        this.lock.lock();
        try {
            if (!this.active.get()) {
                this.lock.unlock();
                return;
            }
            if (true) ** GOTO lbl26
        }
        catch (Throwable var4_5) {
            this.lock.unlock();
            throw var4_5;
        }
        do {
            feature = this.activeFeatures.getLast();
            success = false;
            try {
                feature.deconfigure();
                this.activeFeatures.removeLast();
                this.inactiveFeatures.addFirst(feature);
                success = true;
            }
            finally {
                if (success) {
                    feature.setProjectElement(null);
                }
            }
lbl26:
            // 2 sources

        } while (!this.activeFeatures.isEmpty());
        try {
            this.transactionBarrier();
        }
        finally {
            this.active.set(false);
        }
        this.lock.unlock();
    }

    private void transactionBarrier() throws ProjectException {
        try {
            this.session.syncRequest((WriteOnly)new WriteOnlyRequest(){

                public void perform(WriteOnlyGraph graph) throws DatabaseException {
                    throw new CancelTransactionException("barrier");
                }
            });
        }
        catch (CancelTransactionException cancelTransactionException) {
        }
        catch (DatabaseException e) {
            throw new ProjectException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [resource=" + this.get().getResourceId() + "]";
    }

    public int hashCode() {
        return this.get().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        if (!this.session.equals(other.session)) {
            return false;
        }
        Resource r1 = this.get();
        Resource r2 = other.get();
        return !(r1 == null ? r2 != null : !r1.equals(r2));
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public Resource get() {
        return this.resource;
    }

    public RequestProcessor getGraphRequestProcessor() {
        MergingGraphRequestProcessor mgrp = (MergingGraphRequestProcessor)this.session.peekService(MergingGraphRequestProcessor.class);
        return mgrp != null ? mgrp : this.session;
    }

    protected void assertNotDisposed() {
        if (this.isDisposed()) {
            throw new IllegalStateException(this + " is disposed");
        }
    }

    public DisposeState getDisposeState() {
        return this.disposeStatus;
    }

    public boolean isDisposed() {
        return this.disposeStatus == DisposeState.Disposed;
    }

    public boolean isAlive() {
        return this.disposeStatus == DisposeState.Alive;
    }

    public void dispose() {
        try {
            this.lock.lock();
            try {
                if (this.disposeStatus == DisposeState.Disposing) {
                    return;
                }
                this.assertNotDisposed();
                this.disposeStatus = DisposeState.Disposing;
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        finally {
            this.disposeStatus = DisposeState.Disposed;
        }
    }

    public void safeDispose() {
        try {
            this.lock.lock();
            try {
                if (this.disposeStatus != DisposeState.Alive) {
                    return;
                }
                this.disposeStatus = DisposeState.Disposing;
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.fireDisposed();
            }
            finally {
                this.doDispose();
            }
        }
        finally {
            this.disposeStatus = DisposeState.Disposed;
        }
    }

    protected boolean hasDisposeListeners() {
        return this.disposeListeners != null && !this.disposeListeners.isEmpty();
    }

    private void fireDisposed() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventSync(onDisposed, new Object[]{this});
    }

    private void fireDisposedAsync() {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.fireEventAsync(onDisposed, new Object[]{this});
    }

    public void addDisposeListener(IDisposeListener listener) {
        this.lazyGetListenerList().add((Object)listener);
    }

    public void addDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        this.lazyGetListenerList().add(thread, (Object)listener);
    }

    public void removeDisposeListener(IDisposeListener listener) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove((Object)listener);
    }

    public void removeDisposeListener(IDisposeListener listener, IThreadWorkQueue thread) {
        if (this.disposeListeners == null) {
            return;
        }
        this.disposeListeners.remove(thread, (Object)listener);
    }

    private synchronized SyncListenerList<IDisposeListener> lazyGetListenerList() {
        if (this.disposeListeners == null) {
            this.disposeListeners = new SyncListenerList(IDisposeListener.class);
        }
        return this.disposeListeners;
    }
}

