/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.io.PrintStream;
import org.simantics.graphviz.AbstractIdentifiableGraphPart;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;

public class Node
extends AbstractIdentifiableGraphPart {
    public Node(IGraph graph) {
        this(graph, "");
    }

    public Node(IGraph graph, String label) {
        super(graph);
        this.setLabel(label);
    }

    @Override
    public void write(PrintStream s) {
        s.print(this.id);
        this.writeAttributes(s);
    }

    public void setLabel(String label) {
        this.set("label", label);
    }

    public void setColor(String color) {
        this.set("color", color);
    }

    public void setFillColor(String color) {
        this.set("fillcolor", color);
    }

    public void setFontColor(String color) {
        this.set("fontcolor", color);
    }

    public void setStyle(String style) {
        this.set("style", style);
    }

    public void setShape(String shape) {
        this.set("shape", shape);
    }

    public void setWidth(double width) {
        this.set("width", Double.toString(width));
    }

    public void setHeight(double width) {
        this.set("height", Double.toString(width));
    }

    public void setFixedSize(boolean fixedSize) {
        this.set("fixedsize", Boolean.toString(fixedSize));
    }

    public Identifiable getPort(final String portName) {
        return new Identifiable(){

            @Override
            public String getId() {
                return String.valueOf(Node.this.id) + ":" + portName;
            }

            @Override
            public IGraph getParent() {
                return Node.this.parent;
            }
        };
    }
}

