/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.refactoring.TransferableGraphHasher;
import org.simantics.graph.representation.PrettyPrintTG;
import org.simantics.graph.representation.TransferableGraph1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixExportedOntology {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixExportedOntology.class);

    static TransferableGraph1 convertExportedSharedOntologyIntoBundleOntology(Path input, Path output) throws Exception {
        LOGGER.info("Converting exported shared ontology\n\t{}\nto bundle-compatible ontology\n\t{}", (Object)input.toString(), (Object)output.toString());
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]), 131072);){
            Binding tgBinding = TransferableGraph1.BINDING;
            DataContainer container = DataContainers.readFile((DataInput)new DataInputStream(is), (Binding)tgBinding);
            TransferableGraph1 graph = (TransferableGraph1)container.content.getValue(tgBinding);
            GraphRefactoringUtils.fixOntologyExport(graph);
            container = TransferableGraphHasher.addHashToTG(container, graph);
            DataContainers.writeFile((File)output.toFile(), (DataContainer)container);
            return graph;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Path replaceExtension(Path p, String newExtension) {
        String newName = p.getFileName().toString();
        if (newName.contains(".")) {
            newName = newName.split("\\.")[0];
        }
        return p.resolveSibling(String.valueOf(newName) + newExtension);
    }

    private static void createTg(Path input, Path output) throws Exception {
        FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(input, output);
    }

    public static void createTg(Path input) throws Exception {
        FixExportedOntology.createTg(input, FixExportedOntology.replaceExtension(input, ".tg"));
    }

    public static void createTGAndPGraph(Path input) throws Exception {
        FixExportedOntology.createTGAndPGraph(input, true);
    }

    public static void createTGAndPGraph(Path input, boolean writePGraph) throws Exception {
        TransferableGraph1 tg = FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(input, FixExportedOntology.replaceExtension(input, ".tg"));
        if (writePGraph) {
            String listing = PrettyPrintTG.print(tg, false);
            Files.write(FixExportedOntology.replaceExtension(input, ".pgraph"), listing.getBytes(), StandardOpenOption.CREATE);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Required arguments: <input .sharedLibrary file> [<output .tg file>]");
        } else if (args.length == 1) {
            Path input = Paths.get(args[0], new String[0]);
            FixExportedOntology.createTGAndPGraph(input);
        } else {
            FixExportedOntology.convertExportedSharedOntologyIntoBundleOntology(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
        }
    }
}

