/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.diff;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.diff.Statement;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.matching.GraphMatching;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class Diff
extends GraphMatching {
    TransferableGraph1 a;
    TransferableGraph1 b;

    public Diff(TransferableGraph1 a, TransferableGraph1 b) {
        super(a, b);
        this.a = a;
        this.b = b;
    }

    static THashSet<Statement> createStatementSet(int[] statements) {
        THashSet result = new THashSet();
        int i = 0;
        while (i < statements.length) {
            result.add((Object)new Statement(statements[i], statements[i + 1], statements[i + 2], statements[i + 3]));
            i += 4;
        }
        return result;
    }

    public TransferableGraphDelta1 diff() {
        Identity id;
        this.match();
        long begin = System.nanoTime();
        THashSet<Statement> aStatements = Diff.createStatementSet(this.a.statements);
        ArrayList<Statement> bStatements = new ArrayList<Statement>();
        int[] statements = this.b.statements;
        int i = 0;
        while (i < statements.length) {
            Statement statement = new Statement(statements[i], statements[i + 1], statements[i + 2], statements[i + 3]);
            Statement mappedStatement = statement.map(this.bToA);
            if (mappedStatement == null || !aStatements.remove((Object)mappedStatement)) {
                bStatements.add(statement);
            }
            i += 4;
        }
        TIntObjectHashMap aIdentities = new TIntObjectHashMap();
        ArrayList<Identity> bIdentities = new ArrayList<Identity>();
        Identity[] identityArray = this.a.identities;
        int n = this.a.identities.length;
        int n2 = 0;
        while (n2 < n) {
            id = identityArray[n2];
            aIdentities.put(id.resource, (Object)id.definition);
            ++n2;
        }
        identityArray = this.b.identities;
        n = this.b.identities.length;
        n2 = 0;
        while (n2 < n) {
            id = identityArray[n2];
            int a = this.bToA[id.resource];
            IdentityDefinition def = (IdentityDefinition)aIdentities.get(a);
            if (def != null && Diff.identityDefinitionEquals(this.bToA, def, id.definition)) {
                aIdentities.remove(a);
            } else {
                bIdentities.add(id);
            }
            ++n2;
        }
        TIntObjectHashMap aValues = new TIntObjectHashMap();
        ArrayList<Value> bValues = new ArrayList<Value>();
        Value[] valueArray = this.a.values;
        int n3 = this.a.values.length;
        int n4 = 0;
        while (n4 < n3) {
            Value value = valueArray[n4];
            aValues.put(value.resource, (Object)value.value);
            ++n4;
        }
        valueArray = this.b.values;
        n3 = this.b.values.length;
        n4 = 0;
        while (n4 < n3) {
            Value value = valueArray[n4];
            int a = this.bToA[value.resource];
            Variant aValue = (Variant)aValues.get(a);
            if (aValue != null && aValue.equals((Object)value.value)) {
                aValues.remove(a);
            } else {
                bValues.add(value);
            }
            ++n4;
        }
        TransferableGraphDelta1 result = new TransferableGraphDelta1(this.aToB, new TransferableGraph1(this.a.resourceCount, Diff.toIdentityArray((TIntObjectHashMap<IdentityDefinition>)aIdentities), Diff.toStatementArray(aStatements), Diff.toValueArray((TIntObjectHashMap<Variant>)aValues)), new TransferableGraph1(this.b.resourceCount, bIdentities.toArray(new Identity[bIdentities.size()]), Diff.toStatementArray(bStatements), bValues.toArray(new Value[bValues.size()])));
        return result;
    }

    private static boolean identityDefinitionEquals(int[] bToA, IdentityDefinition a, IdentityDefinition b) {
        String aName;
        int aParent;
        String bName;
        int bParent;
        IdentityDefinition def;
        if (a instanceof Root) {
            return b instanceof Root && ((Root)a).name.equals(((Root)b).name);
        }
        if (b instanceof Root) {
            return false;
        }
        if (b instanceof External) {
            def = (External)b;
            bParent = def.parent;
            bName = def.name;
        } else if (b instanceof Internal) {
            def = (Internal)b;
            bParent = ((Internal)def).parent;
            bName = ((Internal)def).name;
        } else if (b instanceof Optional) {
            def = (Optional)b;
            bParent = ((Optional)def).parent;
            bName = ((Optional)def).name;
        } else {
            return false;
        }
        bParent = bToA[bParent];
        if (bParent < 0) {
            return false;
        }
        if (a instanceof External) {
            def = (External)a;
            aParent = def.parent;
            aName = def.name;
        } else if (a instanceof Internal) {
            def = (Internal)a;
            aParent = ((Internal)def).parent;
            aName = ((Internal)def).name;
        } else if (a instanceof Optional) {
            def = (Optional)a;
            aParent = ((Optional)def).parent;
            aName = ((Optional)def).name;
        } else {
            return false;
        }
        return aParent == bParent && aName.equals(bName);
    }

    static int[] toStatementArray(Collection<Statement> statements) {
        int[] result = new int[4 * statements.size()];
        int i = 0;
        for (Statement statement : statements) {
            result[i++] = statement.subject;
            result[i++] = statement.predicate;
            result[i++] = statement.inverse;
            result[i++] = statement.object;
        }
        return result;
    }

    static Value[] toValueArray(TIntObjectHashMap<Variant> values) {
        final Value[] result = new Value[values.size()];
        values.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Variant>(){
            int i = 0;

            public boolean execute(int a, Variant b) {
                result[this.i++] = new Value(a, b);
                return true;
            }
        });
        return result;
    }

    static Identity[] toIdentityArray(TIntObjectHashMap<IdentityDefinition> identities) {
        final Identity[] result = new Identity[identities.size()];
        identities.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<IdentityDefinition>(){
            int i = 0;

            public boolean execute(int a, IdentityDefinition b) {
                result[this.i++] = new Identity(a, b);
                return true;
            }
        });
        return result;
    }
}

