/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.sorters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class LinkedListSorter
implements Sorter {
    public static final LinkedListSorter INSTANCE = new LinkedListSorter();

    private LinkedListSorter() {
    }

    @Override
    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<Resource> parents = new HashSet<Resource>();
        HashMap<Resource, NodeContext> map = new HashMap<Resource, NodeContext>();
        for (NodeContext node : nodes) {
            Resource r = (Resource)node.getConstant(BuiltinKeys.INPUT);
            Resource parent = graph.getPossibleObject(r, L0.PartOf);
            parents.add(parent);
            map.put(r, node);
        }
        if (parents.contains(null)) {
            return;
        }
        if (parents.size() != 1) {
            return;
        }
        Resource parent = (Resource)parents.iterator().next();
        nodes.clear();
        for (Resource r : ListUtils.toList((ReadGraph)graph, (Resource)parent)) {
            NodeContext ctx = (NodeContext)map.get(r);
            if (ctx == null) continue;
            nodes.add(ctx);
        }
    }
}

