/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.geom.AffineTransform;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.exception.DebugException;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.CacheListener;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.diagram.adapter.BaseRequest2;
import org.simantics.diagram.adapter.ConnectionInfo;
import org.simantics.diagram.adapter.ConnectionRequest;
import org.simantics.diagram.adapter.ConnectionRequest2;
import org.simantics.diagram.adapter.ConnectionSegmentAdapter;
import org.simantics.diagram.adapter.ConnectionVisualsLoader;
import org.simantics.diagram.adapter.DiagramContentRequest;
import org.simantics.diagram.adapter.DisposableListener;
import org.simantics.diagram.adapter.EdgeRequest;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.adapter.LoadRequest;
import org.simantics.diagram.adapter.NodeClassRequest;
import org.simantics.diagram.adapter.NodeRequest;
import org.simantics.diagram.adapter.NodeRequest2;
import org.simantics.diagram.connection.ConnectionSegmentEnd;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.DesignatedTerminal;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.DiagramContents;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.internal.timing.GTask;
import org.simantics.diagram.internal.timing.Timing;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.synchronization.CollectingModificationQueue;
import org.simantics.diagram.synchronization.CompositeModification;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.IModification;
import org.simantics.diagram.synchronization.LogErrorHandler;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.ElementLoader;
import org.simantics.diagram.synchronization.graph.ElementReorder;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationContext;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.ModificationQueue;
import org.simantics.diagram.synchronization.graph.TagChange;
import org.simantics.diagram.synchronization.graph.TransformElement;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.EndKeyOf;
import org.simantics.g2d.connection.TerminalKeyOf;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.DiagramHandler;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.diagram.handler.SubstituteElementClass;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.ElementLayerListener;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.g2d.routing.RouterFactory;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.DataNodeConstants;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.common.ProfileObserver;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.map.AssociativeMap;
import org.simantics.utils.datastructures.map.Associativity;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphToDiagramSynchronizer
extends AbstractDisposable
implements IDiagramLoader,
IModifiableSynchronizationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphToDiagramSynchronizer.class);
    private static final boolean USE_ELEMENT_VALIDATING_LISTENERS = false;
    private static final IHintContext.Key KEY_CONNECTION_BEGIN_PLACEHOLDER = new IHintContext.KeyOf(PlaceholderConnection.class, "CONNECTION_BEGIN_PLACEHOLDER");
    private static final IHintContext.Key KEY_CONNECTION_END_PLACEHOLDER = new IHintContext.KeyOf(PlaceholderConnection.class, "CONNECTION_END_PLACEHOLDER");
    private static final IHintContext.Key KEY_REMOVE_RELATIONSHIPS = new IHintContext.KeyOf(Boolean.class, "REMOVE_RELATIONSHIPS");
    static ErrorHandler errorHandler = LogErrorHandler.INSTANCE;
    ICanvasContext canvas;
    Session session;
    ReentrantLock diagramUpdateLock = new ReentrantLock();
    GraphToDiagramUpdater currentUpdater = null;
    ConcurrentMap<Object, IElement> dataElement = new ConcurrentHashMap<Object, IElement>();
    Collection<Topology.Connection> tempConnections = new ArrayList<Topology.Connection>();
    ListenerSupport canvasListenerSupport = new ListenerSupport(){

        public void exception(Throwable t) {
            GraphToDiagramSynchronizer.this.error(t);
        }

        public boolean isDisposed() {
            return !GraphToDiagramSynchronizer.this.isAlive() || GraphToDiagramSynchronizer.this.canvas.isDisposed();
        }
    };
    ConcurrentMap<Object, ConnectionEntityImpl> dataConnection = new ConcurrentHashMap<Object, ConnectionEntityImpl>();
    final DataElementMapImpl dataElementMap = new DataElementMapImpl();
    final SubstituteElementClassImpl substituteElementClass = new SubstituteElementClassImpl();
    ModificationQueue modificationQueue;
    IModifiableSynchronizationContext synchronizationContext;
    DiagramContents previousContent;
    IDiagram diagram;
    ProfileObserver profileObserver;
    IElementClassProvider elementClassProvider;
    BasicResources br;
    public static final EnumSet<State> FROM_INITIAL = EnumSet.of(State.LOADING, State.DISPOSED);
    public static final EnumSet<State> FROM_LOADING = EnumSet.of(State.IDLE);
    public static final EnumSet<State> FROM_UPDATING_DIAGRAM = EnumSet.of(State.IDLE);
    public static final EnumSet<State> FROM_IDLE = EnumSet.of(State.UPDATING_DIAGRAM, State.DISPOSED);
    public static final EnumSet<State> NO_STATES = EnumSet.noneOf(State.class);
    State synchronizerState = State.INITIAL;
    ReentrantLock stateLock = new ReentrantLock();
    Condition idleCondition = this.stateLock.newCondition();
    GraphLayerManager layerManager;
    ElementLayerListenerImpl elementLayerListener = new ElementLayerListenerImpl();
    ArrayList<IModification> pendingModifications = new ArrayList();
    MapSet<IElement, IModification> modificationIndex = new MapSet.Hash();
    private static final Double DIAGRAM_UPDATE_DIAGRAM_PRIORITY = 1.0;
    private static final Double DIAGRAM_UPDATE_NODE_PRIORITY = 2.0;
    private static final Double DIAGRAM_UPDATE_CONNECTION_PRIORITY = 3.0;
    private static final Double DIAGRAM_UPDATE_EDGE_PRIORITY = 4.0;
    Object graphUpdateLock = new Object();
    TransactionListener sessionListener = null;
    AtomicBoolean inWriteTransaction = new AtomicBoolean(false);
    AtomicBoolean graphUpdateRequestScheduled = new AtomicBoolean(false);
    List<GraphUpdateReactor> queuedGraphUpdates = new ArrayList<GraphUpdateReactor>();
    IHintListener elementHintValidator = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (!(sender instanceof Element)) {
                throw new IllegalStateException("invalid sender: " + sender);
            }
            Element e = (Element)sender;
            if (newValue != null) {
                if (key instanceof TerminalKeyOf) {
                    Topology.Connection c = (Topology.Connection)newValue;
                    if (e != c.node) {
                        throw new IllegalStateException("TerminalKeyOf hint of node " + e + " refers to a different node " + c.node + ". Should be the same.");
                    }
                    Object edgeObject = ElementUtils.getObject((IElement)c.edge);
                    if (!(edgeObject instanceof EdgeResource)) {
                        throw new IllegalStateException("EndKeyOf hint of edge " + c.edge + " refers contains an invalid object: " + edgeObject);
                    }
                } else if (key instanceof EndKeyOf) {
                    Topology.Connection c = (Topology.Connection)newValue;
                    if (e != c.edge) {
                        throw new IllegalStateException("EndKeyOf hint of edge " + e + " refers to a different edge " + c.edge + ". Should be the same.");
                    }
                    Object edgeObject = ElementUtils.getObject((IElement)c.edge);
                    if (!(edgeObject instanceof EdgeResource)) {
                        throw new IllegalStateException("EndKeyOf hint of edge " + e + " refers contains an invalid object: " + edgeObject);
                    }
                }
            }
        }
    };
    DiagramListener diagramListener = new DiagramListener();
    ElementFactoryImpl elementFactory = new ElementFactoryImpl();
    public static final Object FIRST_TIME = new Object(){

        public String toString() {
            return "FIRST_TIME";
        }
    };
    Topology diagramTopology = new TopologyImpl();
    RelationshipHandler relationshipHandler = new RelationshipHandler(){
        AssociativeMap map = new AssociativeMap(new Associativity[]{Associativity.of((boolean[])new boolean[]{true, false, false})});

        Object getPossibleObjectOrElement(Object o) {
            if (o instanceof IElement) {
                IElement e = (IElement)o;
                Object oo = e.getHint(ElementHints.KEY_OBJECT);
                return oo != null ? oo : e;
            }
            return o;
        }

        IElement getElement(Object o) {
            if (o instanceof IElement) {
                return (IElement)o;
            }
            return GraphToDiagramSynchronizer.this.getMappedElement(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void claim(IDiagram diagram, Object subject, Relationship predicate, Object object) {
            Object sd = this.getPossibleObjectOrElement(subject);
            Object od = this.getPossibleObjectOrElement(object);
            List<Tuple> ts = null;
            Relationship inverse = predicate.getInverse();
            ts = inverse != null ? Arrays.asList(new Tuple(new Object[]{sd, predicate, od}), new Tuple(new Object[]{od, inverse, sd})) : Collections.singletonList(new Tuple(new Object[]{sd, predicate, od}));
            4 var9_9 = this;
            synchronized (var9_9) {
                this.map.add(ts);
            }
            if (DebugPolicy.DEBUG_RELATIONSHIP) {
                new Exception().printStackTrace();
                System.out.println("Claimed relationships:");
                for (Tuple t : ts) {
                    System.out.println("\t" + t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDeny(IDiagram diagram, Object subject, Relationship predicate, Object object) {
            Object sd = this.getPossibleObjectOrElement(subject);
            Object od = this.getPossibleObjectOrElement(object);
            if (sd == subject || od == object) {
                System.out.println("WARNING: denying relationship '" + predicate + "' between diagram element(s), not back-end object(s): " + sd + " -> " + od);
            }
            Collection<Tuple> ts = null;
            Relationship inverse = predicate.getInverse();
            ts = inverse != null ? Arrays.asList(new Tuple(new Object[]{sd, predicate, od}), new Tuple(new Object[]{od, inverse, sd})) : Collections.singleton(new Tuple(new Object[]{sd, predicate, od}));
            4 var9_9 = this;
            synchronized (var9_9) {
                this.map.remove(ts);
            }
            if (DebugPolicy.DEBUG_RELATIONSHIP) {
                new Exception().printStackTrace();
                System.out.println("Denied relationships:");
                for (Tuple t : ts) {
                    System.out.println("\t" + t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deny(IDiagram diagram, Object subject, Relationship predicate, Object object) {
            4 var5_5 = this;
            synchronized (var5_5) {
                this.doDeny(diagram, subject, predicate, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deny(IDiagram diagram, RelationshipHandler.Relation relation) {
            4 var3_3 = this;
            synchronized (var3_3) {
                this.doDeny(diagram, relation.getSubject(), relation.getRelationship(), relation.getObject());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void denyAll(IDiagram diagram, Object element) {
            4 var3_3 = this;
            synchronized (var3_3) {
                for (RelationshipHandler.Relation relation : this.getRelations(diagram, element, null)) {
                    this.doDeny(diagram, relation.getSubject(), relation.getRelationship(), relation.getObject());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<RelationshipHandler.Relation> getRelations(IDiagram diagram, Object element, Collection<RelationshipHandler.Relation> result) {
            if (DebugPolicy.DEBUG_GET_RELATIONSHIP) {
                System.out.println("getRelations(" + element + ")");
            }
            Object e = this.getPossibleObjectOrElement(element);
            Collection tuples = null;
            4 var6_6 = this;
            synchronized (var6_6) {
                tuples = this.map.get(new Tuple(new Object[]{e, null, null}), null);
            }
            if (DebugPolicy.DEBUG_GET_RELATIONSHIP) {
                System.out.println("Result size: " + tuples.size());
                for (Tuple t : tuples) {
                    System.out.println("\t" + t);
                }
            }
            if (tuples.isEmpty()) {
                return Collections.emptyList();
            }
            if (result == null) {
                result = new ArrayList<RelationshipHandler.Relation>(tuples.size());
            }
            for (Tuple t : tuples) {
                Object obj = t.getField(2);
                IElement el = this.getElement(obj);
                Relationship r = (Relationship)t.getField(1);
                result.add(new RelationshipHandler.Relation(element, r, el != null ? el : obj));
            }
            return result;
        }
    };

    void mapElementIfNew(Object data, IElement element) {
        IElement mapped = this.getMappedElement(data);
        if (mapped == null) {
            this.mapElement(data, element);
            this.currentUpdater.addedElements.add(element);
            this.currentUpdater.addedElementMap.put(data, element);
        }
    }

    void mapElement(Object data, IElement element) {
        if (!(element instanceof Element)) {
            throw new IllegalArgumentException("mapElement: expected instance of Element, got " + element + " with data " + data);
        }
        assert (data != null);
        assert (element != null);
        if (DebugPolicy.DEBUG_MAPPING) {
            new Exception(Thread.currentThread() + " MAPPING: " + data + " -> " + element).printStackTrace();
        }
        this.dataElement.put(data, element);
    }

    IElement getMappedElement(Object data) {
        assert (data != null);
        IElement element = (IElement)this.dataElement.get(data);
        return element;
    }

    IElement getMappedElementByElementObject(IElement e) {
        if (e == null) {
            return null;
        }
        Object o = e.getHint(ElementHints.KEY_OBJECT);
        if (o == null) {
            return null;
        }
        return this.getMappedElement(o);
    }

    IElement assertMappedElement(Object data) {
        IElement element = (IElement)this.dataElement.get(data);
        assert (element != null);
        return element;
    }

    IElement unmapElement(Object data) {
        IElement element = (IElement)this.dataElement.remove(data);
        if (DebugPolicy.DEBUG_MAPPING) {
            new Exception(Thread.currentThread() + " UN-MAPPED: " + data + " -> " + element).printStackTrace();
        }
        return element;
    }

    void mapConnection(Object data, ConnectionEntityImpl connection) {
        assert (data != null);
        assert (connection != null);
        if (DebugPolicy.DEBUG_MAPPING) {
            System.out.println(Thread.currentThread() + " MAPPING CONNECTION: " + data + " -> " + connection);
        }
        this.dataConnection.put(data, connection);
    }

    ConnectionEntityImpl getMappedConnection(Object data) {
        ConnectionEntityImpl connection = (ConnectionEntityImpl)this.dataConnection.get(data);
        return connection;
    }

    ConnectionEntityImpl assertMappedConnection(Object data) {
        ConnectionEntityImpl connection = this.getMappedConnection(data);
        assert (connection != null);
        return connection;
    }

    ConnectionEntityImpl unmapConnection(Object data) {
        ConnectionEntityImpl connection = (ConnectionEntityImpl)this.dataConnection.remove(data);
        if (DebugPolicy.DEBUG_MAPPING) {
            System.out.println(Thread.currentThread() + " UN-MAPPED CONNECTION: " + data + " -> " + connection);
        }
        return connection;
    }

    void warning(String message, Exception e) {
        errorHandler.warning(message, e);
    }

    void warning(Exception e) {
        errorHandler.warning(e.getMessage(), e);
    }

    void error(String message, Throwable e) {
        errorHandler.error(message, e);
    }

    void error(Throwable e) {
        errorHandler.error(e.getMessage(), e);
    }

    @Override
    public <T> T set(IHintContext.Key key, Object value) {
        if (this.synchronizationContext == null) {
            return null;
        }
        return this.synchronizationContext.set(key, value);
    }

    @Override
    public <T> T get(IHintContext.Key key) {
        if (this.synchronizationContext == null) {
            return null;
        }
        return this.synchronizationContext.get(key);
    }

    private EnumSet<State> validTargetStates(State start) {
        switch (start) {
            case INITIAL: {
                return FROM_INITIAL;
            }
            case LOADING: {
                return FROM_LOADING;
            }
            case UPDATING_DIAGRAM: {
                return FROM_UPDATING_DIAGRAM;
            }
            case IDLE: {
                return FROM_IDLE;
            }
            case DISPOSED: {
                return NO_STATES;
            }
        }
        throw new IllegalArgumentException("unrecognized state " + (Object)((Object)start));
    }

    private String validateStateChange(State start, State end) {
        EnumSet<State> validTargets = this.validTargetStates(start);
        if (!validTargets.contains((Object)end)) {
            return "Cannot transition from " + (Object)((Object)start) + " state to " + (Object)((Object)end) + ".";
        }
        return null;
    }

    State getState() {
        return this.synchronizerState;
    }

    /*
     * Unable to fully structure code
     */
    void activateState(State newState, boolean waitForIdle) throws InterruptedException {
        this.stateLock.lock();
        try {
            block9: {
                if (!waitForIdle || this.synchronizerState == State.IDLE) break block9;
                error = this.validateStateChange(this.synchronizerState, State.IDLE);
                if (error == null) ** GOTO lbl10
                throw new IllegalStateException(error);
lbl-1000:
                // 1 sources

                {
                    if (DebugPolicy.DEBUG_STATE) {
                        System.out.println(Thread.currentThread() + " waiting for IDLE state, current=" + (Object)this.synchronizerState);
                    }
                    this.idleCondition.await();
lbl10:
                    // 2 sources

                    ** while (this.synchronizerState != State.IDLE)
                }
            }
            if ((error = this.validateStateChange(this.synchronizerState, newState)) != null) {
                throw new IllegalStateException(error);
            }
            if (DebugPolicy.DEBUG_STATE) {
                System.out.println(Thread.currentThread() + " activated state " + (Object)newState);
            }
            this.synchronizerState = newState;
            if (newState == State.IDLE) {
                this.idleCondition.signalAll();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    void idle() throws IllegalStateException, InterruptedException {
        this.activateState(State.IDLE, false);
    }

    protected void runInState(State state, StateRunnable runnable) throws InvocationTargetException {
        try {
            this.activateState(state, true);
            try {
                runnable.execute();
            }
            finally {
                this.idle();
            }
        }
        catch (IllegalStateException e) {
            throw new InvocationTargetException(e);
        }
        catch (InterruptedException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void safeRunInState(State state, StateRunnable runnable) {
        try {
            this.runInState(state, runnable);
        }
        catch (InvocationTargetException e) {
            this.error("Failed to run runnable " + runnable + " in state " + (Object)((Object)state) + ". See exception for details.", e.getCause());
        }
    }

    public GraphToDiagramSynchronizer(RequestProcessor processor, ICanvasContext canvas, IElementClassProvider elementClassProvider) throws DatabaseException {
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        if (canvas == null) {
            throw new IllegalArgumentException("null canvas");
        }
        if (elementClassProvider == null) {
            throw new IllegalArgumentException("null element class provider");
        }
        this.session = processor.getSession();
        this.canvas = canvas;
        this.modificationQueue = new ModificationQueue((RequestProcessor)this.session, errorHandler);
        processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphToDiagramSynchronizer.this.initializeResources(graph);
            }
        });
        this.elementClassProvider = elementClassProvider;
        this.synchronizationContext.set(SynchronizationHints.ELEMENT_CLASS_PROVIDER, elementClassProvider);
        this.attachSessionListener(processor.getSession());
    }

    public IElementClassProvider getElementClassProvider() {
        return this.elementClassProvider;
    }

    public Session getSession() {
        return this.session;
    }

    public ICanvasContext getCanvasContext() {
        return this.canvas;
    }

    public IDiagram getDiagram() {
        return this.diagram;
    }

    void setCanvasDirty() {
        ICanvasContext c = this.canvas;
        if (this.synchronizerState != State.LOADING && c != null && !c.isDisposed()) {
            c.getContentContext().setDirty();
        }
    }

    public ElementClass getNodeClass(Resource elementType) throws DatabaseException {
        return this.getNodeClass((RequestProcessor)this.session, elementType);
    }

    public ElementClass getNodeClass(RequestProcessor processor, Resource elementType) throws DatabaseException {
        ElementClass ec = (ElementClass)processor.syncRequest((AsyncRead)new NodeClassRequest(this.canvas, this.diagram, elementType, true));
        return ec;
    }

    protected void doDispose() {
        try {
            try {
                try {
                    this.stateLock.lock();
                    boolean isInitial = this.getState() == State.INITIAL;
                    this.activateState(State.DISPOSED, !isInitial);
                }
                finally {
                    this.stateLock.unlock();
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Dispose interrupted!", (Throwable)e);
                this.detachSessionListener();
                if (this.profileObserver != null) {
                    this.profileObserver.dispose();
                    this.profileObserver = null;
                }
                if (this.diagram != null) {
                    this.diagram.removeCompositionListener((IDiagram.CompositionListener)this.diagramListener);
                    this.diagram.removeCompositionVetoListener((IDiagram.CompositionVetoListener)this.diagramListener);
                }
                if (this.layerManager != null) {
                    this.layerManager.dispose();
                }
                this.modificationQueue.dispose();
            }
        }
        finally {
            this.detachSessionListener();
            if (this.profileObserver != null) {
                this.profileObserver.dispose();
                this.profileObserver = null;
            }
            if (this.diagram != null) {
                this.diagram.removeCompositionListener((IDiagram.CompositionListener)this.diagramListener);
                this.diagram.removeCompositionVetoListener((IDiagram.CompositionVetoListener)this.diagramListener);
            }
            if (this.layerManager != null) {
                this.layerManager.dispose();
            }
            this.modificationQueue.dispose();
        }
    }

    void initializeResources(ReadGraph graph) {
        this.br = new BasicResources(graph);
        this.synchronizationContext = new GraphSynchronizationContext(graph, this.modificationQueue);
        this.synchronizationContext.set(SynchronizationHints.ERROR_HANDLER, errorHandler);
    }

    @Override
    public IDiagram loadDiagram(IProgressMonitor progressMonitor, ReadGraph g, String modelURI, Resource diagram, Resource runtime, ResourceArray structuralPath, IHintObservable initialHints) throws DatabaseException {
        if (DebugPolicy.DEBUG_LOAD) {
            System.out.println(Thread.currentThread() + " loadDiagram: " + NameUtils.getSafeName((ReadGraph)g, (Resource)diagram));
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Load Diagram", (int)100);
        Object loadTask = Timing.BEGIN("GDS.loadDiagram");
        try {
            block20: {
                IDiagram iDiagram;
                try {
                    this.activateState(State.LOADING, false);
                }
                catch (IllegalStateException illegalStateException) {
                    IDiagram iDiagram2 = this.diagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
                    Timing.END(loadTask);
                    return iDiagram2;
                }
                try {
                    Resource diagramClassResource = g.getPossibleType(diagram, this.br.DIA.Composite);
                    if (diagramClassResource == null) break block20;
                    Object task = Timing.BEGIN("GDS.DiagramClassRequest");
                    DiagramClass diagramClass = (DiagramClass)g.syncRequest((AsyncRead)new DiagramClassRequest(diagram));
                    Timing.END(task);
                    IDiagram d = Diagram.spawnNew((DiagramClass)diagramClass);
                    d.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE, (Object)diagram);
                    if (runtime != null) {
                        d.setHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE, (Object)runtime);
                    }
                    if (modelURI != null) {
                        d.setHint(DiagramModelHints.KEY_DIAGRAM_MODEL_URI, (Object)modelURI);
                    }
                    d.setHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE_ARRAY, (Object)structuralPath);
                    if (!d.containsHint(DiagramHints.ROUTE_ALGORITHM)) {
                        d.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)RouterFactory.create((boolean)true, (boolean)false));
                    }
                    d.setHint(SynchronizationHints.CONTEXT, (Object)this);
                    if (initialHints != null) {
                        d.setHints(initialHints.getHints());
                    }
                    monitor.subTask("Layers");
                    this.layerManager = new GraphLayerManager(g, this.modificationQueue, diagram);
                    this.synchronizationContext.set(GraphSynchronizationHints.GRAPH_LAYER_MANAGER, this.layerManager);
                    ILayersEditor layers = this.layerManager.loadLayers(d, g, diagram);
                    d.setHint(DiagramHints.KEY_LAYERS, (Object)layers);
                    d.setHint(DiagramHints.KEY_LAYERS_EDITOR, (Object)layers);
                    d.addCompositionVetoListener((IDiagram.CompositionVetoListener)this.diagramListener);
                    d.addCompositionListener((IDiagram.CompositionListener)this.diagramListener);
                    this.diagram = d;
                    d.setHint(DiagramHints.KEY_MUTATOR, (Object)new DefaultDiagramMutator(d, diagram, this.synchronizationContext));
                    monitor.worked(10);
                    monitor.subTask("Contents");
                    ITask task4 = ThreadLogger.getInstance().begin("DiagramContentRequest1");
                    DiagramContentRequest query = new DiagramContentRequest(this.canvas, diagram, errorHandler);
                    g.syncRequest((Read)query, (AsyncProcedure)new DiagramContentListener(diagram));
                    task4.finish();
                    ITask task42 = ThreadLogger.getInstance().begin("DiagramContentRequest2");
                    DiagramContents contents = (DiagramContents)g.syncRequest((Read)query, (AsyncProcedure)TransientCacheAsyncListener.instance());
                    task42.finish();
                    monitor.worked(10);
                    monitor.subTask("Graphical elements");
                    Object applyDiagramContents = Timing.BEGIN("GDS.applyDiagramContents");
                    ITask task6 = ThreadLogger.getInstance().begin("applyDiagramContents");
                    this.processGraphUpdates(g, Collections.singleton(this.diagramGraphUpdater(contents)));
                    task6.finish();
                    Timing.END(applyDiagramContents);
                    monitor.worked(80);
                    DataNodeMap dn = new DataNodeMap(){

                        public INode getNode(Object data) {
                            if (DataNodeConstants.CANVAS_ROOT == data) {
                                return GraphToDiagramSynchronizer.this.canvas.getCanvasNode();
                            }
                            if (DataNodeConstants.DIAGRAM_ELEMENT_PARENT == data) {
                                ElementPainter ep = (ElementPainter)GraphToDiagramSynchronizer.this.canvas.getAtMostOneItemOfClass(ElementPainter.class);
                                return ep != null ? ep.getDiagramElementParentNode() : null;
                            }
                            DataElementMap emap = (DataElementMap)GraphToDiagramSynchronizer.this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
                            IElement element = emap.getElement(GraphToDiagramSynchronizer.this.diagram, data);
                            if (element == null) {
                                return null;
                            }
                            return (INode)element.getHint(ElementHints.KEY_SG_NODE);
                        }
                    };
                    this.profileObserver = new ProfileObserver(g.getSession(), runtime, this.canvas.getThreadAccess(), (IDisposable)this.canvas, this.canvas.getSceneGraph(), (Object)diagram, (Map)ArrayMap.keys((Object[])new String[]{ProfileKeys.DIAGRAM, ProfileKeys.CANVAS, ProfileKeys.NODE_MAP}).values(new Object[]{this.diagram, this.canvas, dn}), (Runnable)new CanvasNotification(this.canvas));
                    g.getSession().asyncRequest((AsyncRead)new AsyncReadRequest(){

                        public void run(AsyncReadGraph graph) {
                            ProfileObserver po = GraphToDiagramSynchronizer.this.profileObserver;
                            if (po != null) {
                                po.listen((AsyncRequestProcessor)graph, (IDisposable)GraphToDiagramSynchronizer.this);
                            } else {
                                LOGGER.info("profileObserver has been disposed already!");
                            }
                        }
                    });
                    iDiagram = d;
                }
                catch (Throwable throwable) {
                    try {
                        this.idle();
                        throw throwable;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalStateException e) {
                        if (!this.isAlive()) {
                            throw new CancelTransactionException((Throwable)e);
                        }
                        throw new RuntimeException(e);
                    }
                }
                this.idle();
                return iDiagram;
            }
            IDiagram iDiagram = this.diagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
            this.idle();
            return iDiagram;
        }
        finally {
            Timing.END(loadTask);
        }
    }

    void addModification(IElement element, IModification modification) {
        this.pendingModifications.add(modification);
        if (element != null) {
            this.modificationIndex.add((Object)element, (Object)modification);
        }
    }

    private GraphUpdateReactor diagramGraphUpdater(final DiagramContents content) {
        if (content == null) {
            throw new NullPointerException("null diagram content");
        }
        return new GraphUpdateReactor(){

            public String toString() {
                return "DiagramGraphUpdater@" + System.identityHashCode(this);
            }

            @Override
            public DiagramUpdater graphUpdate(ReadGraph graph) throws DatabaseException {
                if (!GraphToDiagramSynchronizer.this.isAlive()) {
                    return null;
                }
                GraphToDiagramSynchronizer.this.diagramUpdateLock.lock();
                try {
                    GraphToDiagramUpdater updater;
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
                        System.out.println("In diagramGraphUpdater:");
                        System.out.println("-content = " + content);
                        System.out.println("-previousContent = " + GraphToDiagramSynchronizer.this.previousContent);
                    }
                    Object task = Timing.BEGIN("diagramContentDifference");
                    DiagramContents lastContent = GraphToDiagramSynchronizer.this.previousContent;
                    DiagramContentChanges changes = content.differenceFrom(GraphToDiagramSynchronizer.this.previousContent);
                    GraphToDiagramSynchronizer.this.previousContent = content;
                    Timing.END(task);
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
                        System.out.println("  changes: " + changes);
                    }
                    if (changes.isEmpty()) {
                        return null;
                    }
                    task = Timing.BEGIN("updater.process");
                    GraphToDiagramSynchronizer.this.currentUpdater = updater = new GraphToDiagramUpdater(lastContent, content, changes);
                    try {
                        updater.process(graph);
                    }
                    finally {
                        GraphToDiagramSynchronizer.this.currentUpdater = null;
                    }
                    Timing.END(task);
                    if (updater.isEmpty()) {
                        return null;
                    }
                    DiagramUpdater diagramUpdater = GraphToDiagramSynchronizer.this.diagramUpdater(updater);
                    return diagramUpdater;
                }
                finally {
                    GraphToDiagramSynchronizer.this.diagramUpdateLock.unlock();
                }
            }
        };
    }

    DiagramUpdater diagramUpdater(final GraphToDiagramUpdater updater) {
        return new AbstractDiagramUpdater(DIAGRAM_UPDATE_DIAGRAM_PRIORITY, "updateDiagram"){

            @Override
            protected void forDiagram() {
                IElement connection;
                if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
                    System.out.println("running diagram updater: " + this);
                }
                HashSet<IElement> dirty = new HashSet<IElement>();
                Object task2 = Timing.BEGIN("Preprocess connection changes");
                HashMap<ConnectionEntityImpl, ConnectionChildren> connectionChangeData = new HashMap<ConnectionEntityImpl, ConnectionChildren>(updater.changedConnectionEntities.size());
                for (ConnectionData connectionData : updater.changedConnectionEntities.values()) {
                    connectionChangeData.put(connectionData.impl, connectionData.impl.getConnectionChildren());
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("removeRouteGraphConnections");
                for (IElement iElement : updater.removedRouteGraphConnections) {
                    ConnectionEntity ce;
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("removing route graph connection: " + iElement);
                    }
                    if ((ce = (ConnectionEntity)iElement.getHint(ElementHints.KEY_CONNECTION_ENTITY)) == null) continue;
                    Object connectionData = ElementUtils.getObject((IElement)iElement);
                    GraphToDiagramSynchronizer.this.tempConnections.clear();
                    for (Topology.Connection conn : ce.getTerminalConnections(GraphToDiagramSynchronizer.this.tempConnections)) {
                        ((Element)conn.node).removeHintWithoutNotification((IHintContext.Key)new TerminalKeyOf(conn.terminal, connectionData, Topology.Connection.class));
                        dirty.add(conn.node);
                    }
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("removeBranchPoints");
                for (IElement iElement : updater.removedBranchPoints) {
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("removing branch point: " + iElement);
                    }
                    GraphToDiagramSynchronizer.this.unmapElement(iElement.getHint(ElementHints.KEY_OBJECT));
                    GraphToDiagramSynchronizer.removeNodeTopologyHints((Element)iElement);
                    connection = ElementUtils.getParent((IElement)iElement);
                    if (connection == null) continue;
                    dirty.add(connection);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("removeConnectionSegments");
                for (IElement iElement : updater.removedConnectionSegments) {
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("removing segment: " + iElement);
                    }
                    GraphToDiagramSynchronizer.this.unmapElement(iElement.getHint(ElementHints.KEY_OBJECT));
                    GraphToDiagramSynchronizer.removeEdgeTopologyHints((Element)iElement);
                    connection = ElementUtils.getParent((IElement)iElement);
                    if (connection == null) continue;
                    dirty.add(connection);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("removeElements");
                for (IElement iElement : updater.removedElements) {
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("removing element: " + iElement);
                    }
                    iElement.setHint(KEY_REMOVE_RELATIONSHIPS, (Object)Boolean.TRUE);
                    if (GraphToDiagramSynchronizer.this.diagram.containsElement(iElement)) {
                        GraphToDiagramSynchronizer.this.diagram.removeElement(iElement);
                    }
                    GraphToDiagramSynchronizer.this.unmapElement(iElement.getHint(ElementHints.KEY_OBJECT));
                    GraphToDiagramSynchronizer.removeNodeTopologyHints((Element)iElement);
                    dirty.remove(iElement);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("removeConnectionEntities");
                for (Resource resource : updater.removedConnectionEntities) {
                    GraphToDiagramSynchronizer.this.unmapConnection(resource);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("setConnectionData");
                for (ConnectionData connectionData : updater.changedConnectionEntities.values()) {
                    connectionData.impl.setData(connectionData.segments, connectionData.branchPoints);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("addConnectionEntities");
                for (Map.Entry entry : updater.addedConnectionEntities.entrySet()) {
                    GraphToDiagramSynchronizer.this.mapConnection(entry.getKey(), (ConnectionEntityImpl)entry.getValue());
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("addBranchPoints");
                for (IElement iElement : updater.addedBranchPoints) {
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("adding branch point: " + iElement);
                    }
                    GraphToDiagramSynchronizer.this.mapElement(ElementUtils.getObject((IElement)iElement), iElement);
                    connection = ElementUtils.getParent((IElement)iElement);
                    if (connection == null) continue;
                    dirty.add(connection);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("addElements");
                for (Resource resource : updater.content.elements) {
                    IElement added = updater.addedElementMap.get(resource);
                    if (added == null) continue;
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("adding element: " + added);
                    }
                    Object task3 = Timing.BEGIN("mapElement");
                    GraphToDiagramSynchronizer.this.mapElement(added.getHint(ElementHints.KEY_OBJECT), added);
                    Timing.END(task3);
                    task3 = Timing.BEGIN("addElement");
                    GraphToDiagramSynchronizer.this.diagram.addElement(added);
                    dirty.add(added);
                    Timing.END(task3);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("addConnectionSegments");
                for (IElement iElement : updater.addedConnectionSegments) {
                    IElement connection2;
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("adding segment: " + iElement);
                    }
                    PlaceholderConnection cb = (PlaceholderConnection)iElement.removeHint(KEY_CONNECTION_BEGIN_PLACEHOLDER);
                    PlaceholderConnection ce = (PlaceholderConnection)iElement.removeHint(KEY_CONNECTION_END_PLACEHOLDER);
                    if (cb == null || ce == null) {
                        if (!DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) continue;
                        GraphToDiagramSynchronizer.this.warning("ignoring connection segment " + iElement + ", connectivity was not resolved (begin=" + cb + ", end=" + ce + ")", null);
                        continue;
                    }
                    GraphToDiagramSynchronizer.this.mapElement(ElementUtils.getObject((IElement)iElement), iElement);
                    IElement beginNode = GraphToDiagramSynchronizer.this.assertMappedElement(cb.node);
                    IElement endNode = GraphToDiagramSynchronizer.this.assertMappedElement(ce.node);
                    if (cb != null) {
                        GraphToDiagramSynchronizer.connect(iElement, cb.end, beginNode, cb.terminal);
                    }
                    if (ce != null) {
                        GraphToDiagramSynchronizer.connect(iElement, ce.end, endNode, ce.terminal);
                    }
                    if ((connection2 = ElementUtils.getParent((IElement)iElement)) == null) continue;
                    dirty.add(connection2);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("handle dirty RouteGraph connections");
                for (IElement iElement : updater.addedRouteGraphConnectionMap.values()) {
                    GraphToDiagramSynchronizer.this.updateDirtyRouteGraphConnection(iElement, dirty);
                }
                Timing.END(task2);
                GraphToDiagramSynchronizer.this.tempConnections.clear();
                final TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap(2 * updater.content.elements.size());
                int i = 1;
                for (Resource r : updater.content.elements) {
                    IElement e = GraphToDiagramSynchronizer.this.getMappedElement(r);
                    if (e != null) {
                        tObjectIntHashMap.put((Object)e, i);
                    }
                    ++i;
                }
                GraphToDiagramSynchronizer.this.diagram.sort((Comparator)new Comparator<IElement>(){

                    @Override
                    public int compare(IElement e1, IElement e2) {
                        int o1 = tObjectIntHashMap.get((Object)e1);
                        int o2 = tObjectIntHashMap.get((Object)e2);
                        return o1 - o2;
                    }
                });
                task2 = Timing.BEGIN("fixChangedConnections");
                for (ConnectionData cd : updater.changedConnectionEntities.values()) {
                    cd.impl.fix();
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("validateAndFix");
                DiagramUtils.validateAndFix((IDiagram)GraphToDiagramSynchronizer.this.diagram, dirty);
                Timing.END(task2);
                task2 = Timing.BEGIN("Postprocess connection changes");
                for (ConnectionData cd : updater.changedConnectionEntities.values()) {
                    ConnectionChildren oldChildren = (ConnectionChildren)connectionChangeData.get(cd.impl);
                    if (oldChildren == null) continue;
                    ConnectionChildren currentChildren = cd.impl.getConnectionChildren();
                    cd.impl.fireListener(oldChildren, currentChildren);
                }
                Timing.END(task2);
                task2 = Timing.BEGIN("setDirty");
                for (IElement e : dirty) {
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("MARKING ELEMENT DIRTY: " + e);
                    }
                    e.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
                }
                Timing.END(task2);
                if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                    System.out.println("MARKING DIAGRAM DIRTY: " + GraphToDiagramSynchronizer.this.diagram);
                }
                GraphToDiagramSynchronizer.this.diagram.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_Z_ORDER_CHANGED);
                updater.clear();
                GraphToDiagramSynchronizer.this.diagram.setHint(DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED, (Object)Boolean.TRUE);
            }
        };
    }

    private void updateDirtyRouteGraphConnection(IElement connection, Set<IElement> dirtySet) {
        ConnectionEntity ce;
        if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
            System.out.println("updating dirty route graph connection: " + connection);
        }
        if ((ce = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY)) == null) {
            return;
        }
        this.tempConnections.clear();
        Object connectionData = ElementUtils.getObject((IElement)connection);
        for (Topology.Connection conn : ce.getTerminalConnections(this.tempConnections)) {
            ((Element)conn.node).setHintWithoutNotification((IHintContext.Key)new TerminalKeyOf(conn.terminal, connectionData, Topology.Connection.class), (Object)conn);
            if (dirtySet == null) continue;
            dirtySet.add(conn.node);
        }
        this.tempConnections.clear();
    }

    ElementUpdater nodeUpdater(Resource resource, final IElement newElement) {
        return new ElementUpdater(this, DIAGRAM_UPDATE_NODE_PRIORITY, "updateNode", newElement){

            Collection<Topology.Terminal> getTerminals(IElement e) {
                List<Topology.Terminal> ts = Collections.emptyList();
                TerminalTopology tt = (TerminalTopology)e.getElementClass().getAtMostOneItemOfClass(TerminalTopology.class);
                if (tt != null) {
                    ts = new ArrayList<Topology.Terminal>();
                    tt.getTerminals(newElement, ts);
                }
                return ts;
            }

            @Override
            protected void forMappedElement(Element mappedElement) {
                Collection<Topology.Terminal> newTerminals;
                Collection<Topology.Terminal> oldTerminals;
                if (DebugPolicy.DEBUG_NODE_UPDATE) {
                    System.out.println("running node updater: " + this + " - new element: " + newElement);
                }
                if (!(oldTerminals = this.getTerminals((IElement)mappedElement)).equals(newTerminals = this.getTerminals(newElement))) {
                    HashMap<Topology.Terminal, Topology.Terminal> newTerminalMap = new HashMap<Topology.Terminal, Topology.Terminal>(newTerminals.size());
                    for (Topology.Terminal terminal : newTerminals) {
                        newTerminalMap.put(terminal, terminal);
                    }
                    for (Map.Entry entry : mappedElement.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                        TerminalKeyOf key = (TerminalKeyOf)entry.getKey();
                        Topology.Connection c = (Topology.Connection)entry.getValue();
                        if (c.node != mappedElement) continue;
                        Topology.Terminal newTerminal = (Topology.Terminal)newTerminalMap.get(c.terminal);
                        if (newTerminal != null) {
                            c = new Topology.Connection(c.edge, c.end, c.node, newTerminal);
                            ((Element)c.edge).setHintWithoutNotification((IHintContext.Key)EndKeyOf.get((EdgeVisuals.EdgeEnd)c.end), (Object)c);
                            continue;
                        }
                        mappedElement.removeHintWithoutNotification((IHintContext.Key)key);
                    }
                }
                GraphToDiagramSynchronizer.updateMappedElement(mappedElement, newElement);
                mappedElement.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
            }
        };
    }

    ElementUpdater connectionUpdater(final Object data, final IElement newElement) {
        return new ElementUpdater(this, DIAGRAM_UPDATE_CONNECTION_PRIORITY, "updateConnection", newElement){

            @Override
            public void forMappedElement(Element mappedElement) {
                if (DebugPolicy.DEBUG_CONNECTION_UPDATE) {
                    System.out.println("running connection updater: " + this + " - new element: " + newElement + " with data " + data);
                }
                newElement.removeHint(ElementHints.KEY_CONNECTION_ENTITY);
                GraphToDiagramSynchronizer.updateMappedElement(mappedElement, newElement);
                mappedElement.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
            }
        };
    }

    ElementUpdater edgeUpdater(final Object data, final IElement newElement) {
        return new ElementUpdater(this, DIAGRAM_UPDATE_EDGE_PRIORITY, "updateEdge", newElement){

            @Override
            public void forMappedElement(Element mappedElement) {
                if (DebugPolicy.DEBUG_EDGE_UPDATE) {
                    System.out.println("running edge updater: " + this + " - new element: " + newElement + " with data " + data);
                }
                GraphToDiagramSynchronizer.updateMappedElement(mappedElement, newElement);
                mappedElement.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
            }
        };
    }

    ElementUpdater routeGraphConnectionUpdater(final Object data, final IElement newElement, final Set<Object> dirtyNodes) {
        return new ElementUpdater(this, DIAGRAM_UPDATE_CONNECTION_PRIORITY, "updateRouteGraphConnection", newElement){

            @Override
            public void forMappedElement(Element mappedElement) {
                if (DebugPolicy.DEBUG_CONNECTION_UPDATE) {
                    System.out.println("running route graph connection updater: " + this + " - new element: " + newElement + " with data " + data);
                }
                for (Object dirtyNodeObject : dirtyNodes) {
                    Element dirtyNode = (Element)this.getMappedElement(dirtyNodeObject);
                    if (dirtyNode == null) continue;
                    if (DebugPolicy.DEBUG_DIAGRAM_UPDATE_DETAIL) {
                        System.out.println("preparing node with dirty connectivity: " + dirtyNode);
                    }
                    for (Map.Entry entry : dirtyNode.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                        Topology.Connection conn = (Topology.Connection)entry.getValue();
                        Object connectionNode = conn.edge.getHint(ElementHints.KEY_OBJECT);
                        if (!data.equals(connectionNode)) continue;
                        dirtyNode.removeHintWithoutNotification((IHintContext.Key)entry.getKey());
                    }
                }
                GraphToDiagramSynchronizer.updateMappedElement(mappedElement, newElement);
                this.updateDirtyRouteGraphConnection((IElement)mappedElement, null);
                mappedElement.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
            }
        };
    }

    static void updateMappedElement(Element mappedElement, IElement newElement) {
        if (mappedElement == newElement) {
            return;
        }
        ElementClass oldClass = mappedElement.getElementClass();
        ElementClass newClass = newElement.getElementClass();
        Object mappedData = mappedElement.getHint(ElementHints.KEY_OBJECT);
        Object newData = newElement.getHint(ElementHints.KEY_OBJECT);
        assert (mappedData != null);
        assert (newData != null);
        assert (mappedData.equals(newData));
        if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) {
            System.out.println("Updating mapped element, setting hints\n  from: " + newElement + "\n  into: " + mappedElement);
        }
        if (!newClass.equals((Object)oldClass)) {
            if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) {
                System.out.println("  old element class: " + oldClass);
                System.out.println("  new element class: " + newClass);
            }
            mappedElement.setElementClass(newClass);
        }
        Map discardableHints = mappedElement.getHintsOfClass(ElementHints.DiscardableKey.class);
        Map hints = newElement.getHints();
        HashMap newHints = new HashMap();
        for (Map.Entry entry : hints.entrySet()) {
            IHintContext.Key key = (IHintContext.Key)entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = mappedElement.getHint(key);
            if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE_DETAIL) {
                System.out.println("  hint " + key + " compare values: " + oldValue + "  ->  " + newValue);
            }
            if (!newValue.equals(oldValue)) {
                newHints.put(key, newValue);
                if (!DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) continue;
                System.out.format("    %-42s : %64s -> %-64s\n", key, oldValue, newValue);
                continue;
            }
            discardableHints.remove(key);
        }
        if (!discardableHints.isEmpty()) {
            if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) {
                System.out.println("Discarding " + discardableHints.size() + " discardable hints:\n  " + discardableHints);
            }
            mappedElement.removeHints(discardableHints.keySet());
        }
        if (!newHints.isEmpty()) {
            if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) {
                System.out.println("Updating mapped element, setting new hints:\n\t" + EString.implode(newHints.entrySet(), (String)"\n\t") + "\nto replace old hints\n\t" + EString.implode(mappedElement.getHints().entrySet(), (String)"\n\t"));
            }
            mappedElement.setHints(newHints);
        }
        if (DebugPolicy.DEBUG_GENERAL_ELEMENT_UPDATE) {
            System.out.println("All hints after update:\n\t" + EString.implode(mappedElement.getHints().entrySet(), (String)"\n\t"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerGraphUpdate(GraphUpdateReactor update) {
        if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
            System.out.println("offerGraphUpdate: " + update);
        }
        boolean inWrite = this.inWriteTransaction.get();
        Object object = this.graphUpdateLock;
        synchronized (object) {
            if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
                System.out.println("queueing graph update: " + update);
            }
            this.queuedGraphUpdates.add(update);
        }
        if (!inWrite) {
            if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
                System.out.println("scheduling queued graph update immediately: " + update);
            }
            this.scheduleGraphUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<GraphUpdateReactor> scrubGraphUpdates() {
        Object object = this.graphUpdateLock;
        synchronized (object) {
            if (this.queuedGraphUpdates.isEmpty()) {
                return Collections.emptyList();
            }
            List<GraphUpdateReactor> updates = this.queuedGraphUpdates;
            this.queuedGraphUpdates = new ArrayList<GraphUpdateReactor>();
            return updates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleGraphUpdates() {
        Object object = this.graphUpdateLock;
        synchronized (object) {
            if (this.queuedGraphUpdates.isEmpty()) {
                return;
            }
            if (!this.graphUpdateRequestScheduled.compareAndSet(false, true)) {
                return;
            }
        }
        if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
            System.out.println("scheduling " + this.queuedGraphUpdates.size() + " queued graph updates with ");
        }
        this.session.asyncRequest((Read)new ReadRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ReadGraph graph) throws DatabaseException {
                Collection<GraphUpdateReactor> updates;
                Object object = GraphToDiagramSynchronizer.this.graphUpdateLock;
                synchronized (object) {
                    GraphToDiagramSynchronizer.this.graphUpdateRequestScheduled.set(false);
                    updates = GraphToDiagramSynchronizer.this.scrubGraphUpdates();
                }
                if (!GraphToDiagramSynchronizer.this.isAlive()) {
                    return;
                }
                GraphToDiagramSynchronizer.this.processGraphUpdates(graph, updates);
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                GraphToDiagramSynchronizer.this.error(t);
            }
        });
    }

    private void processGraphUpdates(ReadGraph graph, Collection<GraphUpdateReactor> graphUpdates) throws DatabaseException {
        final ArrayList<DiagramUpdater> diagramUpdates = new ArrayList<DiagramUpdater>(graphUpdates.size());
        if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
            System.out.println("Running GRAPH updates: " + graphUpdates);
        }
        for (GraphUpdateReactor graphUpdate : graphUpdates) {
            DiagramUpdater diagramUpdate = graphUpdate.graphUpdate(graph);
            if (diagramUpdate == null) continue;
            if (DebugPolicy.DEBUG_GRAPH_UPDATE) {
                System.out.println(graphUpdate + " => " + diagramUpdate);
            }
            diagramUpdates.add(diagramUpdate);
        }
        if (diagramUpdates.isEmpty()) {
            return;
        }
        if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
            System.out.println("Diagram updates: " + diagramUpdates);
        }
        Collections.sort(diagramUpdates, DiagramUpdater.DIAGRAM_UPDATER_COMPARATOR);
        if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
            System.out.println("Sorted diagram updates: " + diagramUpdates);
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.canvas.getThreadAccess(), (Runnable)new StateRunnable(){

            @Override
            public void run() {
                if (GraphToDiagramSynchronizer.this.isAlive() && GraphToDiagramSynchronizer.this.getState() != State.DISPOSED) {
                    GraphToDiagramSynchronizer.this.safeRunInState(State.UPDATING_DIAGRAM, this);
                }
            }

            @Override
            public void execute() throws InvocationTargetException {
                DiagramUtils.inDiagramTransaction((IDiagram)GraphToDiagramSynchronizer.this.diagram, (TransactionContext.TransactionType)TransactionContext.TransactionType.READ, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
                            System.out.println("Running DIAGRAM updates: " + diagramUpdates);
                        }
                        for (DiagramUpdater update : diagramUpdates) {
                            if (DebugPolicy.DEBUG_DIAGRAM_UPDATE) {
                                System.out.println("Running DIAGRAM update: " + update);
                            }
                            update.run();
                        }
                    }
                });
                GraphToDiagramSynchronizer.this.setCanvasDirty();
            }
        });
    }

    private void attachSessionListener(Session session) {
        SessionEventSupport support = (SessionEventSupport)session.peekService(SessionEventSupport.class);
        if (support != null) {
            this.sessionListener = new TransactionListener();
            support.addListener((SessionEventListener)this.sessionListener);
        }
    }

    private void detachSessionListener() {
        if (this.sessionListener != null) {
            ((SessionEventSupport)this.session.getService(SessionEventSupport.class)).removeListener((SessionEventListener)this.sessionListener);
            this.sessionListener = null;
        }
    }

    static void removeNodeTopologyHints(Element node) {
        Set<TerminalKeyOf> terminalKeys = node.getHintsOfClass(TerminalKeyOf.class).keySet();
        if (!terminalKeys.isEmpty()) {
            GraphToDiagramSynchronizer.removeNodeTopologyHints(node, terminalKeys);
        }
    }

    static void removeNodeTopologyHints(Element node, Collection<TerminalKeyOf> terminalKeys) {
        for (TerminalKeyOf key : terminalKeys) {
            Topology.Connection c = (Topology.Connection)node.removeHintWithoutNotification((IHintContext.Key)key);
            if (c == null) continue;
            GraphToDiagramSynchronizer.removeEdgeTopologyHints((Element)c.edge);
        }
    }

    static void removeEdgeTopologyHints(Element edge) {
        Object edgeData = edge.getHint(ElementHints.KEY_OBJECT);
        EndKeyOf[] endKeyOfArray = EndKeyOf.KEYS;
        int n = EndKeyOf.KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            EndKeyOf key = endKeyOfArray[n2];
            Topology.Connection c = (Topology.Connection)edge.removeHintWithoutNotification((IHintContext.Key)key);
            if (c != null) {
                ((Element)c.node).removeHintWithoutNotification((IHintContext.Key)new TerminalKeyOf(c.terminal, edgeData, Topology.Connection.class));
            }
            ++n2;
        }
    }

    void adaptDiagramClass(AsyncReadGraph graph, Resource diagram, final AsyncProcedure<DiagramClass> procedure) {
        graph.forAdapted(diagram, DiagramClass.class, (AsyncProcedure)new AsyncProcedure<DiagramClass>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, DiagramClass dc) {
                procedure.execute(graph, (Object)dc.newClassWith(new DiagramHandler[]{GraphToDiagramSynchronizer.this.diagramTopology, GraphToDiagramSynchronizer.this.elementFactory, GraphToDiagramSynchronizer.this.dataElementMap, GraphToDiagramSynchronizer.this.substituteElementClass, GraphToDiagramSynchronizer.this.relationshipHandler}));
            }
        });
    }

    static Topology.Connection connect(IElement edge, EdgeVisuals.EdgeEnd end, IElement element, Topology.Terminal terminal) {
        Topology.Connection c = new Topology.Connection(edge, end, element, terminal);
        Object edgeData = edge.getHint(ElementHints.KEY_OBJECT);
        if (DebugPolicy.DEBUG_CONNECTION) {
            System.out.println("[connect](edge=" + edge + ", edgeData=" + edgeData + ", end=" + end + ", element=" + element + ", terminal=" + terminal + ")");
        }
        TerminalKeyOf key = new TerminalKeyOf(terminal, edgeData, Topology.Connection.class);
        element.setHint((IHintContext.Key)key, (Object)c);
        EndKeyOf key2 = EndKeyOf.get((EdgeVisuals.EdgeEnd)end);
        edge.setHint((IHintContext.Key)key2, (Object)c);
        return c;
    }

    static abstract class AbstractDiagramUpdater
    implements DiagramUpdater,
    GraphUpdateReactor {
        protected final Double priority;
        protected final String runnerName;

        public AbstractDiagramUpdater(Double priority, String runnerName) {
            if (priority == null) {
                throw new NullPointerException("null priority");
            }
            if (runnerName == null) {
                throw new NullPointerException("null runner name");
            }
            this.priority = priority;
            this.runnerName = runnerName;
        }

        @Override
        public Double getPriority() {
            return this.priority;
        }

        @Override
        public AbstractDiagramUpdater graphUpdate(ReadGraph graph) {
            return this;
        }

        @Override
        public void run() {
            Object task = Timing.BEGIN(this.runnerName);
            this.forDiagram();
            Timing.END(task);
        }

        protected void forDiagram() {
        }

        public String toString() {
            return String.valueOf(this.runnerName) + "@" + System.identityHashCode(this) + " [" + this.priority + "]";
        }
    }

    abstract class BaseListener<T, Result>
    implements AsyncListener<Result> {
        protected final T data;
        private Object oldResult = FIRST_TIME;
        protected boolean disposed = false;
        final ICanvasContext canvas;

        public BaseListener(T data) {
            this.canvas = GraphToDiagramSynchronizer.this.canvas;
            this.data = data;
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            this.disposed = true;
        }

        abstract void execute(AsyncReadGraph var1, Object var2, Object var3);

        public void execute(AsyncReadGraph graph, Result result) {
            if (DebugPolicy.DEBUG_LISTENER_BASE) {
                System.out.println("BaseListener: " + result);
            }
            if (this.disposed) {
                if (DebugPolicy.DEBUG_LISTENER_BASE) {
                    System.out.println("BaseListener: execute invoked although listener is disposed!");
                }
                return;
            }
            if (result == null) {
                this.disposed = true;
                if (DebugPolicy.DEBUG_LISTENER_BASE) {
                    System.out.println(this + " null result, listener marked disposed");
                }
            }
            if (this.oldResult == FIRST_TIME) {
                this.oldResult = result;
                if (DebugPolicy.DEBUG_LISTENER_BASE) {
                    System.out.println(this + " first result computed: " + result);
                }
            } else {
                if (DebugPolicy.DEBUG_LISTENER_BASE) {
                    System.out.println(this + " result changed from '" + this.oldResult + "' to '" + result + "'");
                }
                try {
                    this.execute(graph, this.oldResult, result);
                }
                finally {
                    this.oldResult = result;
                }
            }
        }

        public boolean isDisposed() {
            if (this.disposed) {
                return true;
            }
            boolean alive = GraphToDiagramSynchronizer.this.isAlive();
            return !alive;
        }
    }

    static class CanvasNotification
    implements Runnable {
        private final ICanvasContext canvas;

        public CanvasNotification(ICanvasContext canvas) {
            this.canvas = canvas;
        }

        @Override
        public void run() {
            this.canvas.getContentContext().setDirty();
        }
    }

    private static class ConnectionChildren {
        public Set<IElement> branchPoints;
        public Set<IElement> segments;

        public ConnectionChildren(Set<IElement> branchPoints, Set<IElement> segments) {
            this.branchPoints = branchPoints;
            this.segments = segments;
        }
    }

    static class ConnectionData {
        ConnectionEntityImpl impl;
        List<Resource> branchPoints = new ArrayList<Resource>();
        List<EdgeResource> segments = new ArrayList<EdgeResource>();

        ConnectionData(ConnectionEntityImpl ce) {
            this.impl = ce;
        }

        void addBranchPoint(Resource bp) {
            this.branchPoints.add(bp);
        }

        void addSegment(EdgeResource seg) {
            this.segments.add(seg);
        }
    }

    class ConnectionEntityImpl
    implements ConnectionEntity {
        Resource connection;
        Resource connectionType;
        IElement connectionElement;
        Collection<Resource> branchPoints = Collections.emptyList();
        Collection<EdgeResource> segments = Collections.emptyList();
        Set<Object> removedBranchPoints = new HashSet<Object>(4);
        Set<Object> removedSegments = new HashSet<Object>(4);
        List<IElement> branchPointElements = new ArrayList<IElement>(1);
        List<IElement> segmentElements = new ArrayList<IElement>(2);
        ConnectionEntity.ConnectionListener listener;

        ConnectionEntityImpl(Resource connection, Resource connectionType, IElement connectionElement) {
            this.connection = connection;
            this.connectionType = connectionType;
            this.connectionElement = connectionElement;
        }

        ConnectionEntityImpl(Resource connectionType, IElement connectionElement) {
            this.connectionType = connectionType;
            this.connectionElement = connectionElement;
        }

        ConnectionEntityImpl(ReadGraph graph, Resource connection, IElement connectionElement) throws NoSingleResultException, ServiceException {
            this.connection = connection;
            this.connectionType = graph.getSingleType(connection, GraphToDiagramSynchronizer.this.br.DIA.Connection);
            this.connectionElement = connectionElement;
        }

        public IElement getConnection() {
            return this.connectionElement;
        }

        public Object getConnectionObject() {
            return this.connection;
        }

        public IElement getConnectionElement() {
            if (this.connectionElement == null) {
                return this.getMappedConnectionElement();
            }
            return this.connectionElement;
        }

        private IElement getMappedConnectionElement() {
            IElement ce = null;
            if (this.connection != null) {
                ce = GraphToDiagramSynchronizer.this.getMappedElement(this.connection);
            }
            return ce == null ? this.connectionElement : ce;
        }

        void fix() {
            Collection<IElement> segments = this.getSegments(null);
            ArrayList<TerminalKeyOf> pruned = null;
            for (IElement bp : this.getBranchPoints(null)) {
                if (pruned == null) {
                    pruned = new ArrayList<TerminalKeyOf>(4);
                }
                pruned.clear();
                for (Map.Entry entry : bp.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                    Topology.Connection c = (Topology.Connection)entry.getValue();
                    if (segments.contains(c.edge)) continue;
                    pruned.add((TerminalKeyOf)entry.getKey());
                }
                GraphToDiagramSynchronizer.removeNodeTopologyHints((Element)bp, pruned);
            }
        }

        public ConnectionChildren getConnectionChildren() {
            IElement e;
            Set<IElement> bps = Collections.emptySet();
            Set<IElement> segs = Collections.emptySet();
            if (!this.branchPoints.isEmpty()) {
                bps = new HashSet(this.branchPoints.size());
                for (Resource bp : this.branchPoints) {
                    e = GraphToDiagramSynchronizer.this.getMappedElement(bp);
                    if (e == null) continue;
                    bps.add(e);
                }
            }
            if (!this.segments.isEmpty()) {
                segs = new HashSet<IElement>(this.segments.size());
                for (EdgeResource seg : this.segments) {
                    e = GraphToDiagramSynchronizer.this.getMappedElement(seg);
                    if (e == null) continue;
                    segs.add(e);
                }
            }
            return new ConnectionChildren(bps, segs);
        }

        public void setData(Collection<EdgeResource> segments, Collection<Resource> branchPoints) {
            this.branchPoints = branchPoints;
            this.segments = segments;
            this.removedBranchPoints = new HashSet<Object>(4);
            this.removedSegments = new HashSet<Object>(4);
            this.branchPointElements = new ArrayList<IElement>(4);
            this.segmentElements = new ArrayList<IElement>(4);
        }

        public void fireListener(ConnectionChildren old, ConnectionChildren current) {
            if (this.listener != null) {
                ArrayList<IElement> removed = new ArrayList<IElement>();
                ArrayList<IElement> added = new ArrayList<IElement>();
                for (IElement oldBp : old.branchPoints) {
                    if (current.branchPoints.contains(oldBp)) continue;
                    removed.add(oldBp);
                }
                for (IElement oldSeg : old.segments) {
                    if (current.segments.contains(oldSeg)) continue;
                    removed.add(oldSeg);
                }
                for (IElement bp : current.branchPoints) {
                    if (old.branchPoints.contains(bp)) continue;
                    added.add(bp);
                }
                for (IElement seg : current.segments) {
                    if (old.segments.contains(seg)) continue;
                    added.add(seg);
                }
                if (!removed.isEmpty() || !added.isEmpty()) {
                    this.listener.connectionChanged(new ConnectionEntity.ConnectionEvent(this.connectionElement, removed, added));
                }
            }
        }

        public Collection<IElement> getBranchPoints(Collection<IElement> result) {
            if (result == null) {
                result = new ArrayList<IElement>(this.branchPoints.size());
            }
            for (Resource bp : this.branchPoints) {
                IElement e;
                if (this.removedBranchPoints.contains(bp) || (e = GraphToDiagramSynchronizer.this.getMappedElement(bp)) == null) continue;
                result.add(e);
            }
            result.addAll(this.branchPointElements);
            return result;
        }

        public Collection<IElement> getSegments(Collection<IElement> result) {
            if (result == null) {
                result = new ArrayList<IElement>(this.segments.size());
            }
            for (EdgeResource seg : this.segments) {
                IElement e;
                if (this.removedSegments.contains(seg) || (e = GraphToDiagramSynchronizer.this.getMappedElement(seg)) == null) continue;
                result.add(e);
            }
            result.addAll(this.segmentElements);
            return result;
        }

        public Collection<Topology.Connection> getTerminalConnections(Collection<Topology.Connection> result) {
            if (result == null) {
                result = new ArrayList<Topology.Connection>(this.segments.size() * 2);
            }
            HashSet<Pair> processed = new HashSet<Pair>();
            for (EdgeResource seg : this.segments) {
                IElement edge = GraphToDiagramSynchronizer.this.getMappedElement(seg);
                if (edge == null) continue;
                EndKeyOf[] endKeyOfArray = EndKeyOf.KEYS;
                int n = EndKeyOf.KEYS.length;
                int n2 = 0;
                while (n2 < n) {
                    EndKeyOf key = endKeyOfArray[n2];
                    Topology.Connection c = (Topology.Connection)edge.getHint((IHintContext.Key)key);
                    if (c != null && c.terminal instanceof ResourceTerminal && processed.add(Pair.make((Object)c.node, (Object)c.terminal))) {
                        result.add(c);
                    }
                    ++n2;
                }
            }
            return result;
        }

        public void setListener(ConnectionEntity.ConnectionListener listener) {
            this.listener = listener;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[resource=" + this.connection + ", branch points=" + this.branchPoints + ", segments=" + this.segments + ", connectionElement=" + this.connectionElement + ", branch point elements=" + this.branchPointElements + ", segment elements=" + this.segmentElements + ", removed branch points=" + this.removedBranchPoints + ", removed segments=" + this.removedSegments + "]";
        }
    }

    class DataElementMapImpl
    implements DataElementMap {
        DataElementMapImpl() {
        }

        public Object getData(IDiagram d, IElement element) {
            if (d == null) {
                throw new NullPointerException("null diagram");
            }
            if (element == null) {
                throw new NullPointerException("null element");
            }
            assert (ElementUtils.getDiagram((IElement)element) == d);
            return element.getHint(ElementHints.KEY_OBJECT);
        }

        public IElement getElement(IDiagram d, Object data) {
            IElement e;
            if (d == null) {
                throw new NullPointerException("null diagram");
            }
            if (data == null) {
                throw new NullPointerException("null data");
            }
            GraphToDiagramUpdater updater = GraphToDiagramSynchronizer.this.currentUpdater;
            if (updater != null && (e = updater.addedElementMap.get(data)) != null) {
                return e;
            }
            e = GraphToDiagramSynchronizer.this.getMappedElement(data);
            if (e != null) {
                return e;
            }
            return null;
        }
    }

    class DefaultDiagramMutator
    implements DiagramMutator {
        Map<IElement, Resource> creation = new HashMap<IElement, Resource>();
        IDiagram d;
        Resource diagram;
        IModifiableSynchronizationContext synchronizationContext;

        public DefaultDiagramMutator(IDiagram d, Resource diagram, IModifiableSynchronizationContext synchronizationContext) {
            this.d = d;
            this.diagram = diagram;
            this.synchronizationContext = synchronizationContext;
            if (synchronizationContext.get(SynchronizationHints.ELEMENT_CLASS_PROVIDER) == null) {
                throw new IllegalArgumentException("SynchronizationHints.ELEMENT_CLASS_PROVIDER not available");
            }
        }

        void assertNotDisposed() {
            if (!GraphToDiagramSynchronizer.this.isAlive()) {
                throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " is disposed");
            }
        }

        public IElement newElement(ElementClass clazz) {
            this.assertNotDisposed();
            org.simantics.g2d.diagram.handler.ElementFactory ef = (org.simantics.g2d.diagram.handler.ElementFactory)this.d.getDiagramClass().getAtMostOneItemOfClass(org.simantics.g2d.diagram.handler.ElementFactory.class);
            IElement element = null;
            element = ef != null ? ef.spawnNew(clazz) : Element.spawnNew((ElementClass)clazz);
            element.setHint(ElementHints.KEY_OBJECT, (Object)new TransientElementObject());
            GraphToDiagramSynchronizer.this.addModification(element, new AddElement(this.synchronizationContext, this.d, element));
            return element;
        }

        public void commit() {
            this.assertNotDisposed();
            if (DebugPolicy.DEBUG_MUTATOR_COMMIT) {
                System.out.println("DiagramMutator is about to commit changes:");
                for (IModification mod : GraphToDiagramSynchronizer.this.pendingModifications) {
                    System.out.println("\t- " + mod);
                }
            }
            Collections.sort(GraphToDiagramSynchronizer.this.pendingModifications);
            if (DebugPolicy.DEBUG_MUTATOR_COMMIT && GraphToDiagramSynchronizer.this.pendingModifications.size() > 1) {
                System.out.println("* changes were re-ordered to:");
                for (IModification mod : GraphToDiagramSynchronizer.this.pendingModifications) {
                    System.out.println("\t" + mod);
                }
            }
            Timing.safeTimed(errorHandler, "QUEUE AND WAIT FOR MODIFICATIONS TO FINISH", new GTask(){

                @Override
                public void run() throws DatabaseException {
                    for (IModification mod : ((DefaultDiagramMutator)DefaultDiagramMutator.this).GraphToDiagramSynchronizer.this.pendingModifications) {
                        ((DefaultDiagramMutator)DefaultDiagramMutator.this).GraphToDiagramSynchronizer.this.modificationQueue.offer(mod, null);
                    }
                    try {
                        ((DefaultDiagramMutator)DefaultDiagramMutator.this).GraphToDiagramSynchronizer.this.modificationQueue.finish();
                    }
                    catch (InterruptedException e) {
                        errorHandler.error("Diagram modification finishing was interrupted. See exception for details.", e);
                    }
                }
            });
            GraphToDiagramSynchronizer.this.pendingModifications.clear();
            GraphToDiagramSynchronizer.this.modificationIndex.clear();
            this.creation.clear();
            if (DebugPolicy.DEBUG_MUTATOR_COMMIT) {
                System.out.println("DiagramMutator has committed");
            }
        }

        public void clear() {
            this.assertNotDisposed();
            GraphToDiagramSynchronizer.this.pendingModifications.clear();
            GraphToDiagramSynchronizer.this.modificationIndex.clear();
            this.creation.clear();
            if (DebugPolicy.DEBUG_MUTATOR) {
                System.out.println("DiagramMutator has been cleared");
            }
        }

        public void modifyTransform(IElement element) {
            this.assertNotDisposed();
            Resource resource = (Resource)this.backendObject(element);
            AffineTransform tr = (AffineTransform)element.getHint(ElementHints.KEY_TRANSFORM);
            if (resource != null && tr != null) {
                GraphToDiagramSynchronizer.this.addModification(element, new TransformElement(resource, tr));
            }
        }

        public void synchronizeHintsToBackend(IElement element) {
            this.assertNotDisposed();
            IHintSynchronizer synchronizer = (IHintSynchronizer)element.getHint(SynchronizationHints.HINT_SYNCHRONIZER);
            if (synchronizer != null) {
                CollectingModificationQueue queue = new CollectingModificationQueue();
                synchronizer.synchronize(this.synchronizationContext, (IHintObservable)element);
                GraphToDiagramSynchronizer.this.addModification(element, new CompositeModification(ModificationAdapter.LOW_PRIORITY, queue.getQueue()));
            }
        }

        public void synchronizeElementOrder() {
            this.assertNotDisposed();
            List snapshot = this.d.getSnapshot();
            GraphToDiagramSynchronizer.this.addModification(null, new ElementReorder(this.d, snapshot));
        }

        public void register(IElement element, Object object) {
            this.creation.put(element, (Resource)object);
        }

        public <T> T backendObject(IElement element) {
            Object object = ElementUtils.getObject((IElement)element);
            if (object instanceof Resource) {
                return (T)object;
            }
            return (T)this.creation.get(element);
        }
    }

    class DiagramClassRequest
    extends BaseRequest2<Resource, DiagramClass> {
        public DiagramClassRequest(Resource resource) {
            super(GraphToDiagramSynchronizer.this.canvas, resource);
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<DiagramClass> procedure) {
            GraphToDiagramSynchronizer.this.adaptDiagramClass(graph, (Resource)this.data, procedure);
        }
    }

    public class DiagramContentListener
    extends BaseListener<Resource, DiagramContents> {
        public DiagramContentListener(Resource resource) {
            super(resource);
        }

        @Override
        public void execute(AsyncReadGraph graph, Object oldResult, Object newResult) {
            DiagramContents newContent;
            DiagramContents diagramContents = newContent = newResult == null ? new DiagramContents() : (DiagramContents)newResult;
            if (DebugPolicy.DISABLE_DIAGRAM_UPDATES) {
                System.out.println("Skipped diagram content update: " + newResult);
                return;
            }
            if (DebugPolicy.DEBUG_DIAGRAM_LISTENER) {
                System.out.println("diagram contents changed: " + oldResult + " => " + newResult);
            }
            GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.diagramGraphUpdater(newContent));
        }

        @Override
        public boolean isDisposed() {
            return !GraphToDiagramSynchronizer.this.isAlive();
        }

        @Override
        public void exception(AsyncReadGraph graph, Throwable t) {
            super.exception(graph, t);
            GraphToDiagramSynchronizer.this.error("DiagramContentRequest failed", t);
        }
    }

    class DiagramListener
    implements IDiagram.CompositionListener,
    IDiagram.CompositionVetoListener {
        DiagramListener() {
        }

        public boolean beforeElementAdded(IDiagram d, IElement e) {
            if (d == GraphToDiagramSynchronizer.this.diagram) {
                if (!(e instanceof Element)) {
                    GraphToDiagramSynchronizer.this.error("Attempting to add another implementation of IElement besides Element (=" + e.getElementClass().getClass().getName() + ") to the synchronized diagram which means that there is a bug somewhere! See stack trace to find out who is doing this!", new Exception("stacktrace"));
                    System.err.println("Attempting to add another implementation of IElement besides Element (=" + e.getElementClass().getClass().getName() + ") to the synchronized diagram which means that there is a bug somewhere! See Error Log.");
                    return false;
                }
                boolean pass = true;
                ElementClass ec = e.getElementClass();
                Resource resource = (Resource)ElementUtils.adapt((ElementClass)ec, Resource.class);
                if (resource == null) {
                    pass = false;
                    LOGGER.error("", (Throwable)new Exception("Attempted to add an element to the diagram that is not adaptable to Resource: " + e + ", class: " + ec));
                }
                for (Map.Entry entry : e.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                    Topology.Connection c = (Topology.Connection)entry.getValue();
                    Object edgeObject = ElementUtils.getObject((IElement)c.edge);
                    if (e != c.node) {
                        System.err.println("Invalid node in TerminalKeyOf hint: " + entry.getKey() + "=" + entry.getValue());
                        System.err.println("\tconnection.edge=" + c.edge);
                        System.err.println("\tconnection.node=" + c.node);
                        System.err.println("\tconnection.end=" + c.end);
                        System.err.println("\telement=" + e);
                        System.err.println("\telement class=" + e.getElementClass());
                        pass = false;
                    }
                    if (edgeObject instanceof EdgeResource) continue;
                    System.err.println("Invalid object in TerminalKeyOf hint edge: " + entry.getKey() + "=" + entry.getValue());
                    System.err.println("\tconnection.edge=" + c.edge);
                    System.err.println("\tconnection.node=" + c.node);
                    System.err.println("\tconnection.end=" + c.end);
                    System.err.println("\telement=" + e);
                    System.err.println("\telement class=" + e.getElementClass());
                    pass = false;
                }
                return pass;
            }
            return true;
        }

        public boolean beforeElementRemoved(IDiagram d, IElement e) {
            return true;
        }

        public void onElementAdded(IDiagram d, IElement e) {
            if (DebugPolicy.DEBUG_ELEMENT_LIFECYCLE) {
                System.out.println("[" + d + "] element added: " + e);
            }
        }

        public void onElementRemoved(IDiagram d, IElement e) {
            if (DebugPolicy.DEBUG_ELEMENT_LIFECYCLE) {
                System.out.println("[" + d + "] element removed: " + e);
            }
            if (e.containsHint(KEY_REMOVE_RELATIONSHIPS)) {
                GraphToDiagramSynchronizer.this.relationshipHandler.denyAll(GraphToDiagramSynchronizer.this.diagram, (Object)e);
            }
        }
    }

    static interface DiagramUpdater
    extends Runnable {
        public static final Comparator<DiagramUpdater> DIAGRAM_UPDATER_COMPARATOR = new Comparator<DiagramUpdater>(){

            @Override
            public int compare(DiagramUpdater o1, DiagramUpdater o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        };

        public Double getPriority();
    }

    static class ElementFactoryImpl
    implements org.simantics.g2d.diagram.handler.ElementFactory {
        ElementFactoryImpl() {
        }

        public IElement spawnNew(ElementClass clazz) {
            IElement e = Element.spawnNew((ElementClass)clazz);
            return e;
        }
    }

    class ElementLayerListenerImpl
    implements ElementLayerListener {
        private static final long serialVersionUID = -3410052116598828129L;

        ElementLayerListenerImpl() {
        }

        public void visibilityChanged(IElement e, ILayer layer, boolean visible) {
            GraphLayer gl;
            if (!GraphToDiagramSynchronizer.this.isAlive()) {
                return;
            }
            if (DebugPolicy.DEBUG_LAYERS) {
                System.out.println("visibility changed: " + e + ", " + layer + ", " + visible);
            }
            if ((gl = GraphToDiagramSynchronizer.this.layerManager.getGraphLayer(layer.getName())) != null) {
                this.changeTag(e, gl.getVisible(), visible);
            }
        }

        public void focusabilityChanged(IElement e, ILayer layer, boolean focusable) {
            GraphLayer gl;
            if (!GraphToDiagramSynchronizer.this.isAlive()) {
                return;
            }
            if (DebugPolicy.DEBUG_LAYERS) {
                System.out.println("focusability changed: " + e + ", " + layer + ", " + focusable);
            }
            if ((gl = GraphToDiagramSynchronizer.this.layerManager.getGraphLayer(layer.getName())) != null) {
                this.changeTag(e, gl.getFocusable(), focusable);
            }
        }

        void changeTag(IElement e, Resource tag, boolean set) {
            ConnectionEntity ce;
            Object object = e.getHint(ElementHints.KEY_OBJECT);
            Resource tagged = null;
            if (object instanceof Resource) {
                tagged = (Resource)object;
            } else if (object instanceof EdgeResource && (ce = (ConnectionEntity)e.getHint(ElementHints.KEY_CONNECTION_ENTITY)) instanceof ConnectionEntityImpl) {
                tagged = ((ConnectionEntityImpl)ce).connection;
            }
            if (tagged == null) {
                return;
            }
            GraphToDiagramSynchronizer.this.modificationQueue.async(new TagChange(tagged, tag, set), null);
        }
    }

    abstract class ElementUpdater
    extends AbstractDiagramUpdater {
        private final IElement newElement;

        public ElementUpdater(Double priority, String runnerName, IElement newElement) {
            super(priority, runnerName);
            if (newElement == null) {
                throw new NullPointerException("null element");
            }
            this.newElement = newElement;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "[" + this.newElement + "]";
        }

        @Override
        public void run() {
            Object elementResource = this.newElement.getHint(ElementHints.KEY_OBJECT);
            Element mappedElement = (Element)GraphToDiagramSynchronizer.this.getMappedElement(elementResource);
            if (mappedElement == null) {
                if (DebugPolicy.DEBUG_ELEMENT_LIFECYCLE) {
                    System.out.println("SKIP DIAGRAM UPDATE " + this + " for element resource " + elementResource + ", no mapped element (newElement=" + this.newElement + ")");
                }
                return;
            }
            Object task = Timing.BEGIN(this.runnerName);
            this.forMappedElement(mappedElement);
            Timing.END(task);
        }

        protected abstract void forMappedElement(Element var1);
    }

    class GraphToDiagramUpdater {
        DiagramContents lastContent;
        DiagramContents content;
        DiagramContentChanges changes;
        final List<IElement> addedElements;
        final List<IElement> removedElements;
        final List<IElement> addedConnectionSegments;
        final List<IElement> removedConnectionSegments;
        final List<IElement> addedBranchPoints;
        final List<IElement> removedBranchPoints;
        final Map<Object, IElement> addedElementMap;
        final Map<Resource, IElement> addedConnectionMap;
        final Map<Resource, ConnectionEntityImpl> addedConnectionEntities;
        final List<Resource> removedConnectionEntities;
        final Map<ConnectionEntityImpl, ConnectionData> changedConnectionEntities;
        final Map<Resource, IElement> addedRouteGraphConnectionMap;
        final List<IElement> removedRouteGraphConnections;
        ConnectionSegmentAdapter connectionSegmentAdapter = new DefaultConnectionSegmentAdapter();

        GraphToDiagramUpdater(DiagramContents lastContent, DiagramContents content, DiagramContentChanges changes) {
            this.lastContent = lastContent;
            this.content = content;
            this.changes = changes;
            this.addedElements = new ArrayList<IElement>(changes.elements.size() + changes.branchPoints.size());
            this.removedElements = new ArrayList<IElement>(changes.elements.size() + changes.branchPoints.size());
            this.addedConnectionSegments = new ArrayList<IElement>(content.connectionSegments.size());
            this.removedConnectionSegments = new ArrayList<IElement>(content.connectionSegments.size());
            this.addedBranchPoints = new ArrayList<IElement>(content.branchPoints.size());
            this.removedBranchPoints = new ArrayList<IElement>(content.branchPoints.size());
            this.addedElementMap = new HashMap<Object, IElement>();
            this.addedConnectionMap = new HashMap<Resource, IElement>();
            this.addedConnectionEntities = new HashMap<Resource, ConnectionEntityImpl>();
            this.removedConnectionEntities = new ArrayList<Resource>(changes.connections.size());
            this.changedConnectionEntities = new HashMap<ConnectionEntityImpl, ConnectionData>();
            this.addedRouteGraphConnectionMap = new HashMap<Resource, IElement>();
            this.removedRouteGraphConnections = new ArrayList<IElement>(changes.routeGraphConnections.size());
        }

        public void clear() {
            this.lastContent = null;
            this.content = null;
            this.changes = null;
            this.addedElements.clear();
            this.removedElements.clear();
            this.addedConnectionSegments.clear();
            this.removedConnectionSegments.clear();
            this.addedBranchPoints.clear();
            this.removedBranchPoints.clear();
            this.addedElementMap.clear();
            this.addedConnectionMap.clear();
            this.addedConnectionEntities.clear();
            this.removedConnectionEntities.clear();
            this.changedConnectionEntities.clear();
            this.addedRouteGraphConnectionMap.clear();
            this.removedRouteGraphConnections.clear();
        }

        void processNodes(AsyncReadGraph graph) throws DatabaseException {
            for (Map.Entry<Resource, Change> entry : this.changes.elements.entrySet()) {
                final Resource element = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case ADDED: {
                        IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(element);
                        if (mappedElement != null) break;
                        if (DebugPolicy.DEBUG_NODE_LOAD) {
                            graph.syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY ADDED ELEMENT: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)element) + " (" + element.getResourceId() + ")");
                                }
                            });
                        }
                        if (this.content.connectionSet.contains(element)) {
                            DisposableListener<IElement> loadListener = new DisposableListener<IElement>(GraphToDiagramSynchronizer.this.canvasListenerSupport){
                                boolean firstTime;
                                {
                                    super($anonymous0);
                                    this.firstTime = true;
                                }

                                public String toString() {
                                    return "Connection load listener for " + element;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void execute(IElement loaded) {
                                    Object data;
                                    if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                        System.out.println("CONNECTION LoadListener for " + loaded);
                                    }
                                    if (loaded == null) {
                                        this.disposeListener();
                                        return;
                                    }
                                    if (this.firstTime) {
                                        GraphToDiagramSynchronizer.this.mapElement(element, loaded);
                                        GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                        synchronized (graphToDiagramUpdater) {
                                            GraphToDiagramUpdater.this.addedElements.add(loaded);
                                            GraphToDiagramUpdater.this.addedElementMap.put(element, loaded);
                                            GraphToDiagramUpdater.this.addedConnectionMap.put(element, loaded);
                                        }
                                        this.firstTime = false;
                                    }
                                    if (!((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.previousContent.connectionSet.contains(data = loaded.getHint(ElementHints.KEY_OBJECT))) {
                                        if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                            System.out.println("CONNECTION LoadListener, connection not in current content: " + data + ". Disposing.");
                                        }
                                        this.disposeListener();
                                        return;
                                    }
                                    if (GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                                        IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                                        if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                            System.out.println("LOADED ADDED CONNECTION, currently mapped connection: " + mappedElement);
                                        }
                                        if (mappedElement != null && mappedElement instanceof Element) {
                                            if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                                System.out.println("  mapped hints: " + mappedElement.getHints());
                                                System.out.println("  loaded hints: " + loaded.getHints());
                                            }
                                            GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                                        }
                                    } else {
                                        if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                            System.out.println("PREVIOUSLY LOADED CONNECTION UPDATED, scheduling update into the future");
                                        }
                                        GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.connectionUpdater(element, loaded));
                                    }
                                }
                            };
                            graph.asyncRequest((AsyncRead)new ConnectionRequest(GraphToDiagramSynchronizer.this.canvas, GraphToDiagramSynchronizer.this.diagram, element, errorHandler, (Listener<IElement>)loadListener), (AsyncProcedure)new AsyncProcedure<IElement>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void execute(AsyncReadGraph graph, final IElement e) {
                                    GraphToDiagramSynchronizer.this.mapElement(element, e);
                                    GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                    synchronized (graphToDiagramUpdater) {
                                        GraphToDiagramUpdater.this.addedElements.add(e);
                                        GraphToDiagramUpdater.this.addedElementMap.put(element, e);
                                        GraphToDiagramUpdater.this.addedConnectionMap.put(element, e);
                                    }
                                    graph.forSingleType(element, ((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.br.DIA.Connection, (Procedure)new Procedure<Resource>(){

                                        public void exception(Throwable t) {
                                            GraphToDiagramSynchronizer.this.error(t);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void execute(Resource connectionType) {
                                            GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                            synchronized (graphToDiagramUpdater) {
                                                IElement mapped = GraphToDiagramSynchronizer.this.getMappedElement(element);
                                                if (!$assertionsDisabled && mapped == null) {
                                                    throw new AssertionError();
                                                }
                                                if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                                                    System.out.println("CONNECTION ENTITY CREATED " + e + " " + element);
                                                }
                                                ConnectionEntityImpl entity = new ConnectionEntityImpl(element, connectionType, mapped);
                                                mapped.setHint(ElementHints.KEY_CONNECTION_ENTITY, (Object)entity);
                                                (this).GraphToDiagramUpdater.this.addedConnectionEntities.put(element, entity);
                                            }
                                        }
                                    });
                                }

                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                    GraphToDiagramSynchronizer.this.error(throwable);
                                }
                            });
                            break;
                        }
                        if (!this.content.nodeSet.contains(element)) break;
                        graph.asyncRequest((Read)new ReadRequest(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(ReadGraph graph) throws DatabaseException {
                                LoadNodeListener loadListener = new LoadNodeListener(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvasListenerSupport, element);
                                Tuple3 t = (Tuple3)graph.syncRequest((AsyncRead)new NodeRequest2(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvas, ((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.diagram, element));
                                IElement e = (IElement)t.c0;
                                ElementClass ec = (ElementClass)t.c1;
                                ElementFactory ef = (ElementFactory)t.c2;
                                if (e == null) {
                                    return;
                                }
                                if (DebugPolicy.DEBUG_NODE_LOAD) {
                                    System.out.println("MAPPING ADDED NODE: " + element + " -> " + e);
                                }
                                GraphToDiagramSynchronizer.this.mapElement(element, e);
                                GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                synchronized (graphToDiagramUpdater) {
                                    GraphToDiagramUpdater.this.addedElements.add(e);
                                    GraphToDiagramUpdater.this.addedElementMap.put(element, e);
                                }
                                graph.syncRequest((AsyncRead)new LoadRequest(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvas, ((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.diagram, ef, ec, element), (Listener)loadListener);
                            }
                        });
                        break;
                    }
                    case REMOVED: {
                        IElement e = GraphToDiagramSynchronizer.this.getMappedElement(element);
                        if (DebugPolicy.DEBUG_NODE_LOAD) {
                            graph.syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY REMOVED ELEMENT: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)element) + " (" + element.getResourceId() + ")");
                                }
                            });
                        }
                        if (e == null) break;
                        this.removedElements.add(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void gatherChangedConnectionParts(Map<?, Change> changes) {
            block7: for (Map.Entry<?, Change> entry : changes.entrySet()) {
                Object part = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case ADDED: {
                        GraphToDiagramUpdater graphToDiagramUpdater = this;
                        synchronized (graphToDiagramUpdater) {
                            Resource connection = this.content.partToConnection.get(part);
                            assert (connection != null);
                            IElement ce = GraphToDiagramSynchronizer.this.getMappedElement(connection);
                            if (ce == null) {
                                ce = this.addedElementMap.get(connection);
                            }
                            if (ce != null) {
                                this.markConnectionChanged(ce);
                            }
                            break;
                        }
                    }
                    case REMOVED: {
                        Resource connection;
                        if (this.lastContent == null || (connection = this.lastContent.partToConnection.get(part)) == null || !this.content.connectionSet.contains(connection)) continue block7;
                        this.markConnectionChanged(connection);
                    }
                }
            }
        }

        void markConnectionChanged(Resource connection) {
            ConnectionEntityImpl ce = GraphToDiagramSynchronizer.this.getMappedConnection(connection);
            if (ce != null) {
                this.markConnectionChanged(ce);
                return;
            }
            GraphToDiagramSynchronizer.this.error("WARNING: marking connection entity " + connection + " changed, but the connection was not previously mapped", new Exception("created exception to get a stack trace"));
        }

        void markConnectionChanged(IElement connection) {
            ConnectionEntityImpl entity = (ConnectionEntityImpl)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (entity != null) {
                this.markConnectionChanged(entity);
            }
        }

        void markConnectionChanged(ConnectionEntityImpl ce) {
            if (!this.changedConnectionEntities.containsKey(ce)) {
                this.changedConnectionEntities.put(ce, new ConnectionData(ce));
            }
        }

        void processConnections() {
            this.gatherChangedConnectionParts(this.changes.connectionSegments);
            this.gatherChangedConnectionParts(this.changes.branchPoints);
            for (Map.Entry<Resource, Change> entry : this.changes.connections.entrySet()) {
                Resource ce = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case REMOVED: {
                        this.removedConnectionEntities.add(ce);
                    }
                }
            }
            for (ConnectionData cd : this.changedConnectionEntities.values()) {
                for (Object part : this.content.connectionToParts.getValuesUnsafe((Object)cd.impl.connection)) {
                    if (part instanceof Resource) {
                        cd.branchPoints.add((Resource)part);
                        continue;
                    }
                    if (!(part instanceof EdgeResource)) continue;
                    cd.segments.add((EdgeResource)part);
                }
            }
        }

        void processRouteGraphConnections(AsyncReadGraph graph) throws DatabaseException {
            block4: for (Map.Entry<Resource, Change> entry : this.changes.routeGraphConnections.entrySet()) {
                final Resource connection = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case ADDED: {
                        IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(connection);
                        if (mappedElement != null) continue block4;
                        graph.asyncRequest((Read)new ReadRequest(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(ReadGraph graph) throws DatabaseException {
                                LoadRouteGraphConnectionListener loadListener = new LoadRouteGraphConnectionListener(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvasListenerSupport, connection);
                                Tuple3 t = (Tuple3)graph.syncRequest((AsyncRead)new ConnectionRequest2(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvas, ((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.diagram, connection, errorHandler));
                                IElement e = (IElement)t.c0;
                                ElementClass ec = (ElementClass)t.c1;
                                ElementFactory ef = (ElementFactory)t.c2;
                                if (e == null) {
                                    return;
                                }
                                if (DebugPolicy.DEBUG_NODE_LOAD) {
                                    System.out.println("MAPPING ADDED ROUTE GRAPH CONNECTION: " + connection + " -> " + e);
                                }
                                GraphToDiagramSynchronizer.this.mapElement(connection, e);
                                GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                synchronized (graphToDiagramUpdater) {
                                    GraphToDiagramUpdater.this.addedElements.add(e);
                                    GraphToDiagramUpdater.this.addedElementMap.put(connection, e);
                                    GraphToDiagramUpdater.this.addedRouteGraphConnectionMap.put(connection, e);
                                }
                                graph.syncRequest((AsyncRead)new LoadRequest(((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.canvas, ((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.diagram, ef, ec, connection), (Listener)loadListener);
                            }
                        });
                        break;
                    }
                    case REMOVED: {
                        IElement e = GraphToDiagramSynchronizer.this.getMappedElement(connection);
                        if (e == null) break;
                        this.removedRouteGraphConnections.add(e);
                    }
                }
            }
        }

        ConnectionEntityImpl getConnectionEntity(Object connectionPart) {
            Resource connection = this.content.partToConnection.get(connectionPart);
            assert (connection != null);
            ConnectionEntityImpl ce = this.addedConnectionEntities.get(connection);
            if (ce != null) {
                return ce;
            }
            return GraphToDiagramSynchronizer.this.assertMappedConnection(connection);
        }

        void processBranchPoints(AsyncReadGraph graph) throws DatabaseException {
            for (Map.Entry<Resource, Change> entry : this.changes.branchPoints.entrySet()) {
                final Resource element = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case ADDED: {
                        IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(element);
                        if (mappedElement != null) break;
                        if (DebugPolicy.DEBUG_NODE_LOAD) {
                            graph.asyncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY ADDED BRANCH POINT: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)element) + " (" + element.getResourceId() + ")");
                                }
                            });
                        }
                        DisposableListener<IElement> loadListener = new DisposableListener<IElement>(GraphToDiagramSynchronizer.this.canvasListenerSupport){

                            public String toString() {
                                return "processBranchPoints for " + element;
                            }

                            public void execute(IElement loaded) {
                                if (DebugPolicy.DEBUG_NODE_LISTENER) {
                                    System.out.println("BRANCH POINT LoadListener for " + loaded);
                                }
                                if (loaded == null) {
                                    this.disposeListener();
                                    return;
                                }
                                Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                                if (GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                                    IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                                    if (DebugPolicy.DEBUG_NODE_LISTENER) {
                                        System.out.println("LOADED ADDED BRANCH POINT, currently mapped element: " + mappedElement);
                                    }
                                    if (mappedElement != null && mappedElement instanceof Element) {
                                        if (DebugPolicy.DEBUG_NODE_LISTENER) {
                                            System.out.println("  mapped hints: " + mappedElement.getHints());
                                            System.out.println("  loaded hints: " + loaded.getHints());
                                        }
                                        GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                                    }
                                } else {
                                    if (DebugPolicy.DEBUG_NODE_LISTENER) {
                                        System.out.println("PREVIOUSLY LOADED BRANCH POINT UPDATED, scheduling update into the future");
                                    }
                                    GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.nodeUpdater(element, loaded));
                                }
                            }
                        };
                        graph.asyncRequest((AsyncRead)new NodeRequest(GraphToDiagramSynchronizer.this.canvas, GraphToDiagramSynchronizer.this.diagram, element, (Listener<IElement>)loadListener), (AsyncProcedure)new AsyncProcedure<IElement>(){

                            public void execute(AsyncReadGraph graph, IElement e) {
                            }

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                GraphToDiagramSynchronizer.this.error(throwable);
                            }
                        });
                        break;
                    }
                    case REMOVED: {
                        IElement e = GraphToDiagramSynchronizer.this.getMappedElement(element);
                        if (DebugPolicy.DEBUG_NODE_LOAD) {
                            graph.syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY REMOVED BRANCH POINT: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)element) + " (" + element.getResourceId() + ")");
                                }
                            });
                        }
                        if (e == null) break;
                        this.removedBranchPoints.add(e);
                    }
                }
            }
        }

        void processConnectionSegments(AsyncReadGraph graph) throws DatabaseException {
            ConnectionSegmentAdapter adapter = this.connectionSegmentAdapter;
            for (Map.Entry<EdgeResource, Change> entry : this.changes.connectionSegments.entrySet()) {
                final EdgeResource seg = entry.getKey();
                Change change = entry.getValue();
                switch (change) {
                    case ADDED: {
                        IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(seg);
                        if (mappedElement != null) break;
                        if (DebugPolicy.DEBUG_EDGE_LOAD) {
                            graph.asyncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY ADDED CONNECTION SEGMENT: " + seg.toString() + " - " + seg.toString(graph));
                                }
                            });
                        }
                        graph.asyncRequest((AsyncRead)new EdgeRequest(GraphToDiagramSynchronizer.this, GraphToDiagramSynchronizer.this.canvas, errorHandler, GraphToDiagramSynchronizer.this.canvasListenerSupport, GraphToDiagramSynchronizer.this.diagram, adapter, seg), (AsyncProcedure)new AsyncProcedure<IElement>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void execute(AsyncReadGraph graph, IElement e) {
                                if (DebugPolicy.DEBUG_EDGE_LOAD) {
                                    System.out.println("ADDED EDGE LOADED: " + e + " " + seg);
                                }
                                if (e != null) {
                                    GraphToDiagramUpdater graphToDiagramUpdater = GraphToDiagramUpdater.this;
                                    synchronized (graphToDiagramUpdater) {
                                        GraphToDiagramUpdater.this.addedConnectionSegments.add(e);
                                        GraphToDiagramUpdater.this.addedElementMap.put(seg, e);
                                        ConnectionEntityImpl ce = GraphToDiagramUpdater.this.getConnectionEntity(seg);
                                        e.setHint(ElementHints.KEY_CONNECTION_ENTITY, (Object)ce);
                                        e.setHint(ElementHints.KEY_PARENT_ELEMENT, (Object)ce.getConnectionElement());
                                    }
                                }
                            }

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                GraphToDiagramSynchronizer.this.error(throwable);
                            }
                        });
                        break;
                    }
                    case REMOVED: {
                        final IElement e = GraphToDiagramSynchronizer.this.getMappedElement(seg);
                        if (DebugPolicy.DEBUG_EDGE_LOAD) {
                            graph.asyncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    System.out.println("    EXTERNALLY REMOVED CONNECTION SEGMENT: " + seg.toString() + " - " + seg.toString(graph) + " -> " + e);
                                }
                            });
                        }
                        if (e == null) break;
                        this.removedConnectionSegments.add(e);
                    }
                }
            }
        }

        void executeDeferredLoaders(ReadGraph graph) throws DatabaseException {
            ArrayDeque<IElement> q1 = new ArrayDeque<IElement>();
            ArrayDeque<IElement> q2 = new ArrayDeque<IElement>();
            this.collectElementLoaders(q1, this.addedElements);
            while (!q1.isEmpty()) {
                for (IElement e : q1) {
                    ElementLoader loader = (ElementLoader)e.removeHint(DiagramModelHints.KEY_ELEMENT_LOADER);
                    loader.load(graph, GraphToDiagramSynchronizer.this.diagram, e);
                }
                this.collectElementLoaders(q2, q1);
                ArrayDeque<IElement> qt = q1;
                q1 = q2;
                q2 = qt;
                q2.clear();
            }
        }

        private void collectElementLoaders(Queue<IElement> queue, Collection<IElement> cs) {
            for (IElement e : cs) {
                ElementLoader loader = (ElementLoader)e.getHint(DiagramModelHints.KEY_ELEMENT_LOADER);
                if (loader == null) continue;
                queue.add(e);
            }
        }

        public void process(ReadGraph graph) throws DatabaseException {
            if (this.changes.isEmpty()) {
                return;
            }
            ITask threadLog = ThreadLogger.task((Object)"processNodes");
            Object task = Timing.BEGIN("processNodesConnections");
            if (!this.changes.elements.isEmpty()) {
                graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                    public void run(AsyncReadGraph graph) throws DatabaseException {
                        GraphToDiagramUpdater.this.processNodes(graph);
                    }

                    public String toString() {
                        return "processNodes";
                    }
                });
            }
            threadLog.finish();
            threadLog = ThreadLogger.task((Object)"processConnections");
            this.processConnections();
            threadLog.finish();
            threadLog = ThreadLogger.task((Object)"processBranchPoints");
            if (!this.changes.branchPoints.isEmpty()) {
                graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                    public void run(AsyncReadGraph graph) throws DatabaseException {
                        GraphToDiagramUpdater.this.processBranchPoints(graph);
                    }

                    public String toString() {
                        return "processBranchPoints";
                    }
                });
            }
            threadLog.finish();
            Timing.END(task);
            threadLog = ThreadLogger.task((Object)"processConnectionSegments");
            task = Timing.BEGIN("processConnectionSegments");
            if (!this.changes.connectionSegments.isEmpty()) {
                graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                    public void run(AsyncReadGraph graph) throws DatabaseException {
                        GraphToDiagramUpdater.this.processConnectionSegments(graph);
                    }

                    public String toString() {
                        return "processConnectionSegments";
                    }
                });
            }
            threadLog.finish();
            Timing.END(task);
            threadLog = ThreadLogger.task((Object)"processRouteGraphConnections");
            task = Timing.BEGIN("processRouteGraphConnections");
            if (!this.changes.routeGraphConnections.isEmpty()) {
                graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                    public void run(AsyncReadGraph graph) throws DatabaseException {
                        GraphToDiagramUpdater.this.processRouteGraphConnections(graph);
                    }

                    public String toString() {
                        return "processRouteGraphConnections";
                    }
                });
            }
            Timing.END(task);
            threadLog.finish();
            task = Timing.BEGIN("executeDeferredLoaders");
            threadLog = ThreadLogger.task((Object)"executeDeferredLoaders");
            this.executeDeferredLoaders(graph);
            threadLog.finish();
            Timing.END(task);
        }

        public boolean isEmpty() {
            return this.addedElements.isEmpty() && this.removedElements.isEmpty() && this.addedConnectionSegments.isEmpty() && this.removedConnectionSegments.isEmpty() && this.addedBranchPoints.isEmpty() && this.removedBranchPoints.isEmpty() && this.addedConnectionEntities.isEmpty() && this.removedConnectionEntities.isEmpty() && this.addedRouteGraphConnectionMap.isEmpty() && this.removedRouteGraphConnections.isEmpty() && !this.changes.elementOrderChanged;
        }

        class DefaultConnectionSegmentAdapter
        implements ConnectionSegmentAdapter {
            DefaultConnectionSegmentAdapter() {
            }

            @Override
            public void getClass(AsyncReadGraph graph, EdgeResource edge, ConnectionInfo info, ListenerSupport listenerSupport, ICanvasContext canvas, IDiagram diagram, AsyncProcedure<ElementClass> procedure) {
                if (info.connectionType != null) {
                    NodeClassRequest request = new NodeClassRequest(canvas, diagram, info.connectionType, true);
                    graph.asyncRequest((AsyncRead)request, (Listener)new CacheListener(listenerSupport));
                    graph.asyncRequest((AsyncRead)request, procedure);
                } else {
                    procedure.execute(graph, null);
                }
            }

            @Override
            public void load(AsyncReadGraph graph, final EdgeResource edge, final ConnectionInfo info, ListenerSupport listenerSupport, ICanvasContext canvas, final IDiagram diagram, final IElement element) {
                graph.asyncRequest((Read)new Read<IElement>(){

                    public IElement perform(ReadGraph graph) throws DatabaseException {
                        DefaultConnectionSegmentAdapter.this.syncLoad(graph, edge, info, diagram, element);
                        return element;
                    }

                    public String toString() {
                        return "defaultConnectionSegmentAdapter";
                    }
                }, (Listener)new DisposableListener<IElement>(listenerSupport){

                    public String toString() {
                        return "DefaultConnectionSegmentAdapter listener for " + edge;
                    }

                    public void execute(IElement loaded) {
                        if (loaded == null) {
                            this.disposeListener();
                            return;
                        }
                        Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                        if (DebugPolicy.DEBUG_EDGE_LISTENER) {
                            System.out.println("EDGE LoadListener for " + loaded + " " + data);
                        }
                        if (((DefaultConnectionSegmentAdapter)DefaultConnectionSegmentAdapter.this).GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                            IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                            if (DebugPolicy.DEBUG_EDGE_LISTENER) {
                                System.out.println("LOADED ADDED EDGE, currently mapped element: " + mappedElement);
                            }
                            if (mappedElement != null && mappedElement instanceof Element) {
                                if (DebugPolicy.DEBUG_EDGE_LISTENER) {
                                    System.out.println("  mapped hints: " + mappedElement.getHints());
                                    System.out.println("  loaded hints: " + loaded.getHints());
                                }
                                GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                            }
                        } else {
                            if (DebugPolicy.DEBUG_EDGE_LISTENER) {
                                System.out.println("PREVIOUSLY LOADED EDGE UPDATED, scheduling update into the future");
                            }
                            GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.edgeUpdater(element, loaded));
                        }
                    }
                });
            }

            void syncLoad(ReadGraph graph, EdgeResource connectionSegment, final ConnectionInfo info, final IDiagram diagram, IElement element) throws DatabaseException {
                DesignatedTerminal secondTerminal;
                DesignatedTerminal firstTerminal;
                String err;
                if (!graph.hasStatement(connectionSegment.first()) && !graph.hasStatement(connectionSegment.second())) {
                    return;
                }
                Resource c = ConnectionUtil.tryGetConnection(graph, connectionSegment);
                if (c == null) {
                    if (DebugPolicy.DEBUG_CONNECTION_LOAD) {
                        System.out.println("Skipping edge " + connectionSegment + ". Both segment ends are not part of the same connection.");
                    }
                    return;
                }
                if (!info.isValid()) {
                    if (DebugPolicy.DEBUG_CONNECTION_LOAD) {
                        GraphToDiagramSynchronizer.this.warning("Cannot load edge " + connectionSegment + ". ConnectionInfo " + info + " is invalid.", (Exception)new DebugException("execution trace"));
                    }
                    return;
                }
                final Element edge = (Element)element;
                edge.setHint(ElementHints.KEY_OBJECT, (Object)connectionSegment);
                ConnectionSegmentEnd firstEnd = DiagramGraphUtil.resolveConnectionSegmentEnd(graph, connectionSegment.first());
                ConnectionSegmentEnd secondEnd = DiagramGraphUtil.resolveConnectionSegmentEnd(graph, connectionSegment.second());
                if (firstEnd == null || secondEnd == null) {
                    if (DebugPolicy.DEBUG_CONNECTION_LOAD) {
                        GraphToDiagramSynchronizer.this.warning("End attachments for edge " + connectionSegment + " are unresolved: (" + (Object)((Object)firstEnd) + "," + (Object)((Object)secondEnd) + ")", (Exception)new DebugException("execution trace"));
                    }
                    return;
                }
                if (DebugPolicy.DEBUG_CONNECTION_LOAD) {
                    System.out.println("CONNECTION INFO: " + connectionSegment + " - " + info);
                }
                if ((err = this.validateConnectivity(graph, connectionSegment, firstTerminal = DiagramGraphUtil.findDesignatedTerminal(graph, diagram, connectionSegment.first(), firstEnd), secondTerminal = DiagramGraphUtil.findDesignatedTerminal(graph, diagram, connectionSegment.second(), secondEnd))) != null) {
                    if (DebugPolicy.DEBUG_CONNECTION_LOAD) {
                        GraphToDiagramSynchronizer.this.warning(err, null);
                    }
                    return;
                }
                graph.syncRequest((AsyncRead)new AsyncReadRequest(){

                    public void run(AsyncReadGraph graph) {
                        ElementFactoryUtil.loadLayersForElement(graph, ((GraphToDiagramUpdater)((DefaultConnectionSegmentAdapter)DefaultConnectionSegmentAdapter.this).GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.layerManager, diagram, (IElement)edge, info.connection, (AsyncProcedure<IElement>)new AsyncProcedureAdapter<IElement>(){

                            public void exception(AsyncReadGraph graph, Throwable t) {
                                GraphToDiagramSynchronizer.this.error("failed to load layers for connection segment", t);
                            }
                        });
                    }
                });
                edge.setHintWithoutNotification(KEY_CONNECTION_BEGIN_PLACEHOLDER, (Object)new PlaceholderConnection(EdgeVisuals.EdgeEnd.Begin, firstTerminal.element.getHint(ElementHints.KEY_OBJECT), firstTerminal.terminal));
                edge.setHintWithoutNotification(KEY_CONNECTION_END_PLACEHOLDER, (Object)new PlaceholderConnection(EdgeVisuals.EdgeEnd.End, secondTerminal.element.getHint(ElementHints.KEY_OBJECT), secondTerminal.terminal));
                IModelingRules modelingRules = (IModelingRules)diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
                if (modelingRules != null) {
                    ConnectionVisualsLoader loader = (ConnectionVisualsLoader)diagram.getHint(DiagramModelHints.KEY_CONNECTION_VISUALS_LOADER);
                    if (loader != null) {
                        loader.loadConnectionVisuals(graph, modelingRules, info.connection, diagram, (IElement)edge, firstTerminal, secondTerminal);
                    } else {
                        DiagramGraphUtil.loadConnectionVisuals(graph, modelingRules, info.connection, diagram, (IElement)edge, firstTerminal, secondTerminal);
                    }
                }
            }

            private String validateConnectivity(ReadGraph graph, EdgeResource edge, DesignatedTerminal firstTerminal, DesignatedTerminal secondTerminal) throws DatabaseException {
                boolean stray;
                boolean firstLoose = firstTerminal == null;
                boolean secondLoose = secondTerminal == null;
                boolean bl = stray = firstLoose && secondLoose;
                if (firstTerminal == null || secondTerminal == null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("encountered ");
                    sb.append(stray ? "stray" : "loose");
                    sb.append(" connection segment, ");
                    if (firstLoose) {
                        sb.append("first ");
                    }
                    if (stray) {
                        sb.append("and ");
                    }
                    if (secondLoose) {
                        sb.append("second ");
                    }
                    sb.append("end disconnected: ");
                    sb.append(edge.toString(graph));
                    sb.append(" - ");
                    sb.append(edge.toString());
                    return sb.toString();
                }
                return null;
            }
        }

        class LoadNodeListener
        extends DisposableListener<IElement> {
            final Resource element;
            public IElement lastLoaded;

            public LoadNodeListener(ListenerSupport support, Resource element) {
                super(support);
                this.element = element;
            }

            public String toString() {
                return "Node load listener for " + this.element;
            }

            public void applyFirst(IElement loaded) {
                Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                if (GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                    IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                    if (DebugPolicy.DEBUG_NODE_LISTENER) {
                        System.out.println("LOADED ADDED ELEMENT, currently mapped element: " + mappedElement);
                    }
                    if (mappedElement != null && mappedElement instanceof Element) {
                        if (DebugPolicy.DEBUG_NODE_LISTENER) {
                            System.out.println("  mapped hints: " + mappedElement.getHints());
                            System.out.println("  loaded hints: " + loaded.getHints());
                        }
                        GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                    }
                }
            }

            public void execute(IElement loaded) {
                if (DebugPolicy.DEBUG_NODE_LISTENER) {
                    System.out.println("NODE LoadListener for " + loaded);
                }
                if (loaded == null) {
                    this.disposeListener();
                    return;
                }
                boolean first = this.lastLoaded == null;
                this.lastLoaded = loaded;
                if (first) {
                    this.applyFirst(loaded);
                    return;
                }
                Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                if (!((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.previousContent.nodeSet.contains(data)) {
                    if (DebugPolicy.DEBUG_NODE_LISTENER) {
                        System.out.println("NODE LoadListener, node not in current content: " + data + ". Disposing.");
                    }
                    this.disposeListener();
                    return;
                }
                if (DebugPolicy.DEBUG_NODE_LISTENER) {
                    System.out.println("PREVIOUSLY LOADED NODE UPDATED, scheduling update into the future");
                }
                GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.nodeUpdater(this.element, loaded));
            }
        }

        class LoadRouteGraphConnectionListener
        extends DisposableListener<IElement> {
            final Resource connection;
            public IElement lastLoaded;

            public LoadRouteGraphConnectionListener(ListenerSupport support, Resource connection) {
                super(support);
                this.connection = connection;
            }

            public String toString() {
                return "processRouteGraphConnections " + this.connection;
            }

            public void applyFirst(IElement loaded) {
                Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                if (GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                    IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                    if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                        System.out.println("LOADED ADDED ROUTE GRAPH CONNECTION, currently mapped connection: " + mappedElement);
                    }
                    if (mappedElement instanceof Element) {
                        if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                            System.out.println("  mapped hints: " + mappedElement.getHints());
                            System.out.println("  loaded hints: " + loaded.getHints());
                        }
                        GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                    }
                }
            }

            public void execute(IElement loaded) {
                if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                    System.out.println("ROUTE GRAPH CONNECTION LoadListener for " + loaded);
                }
                if (loaded == null) {
                    this.disposeListener();
                    return;
                }
                boolean first = this.lastLoaded == null;
                this.lastLoaded = loaded;
                if (first) {
                    this.applyFirst(loaded);
                    return;
                }
                Object data = loaded.getHint(ElementHints.KEY_OBJECT);
                if (!((GraphToDiagramUpdater)GraphToDiagramUpdater.this).GraphToDiagramSynchronizer.this.previousContent.routeGraphConnectionSet.contains(data)) {
                    if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                        System.out.println("ROUTE GRAPH CONNECTION LoadListener, connection not in current content: " + data + ". Disposing.");
                    }
                    this.disposeListener();
                    return;
                }
                if (GraphToDiagramUpdater.this.addedElementMap.containsKey(data)) {
                    IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(data);
                    if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                        System.out.println("LOADED ADDED ROUTE GRAPH CONNECTION, currently mapped connection: " + mappedElement);
                    }
                    if (mappedElement instanceof Element) {
                        if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                            System.out.println("  mapped hints: " + mappedElement.getHints());
                            System.out.println("  loaded hints: " + loaded.getHints());
                        }
                        GraphToDiagramSynchronizer.updateMappedElement((Element)mappedElement, loaded);
                    }
                } else {
                    if (DebugPolicy.DEBUG_CONNECTION_LISTENER) {
                        System.out.println("PREVIOUSLY LOADED ROUTE GRAPH CONNECTION UPDATED, scheduling update into the future: " + this.connection);
                    }
                    THashSet dirtyNodes = new THashSet(4);
                    IElement mappedElement = GraphToDiagramSynchronizer.this.getMappedElement(this.connection);
                    ConnectionEntity ce = (ConnectionEntity)mappedElement.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                    if (ce != null) {
                        for (Topology.Connection conn : ce.getTerminalConnections(null)) {
                            Object o = conn.node.getHint(ElementHints.KEY_OBJECT);
                            if (o == null) continue;
                            dirtyNodes.add(o);
                            if (!DebugPolicy.DEBUG_CONNECTION_LISTENER) continue;
                            System.out.println("Marked connectivity dirty for node: " + conn.node);
                        }
                    }
                    GraphToDiagramSynchronizer.this.offerGraphUpdate(GraphToDiagramSynchronizer.this.routeGraphConnectionUpdater(this.connection, loaded, (Set<Object>)dirtyNodes));
                }
            }
        }
    }

    static interface GraphUpdateReactor {
        public DiagramUpdater graphUpdate(ReadGraph var1) throws DatabaseException;
    }

    static class PlaceholderConnection {
        public final EdgeVisuals.EdgeEnd end;
        public final Object node;
        public final Topology.Terminal terminal;

        public PlaceholderConnection(EdgeVisuals.EdgeEnd end, Object node, Topology.Terminal terminal) {
            this.end = end;
            this.node = node;
            this.terminal = terminal;
        }
    }

    static enum State {
        INITIAL,
        LOADING,
        UPDATING_DIAGRAM,
        IDLE,
        DISPOSED;

    }

    static interface StateRunnable
    extends Runnable {
        public void execute() throws InvocationTargetException;

        public static abstract class Stub
        implements StateRunnable {
            @Override
            public void run() {
            }

            @Override
            public final void execute() throws InvocationTargetException {
                try {
                    this.perform();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                catch (LinkageError e) {
                    throw new InvocationTargetException(e);
                }
            }

            protected abstract void perform() throws Exception;
        }
    }

    class SubstituteElementClassImpl
    implements SubstituteElementClass {
        SubstituteElementClassImpl() {
        }

        public ElementClass substitute(IDiagram d, ElementClass ec) {
            if (d != GraphToDiagramSynchronizer.this.diagram) {
                throw new IllegalArgumentException("specified diagram does not have this SubstituteElementClass handler");
            }
            if (ec.contains((Object)GraphToDiagramSynchronizer.this.elementLayerListener)) {
                return ec;
            }
            List all = ec.getAll();
            ArrayList<ElementLayerListenerImpl> result = new ArrayList<ElementLayerListenerImpl>(all.size());
            for (ElementHandler eh : all) {
                if (eh instanceof ElementLayerListenerImpl) {
                    result.add(GraphToDiagramSynchronizer.this.elementLayerListener);
                    continue;
                }
                result.add((ElementLayerListenerImpl)eh);
            }
            return ElementClass.compile(result, (boolean)false).setId(ec.getId());
        }
    }

    static class TopologyImpl
    implements Topology {
        TopologyImpl() {
        }

        public Topology.Connection getConnection(IElement edge, EdgeVisuals.EdgeEnd end) {
            EndKeyOf key = EndKeyOf.get((EdgeVisuals.EdgeEnd)end);
            Topology.Connection c = (Topology.Connection)edge.getHint((IHintContext.Key)key);
            if (c == null) {
                return null;
            }
            return c;
        }

        public void getConnections(IElement node, Topology.Terminal terminal, Collection<Topology.Connection> connections) {
            for (Map.Entry entry : node.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                Topology.Connection c;
                TerminalKeyOf key = (TerminalKeyOf)entry.getKey();
                if (!key.getTerminal().equals(terminal) || (c = (Topology.Connection)entry.getValue()) == null) continue;
                connections.add(c);
            }
        }

        public void connect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
            if (node != null && terminal != null) {
                GraphToDiagramSynchronizer.connect(edge, end, node, terminal);
            }
            if (DebugPolicy.DEBUG_CONNECTION) {
                if (end == EdgeVisuals.EdgeEnd.Begin) {
                    System.out.println("Connection started from: " + edge + ", " + end + ", " + node + ", " + terminal);
                } else {
                    System.out.println("Creating connection to: " + edge + ", " + end + ", " + node + ", " + terminal);
                }
            }
        }

        public void disconnect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
            EndKeyOf edgeKey = EndKeyOf.get((EdgeVisuals.EdgeEnd)end);
            Topology.Connection c = (Topology.Connection)edge.getHint((IHintContext.Key)edgeKey);
            if (c == null) {
                throw new UnsupportedOperationException("cannot disconnect, no Connection in edge " + edge);
            }
            for (Map.Entry entry : node.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
                Topology.Connection cc = (Topology.Connection)entry.getValue();
                if (c != cc) continue;
                node.removeHint((IHintContext.Key)entry.getKey());
                edge.removeHint((IHintContext.Key)edgeKey);
                return;
            }
            throw new UnsupportedOperationException("cannot disconnect, no connection between found between edge " + edge + " and node " + node);
        }
    }

    class TransactionListener
    extends SessionEventListenerAdapter {
        long startTime;

        TransactionListener() {
        }

        public void writeTransactionStarted() {
            this.startTime = System.nanoTime();
            if (DebugPolicy.DEBUG_WRITE_TRANSACTIONS) {
                System.out.println(String.valueOf(GraphToDiagramSynchronizer.class.getSimpleName()) + ".sessionEventListener.writeTransactionStarted");
            }
            GraphToDiagramSynchronizer.this.inWriteTransaction.set(true);
        }

        public void writeTransactionFinished() {
            long endTime = System.nanoTime();
            if (DebugPolicy.DEBUG_WRITE_TRANSACTIONS) {
                System.out.println(String.valueOf(GraphToDiagramSynchronizer.class.getSimpleName()) + ".sessionEventListener.writeTransactionFinished: " + (double)(endTime - this.startTime) * 1.0E-6 + " ms");
            }
            GraphToDiagramSynchronizer.this.inWriteTransaction.set(false);
            GraphToDiagramSynchronizer.this.scheduleGraphUpdates();
        }
    }

    static class TransientElementObject {
        TransientElementObject() {
        }

        public String toString() {
            return "MUTATOR GENERATED (hash=" + System.identityHashCode(this) + ")";
        }
    }
}

