/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn.cluster;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceTable;

class SizeOfObjectTable
implements ClusterI.ObjectProcedure<Integer> {
    private final ResourceTable mrResourceTable;
    private final PredicateTable mrPredicateTable;
    private final ObjectTable mrObjectTable;
    private int size = 0;

    SizeOfObjectTable(ResourceTable resourceTable, PredicateTable predicateTable, ObjectTable objectTable) {
        this.mrResourceTable = resourceTable;
        this.mrPredicateTable = predicateTable;
        this.mrObjectTable = objectTable;
    }

    public boolean execute(Integer i, int resourceRef) {
        int predicateIndex = this.mrResourceTable.getPredicateIndex(resourceRef);
        if (predicateIndex == 0) {
            return false;
        }
        ClusterI.PredicateProcedure<Object> procedure = new ClusterI.PredicateProcedure<Object>(){

            public boolean execute(Object context, int pRef, int oIndex) {
                if (ClusterTraits.statementIndexIsDirect((int)oIndex)) {
                    return false;
                }
                try {
                    int objectIndex = ClusterTraits.statementIndexGet((int)oIndex);
                    SizeOfObjectTable.this.size += SizeOfObjectTable.this.mrObjectTable.getObjectSetSize(objectIndex);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                return false;
            }
        };
        try {
            this.mrPredicateTable.foreachPredicate(predicateIndex, (ClusterI.PredicateProcedure)procedure, null, null, null);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }
}

