/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.swt.InputSourceImpl;
import org.simantics.browsing.ui.swt.widgets.DragSourceListenerFactory;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.ModelBrowser;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.layer0.variable.VariableBean;
import org.simantics.db.management.ISessionContext;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.server.io.IJSONObject;
import org.simantics.document.server.io.JSONObjectUtils;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.bean.ColumnBean;
import org.simantics.document.swt.core.bean.ColumnsBean;
import org.simantics.document.swt.core.widget.ExplorerListener;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.Pair;

public class Explorer
extends LeafWidgetManager<ModelBrowser> {
    @Override
    protected void doUpdateProperties(SWTDocument document, ModelBrowser control, JSONObject object) {
    }

    protected Column[] getColumns(ColumnsBean bean) {
        Column[] result = new Column[bean.columns.length];
        int i = 0;
        while (i < bean.columns.length) {
            ColumnBean cb = bean.columns[i];
            result[i] = new Column(cb.key, cb.label, Column.Align.valueOf((String)cb.alignment), cb.width, cb.tooltip, cb.grab, cb.weight);
            ++i;
        }
        return result;
    }

    @Override
    protected ModelBrowser doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        Boolean check;
        Boolean noscroll;
        Boolean hscroll;
        Boolean vscroll;
        String browseContext = (String)object.getJSONField("browseContext");
        if (browseContext == null) {
            return null;
        }
        String contextMenuId = (String)object.getJSONField("contextMenuId");
        Boolean displayFilter = (Boolean)object.getJSONField("displayFilter");
        Boolean displayHeader = (Boolean)object.getJSONField("displayHeader");
        Integer style = (Integer)object.getJSONField("style");
        if (style == null) {
            style = 65536;
        }
        if (Boolean.TRUE.equals(vscroll = (Boolean)object.getJSONFieldDefault("VScroll", (Object)false))) {
            style = style | 0x200;
        }
        if (Boolean.TRUE.equals(hscroll = (Boolean)object.getJSONFieldDefault("HScroll", (Object)false))) {
            style = style | 0x100;
        }
        if (Boolean.TRUE.equals(noscroll = (Boolean)object.getJSONFieldDefault("NoScroll", (Object)false))) {
            style = style | 0x10;
        }
        if (Boolean.TRUE.equals(check = (Boolean)object.getJSONFieldDefault("Check", (Object)false))) {
            style = style | 0x20;
        }
        StatePersistor persistor = (StatePersistor)object.getJSONField("persistor");
        final Function1 selectionListener = (Function1)object.getJSONField("selectionListener");
        final Function2 checkStateListener = (Function2)object.getJSONField("checkStateListener");
        DragSourceListenerFactory dragSourceListenerFactory = (DragSourceListenerFactory)object.getJSONField("dragSourceListenerFactory");
        IWorkbenchSite site = document.getSite();
        final ISelectionProvider selectionProvider = document.getSelectionProvider();
        HashMap<String, Boolean> args = new HashMap<String, Boolean>();
        args.put("displaySelectors", Boolean.FALSE);
        args.put("displayFilter", displayFilter != null ? displayFilter : Boolean.FALSE);
        ColumnsBean columns = (ColumnsBean)object.getBeanJSONFieldDefault("columns", ColumnsBean.BINDING, null);
        String editingColumn = (String)object.getJSONFieldDefault("editingColumn", null);
        final ModelBrowser control = new ModelBrowser(Collections.singleton(browseContext), args, site, parent, (WidgetSupport)new WidgetSupportImpl(), style.intValue());
        Tree tree = (Tree)control.getExplorerControl();
        tree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                SWTViews.notifyScrolledComposite((Control)control);
            }
        });
        if (columns != null) {
            control.setColumns(this.getColumns(columns));
        }
        if (editingColumn != null) {
            control.setEditingColumn(new String[]{editingColumn});
        }
        if (contextMenuId != null) {
            control.setContextMenuId(contextMenuId);
        }
        if (dragSourceListenerFactory != null) {
            control.setDragSourceListenerFactory(dragSourceListenerFactory);
        }
        if (displayHeader != null) {
            tree.setHeaderVisible(displayHeader.booleanValue());
        }
        control.setStatePersistor(persistor);
        control.finish();
        control.setInputSource((GraphExplorerComposite.InputSource)new InputSourceImpl<Object>(){

            public Object get(ISessionContext ctx, Object selection) {
                return selection;
            }
        });
        Object i = object.getJSONField("explorerInput");
        if (i instanceof VariableBean) {
            control.setInput(Simantics.getSessionContext(), (Object)((VariableBean)i).getVariable());
        } else {
            control.setInput(Simantics.getSessionContext(), i);
        }
        control.addListenerToControl(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (event.detail != 32 || event.item == null) break;
                        TreeItem item = (TreeItem)event.item;
                        item.getChecked();
                        if (checkStateListener == null) break;
                        selectionListener.apply((Object)event);
                    }
                }
                if (selectionListener != null) {
                    selectionListener.apply((Object)event);
                }
                ISelection selection = (ISelection)control.getExplorer().getWidgetSelection();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            }
        });
        return control;
    }

    @Override
    public String getProperty(SWTDocument document, JSONObject object, WidgetContainer<ModelBrowser> widget, String property) {
        if ("selection".equals(property)) {
            ISelection selection = (ISelection)widget.getControl().getExplorer().getWidgetSelection();
            return SWTViews.encode(object, property, WorkbenchSelectionUtils.getWorkbenchSelectionElements((ISelection)selection));
        }
        return null;
    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, WidgetContainer widget, ICommand command, CommandContext p) {
        if ("onCheck".equals(command.getCommand())) {
            CommandContextMutable context = new CommandContextImpl().merge(p);
            AbstractEventHandler onCheck = (AbstractEventHandler)object.getJSONField("onCheck");
            return new PostEventCommand(document, (org.simantics.document.server.io.AbstractEventHandler)onCheck, context);
        }
        return null;
    }

    public static class ExplorerCommandManager
    implements CommandManager<SWTDocument, WidgetContainer<ModelBrowser>> {
        public Collection<Object> updateCommandListeners(SWTDocument document, JSONObject object, WidgetContainer<ModelBrowser> container) {
            WidgetData wd = document.getWidget(JSONObjectUtils.getId((IJSONObject)object));
            List commands = (List)object.getJSONField("commands");
            HashSet<Object> listeners = new HashSet<Object>();
            ArrayList<Pair<WidgetData, ICommand>> data = new ArrayList<Pair<WidgetData, ICommand>>();
            data.addAll(SWTViews.getTriggeredCommands(document, commands, "eventOut"));
            data.add(new Pair((Object)wd, (Object)new Command("onCheck")));
            ExplorerListener listener = new ExplorerListener(wd, data);
            ModelBrowser browser = container.getControl();
            if (!browser.isDisposed()) {
                browser.addListenerToControl(13, (Listener)listener);
                listeners.add(listener);
            }
            return listeners;
        }

        public void removeListener(WidgetContainer<ModelBrowser> container, Object listener) {
            if (container.getControl().isDisposed()) {
                return;
            }
            if (listener instanceof ExplorerListener) {
                container.getControl().removeListenerFromControl(13, (Listener)listener);
            }
        }
    }
}

