/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;

public abstract class UnaryQuery<Procedure>
extends CacheEntryBase<Procedure>
implements Query {
    public final int id;

    public UnaryQuery(int r) {
        assert (r != 0);
        this.id = r;
    }

    @Override
    int makeHash() {
        return this.id;
    }

    @Override
    public int type() {
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnaryQuery other = (UnaryQuery)object;
        return this.id == other.id;
    }

    @Override
    public final Query getQuery() {
        assert (!this.isDiscarded());
        return this;
    }

    @Override
    public abstract void removeEntry(QueryProcessor var1);

    public Object get(ReadGraphImpl graph, Procedure procedure) throws Throwable {
        if (procedure != null) {
            this.performFromCache(graph, procedure);
        } else {
            this.checkAndThrow();
        }
        return this.getResult();
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        return graph.processor.isImmutable(this.id);
    }

    @Override
    public long cluster(QueryProcessor processor) {
        return processor.cluster(this.id);
    }

    @Override
    public void serializeKey(QuerySerializer serializer) {
        serializer.addResource(this.id);
    }
}

