/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.AsyncMultiReadEntry;
import org.simantics.db.impl.query.AsyncReadEntry;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.ChildMap;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.DoubleKeyQueryHashMap;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.MultiReadEntry;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.ReadEntry;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.StableHashMap;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.UnaryQueryHashMap;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;

public class QueryCacheBase {
    final int THREADS;
    public final int THREAD_MASK;
    int hits = 0;
    int misses = 0;
    int updates = 0;
    public int size = 0;
    public volatile boolean dirty = false;
    public boolean collecting = false;
    protected final THashMap<String, URIToResource> uRIToResourceMap;
    protected final UnaryQueryHashMap<InternalProcedure<ObjectResourceIdMap<String>>> childMapMap;
    protected final DoubleKeyQueryHashMap<IntProcedure> objectsMap;
    protected final DoubleKeyQueryHashMap<TripleIntProcedure> assertedStatementsMap;
    protected final DoubleKeyQueryHashMap<IntProcedure> directObjectsMap;
    protected final DoubleKeyQueryHashMap<TripleIntProcedure> statementsMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> typesMap;
    protected final UnaryQueryHashMap<IntProcedure> principalTypesMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> predicatesMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> superTypesMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> typeHierarchyMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> superRelationsMap;
    protected final UnaryQueryHashMap<IntProcedure> orderedSetMap;
    protected final UnaryQueryHashMap<IntProcedure> assertedPredicatesMap;
    protected final UnaryQueryHashMap<InternalProcedure<IntSet>> directPredicatesMap;
    protected final UnaryQueryHashMap<IntProcedure> directSuperRelationsMap;
    protected final UnaryQueryHashMap<InternalProcedure<RelationInfo>> relationInfoQueryMap;
    protected final UnaryQueryHashMap<InternalProcedure<byte[]>> valueQueryMap;
    protected final StableHashMap<AsyncRead, AsyncReadEntry> asyncReadEntryMap;
    protected final StableHashMap<Read, ReadEntry> readEntryMap;
    protected final StableHashMap<MultiRead, MultiReadEntry> multiReadEntryMap;
    protected final StableHashMap<AsyncMultiRead, AsyncMultiReadEntry> asyncMultiReadEntryMap;
    protected final StableHashMap<ExternalRead, ExternalReadEntry> externalReadEntryMap;
    public final QuerySupport querySupport;
    protected static InternalProcedure<IntSet> emptyIntSetProcedure = new InternalProcedure<IntSet>(){

        @Override
        public void execute(ReadGraphImpl graph, IntSet result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<byte[]> emptyBytesProcedure = new InternalProcedure<byte[]>(){

        @Override
        public void execute(ReadGraphImpl graph, byte[] bytes) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<Integer> emptyIntegerProcedure = new InternalProcedure<Integer>(){

        @Override
        public void execute(ReadGraphImpl graph, Integer i) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<TObjectIntHashMap<String>> emptyNamespaceProcedure = new InternalProcedure<TObjectIntHashMap<String>>(){

        @Override
        public void execute(ReadGraphImpl graph, TObjectIntHashMap<String> i) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<RelationInfo> emptyRelationInfoProcedure = new InternalProcedure<RelationInfo>(){

        @Override
        public void execute(ReadGraphImpl graph, RelationInfo i) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<ObjectResourceIdMap<String>> emptyChildMapProcedure = new InternalProcedure<ObjectResourceIdMap<String>>(){

        @Override
        public void execute(ReadGraphImpl graph, ObjectResourceIdMap<String> i) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static IntProcedure emptyIntProcedure = new IntProcedure(){

        @Override
        public void finished(ReadGraphImpl graph) {
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static TripleIntProcedure emptyTripleIntProcedure = new TripleIntProcedure(){

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };
    protected static AsyncProcedure<Object> emptyAsyncProcedure = new AsyncProcedure<Object>(){

        public void execute(AsyncReadGraph graph, Object result) {
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
        }
    };
    protected static AsyncMultiProcedure<Object> emptyAsyncMultiProcedure = new AsyncMultiProcedure<Object>(){

        public void execute(AsyncReadGraph graph, Object result) {
        }

        public void finished(AsyncReadGraph graph) {
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
        }
    };
    protected static SyncMultiProcedure<Object> emptySyncMultiProcedure = new SyncMultiProcedure<Object>(){

        public void execute(ReadGraph graph, Object result) {
        }

        public void finished(ReadGraph graph) {
        }

        public void exception(ReadGraph graph, Throwable throwable) {
        }
    };
    protected static InternalProcedure<IntSet> emptyProcedureTypes = emptyIntSetProcedure;
    protected static InternalProcedure<IntSet> emptyProcedureSuperTypes = emptyIntSetProcedure;
    protected static InternalProcedure<IntSet> emptyProcedureTypeHierarchy = emptyIntSetProcedure;
    protected static InternalProcedure<IntSet> emptyProcedureSuperRelations = emptyIntSetProcedure;
    protected static InternalProcedure<IntSet> emptyProcedurePredicates = emptyIntSetProcedure;
    protected static InternalProcedure<IntSet> emptyProcedureDirectPredicates = emptyIntSetProcedure;
    protected static IntProcedure emptyProcedureObjects = emptyIntProcedure;
    protected static IntProcedure emptyProcedureDirectObjects = emptyIntProcedure;
    protected static IntProcedure emptyProcedurePrincipalTypes = emptyIntProcedure;
    protected static IntProcedure emptyProcedureDirectSuperRelations = emptyIntProcedure;
    protected static IntProcedure emptyProcedureAssertedPredicates = emptyIntProcedure;
    protected static IntProcedure emptyProcedureOrderedSet = emptyIntProcedure;
    protected static TripleIntProcedure emptyProcedureStatements = emptyTripleIntProcedure;
    protected static TripleIntProcedure emptyProcedureAssertedStatements = emptyTripleIntProcedure;
    protected static InternalProcedure<byte[]> emptyProcedureValueQuery = emptyBytesProcedure;
    protected static InternalProcedure<Integer> emptyProcedureURIToResource = emptyIntegerProcedure;
    protected static InternalProcedure<TObjectIntHashMap<String>> emptyProcedureNamespaceIndex = emptyNamespaceProcedure;
    protected static InternalProcedure<ObjectResourceIdMap<String>> emptyProcedureChildMap = emptyChildMapProcedure;
    protected static InternalProcedure<RelationInfo> emptyProcedureRelationInfoQuery = emptyRelationInfoProcedure;
    protected static AsyncProcedure emptyProcedureReadEntry = emptyAsyncProcedure;
    protected static AsyncProcedure emptyProcedureAsyncReadEntry = emptyAsyncProcedure;
    protected static SyncMultiProcedure emptyProcedureMultiReadEntry = emptySyncMultiProcedure;
    protected static AsyncMultiProcedure emptyProcedureAsyncMultiReadEntry = emptyAsyncMultiProcedure;
    protected static AsyncProcedure emptyProcedureExternalReadEntry = emptyAsyncProcedure;

    public QueryCacheBase(QuerySupport querySupport, int threads) {
        this.THREADS = threads;
        this.THREAD_MASK = threads - 1;
        this.querySupport = querySupport;
        this.directPredicatesMap = new UnaryQueryHashMap();
        this.directSuperRelationsMap = new UnaryQueryHashMap();
        this.valueQueryMap = new UnaryQueryHashMap();
        this.principalTypesMap = new UnaryQueryHashMap();
        this.uRIToResourceMap = new THashMap();
        this.childMapMap = new UnaryQueryHashMap();
        this.relationInfoQueryMap = new UnaryQueryHashMap();
        this.typeHierarchyMap = new UnaryQueryHashMap();
        this.superTypesMap = new UnaryQueryHashMap();
        this.superRelationsMap = new UnaryQueryHashMap();
        this.typesMap = new UnaryQueryHashMap();
        this.objectsMap = new DoubleKeyQueryHashMap();
        this.orderedSetMap = new UnaryQueryHashMap();
        this.predicatesMap = new UnaryQueryHashMap();
        this.statementsMap = new DoubleKeyQueryHashMap();
        this.directObjectsMap = new DoubleKeyQueryHashMap();
        this.assertedPredicatesMap = new UnaryQueryHashMap();
        this.assertedStatementsMap = new DoubleKeyQueryHashMap();
        this.asyncReadEntryMap = new StableHashMap();
        this.readEntryMap = new StableHashMap();
        this.asyncMultiReadEntryMap = new StableHashMap();
        this.multiReadEntryMap = new StableHashMap();
        this.externalReadEntryMap = new StableHashMap();
    }

    public <T> Object performQuery(final ReadGraphImpl parentGraph, AsyncMultiRead<T> query, CacheEntryBase entry_, Object procedure_) throws DatabaseException {
        ReadGraphImpl queryGraph = parentGraph.withParent(entry_, null, false);
        final AsyncMultiReadEntry entry = (AsyncMultiReadEntry)entry_;
        final AsyncMultiProcedure procedure = (AsyncMultiProcedure)procedure_;
        try {
            query.perform((AsyncReadGraph)queryGraph, new AsyncMultiProcedure<T>(){

                public void execute(AsyncReadGraph graph, T result) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.addOrSet(result);
                    try {
                        procedure.execute((AsyncReadGraph)parentGraph, result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }

                public void finished(AsyncReadGraph graph) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.finish(parentGraph);
                    try {
                        procedure.finished((AsyncReadGraph)parentGraph);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }

                public void exception(AsyncReadGraph graph, Throwable t) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.except(parentGraph, t);
                    try {
                        procedure.exception((AsyncReadGraph)parentGraph, t);
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
            });
            return entry.getResult();
        }
        catch (Throwable t) {
            entry.except(t);
            try {
                procedure.exception((AsyncReadGraph)parentGraph, t);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            return entry.getResult();
        }
    }

    public <T> Object performQuery(final ReadGraphImpl parentGraph, MultiRead<T> query, CacheEntryBase entry_, Object procedure_) throws DatabaseException {
        ReadGraphImpl queryGraph = parentGraph.withParent(entry_, null, true);
        final MultiReadEntry entry = (MultiReadEntry)entry_;
        final SyncMultiProcedure procedure = (SyncMultiProcedure)procedure_;
        try {
            query.perform((ReadGraph)queryGraph, new SyncMultiProcedure<T>(){

                public void execute(ReadGraph graph, T result) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.addOrSet(result);
                    try {
                        procedure.execute((ReadGraph)parentGraph, result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }

                public void finished(ReadGraph graph) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.finish((ReadGraph)parentGraph);
                    try {
                        procedure.finished((ReadGraph)parentGraph);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }

                public void exception(ReadGraph graph, Throwable t) {
                    ReadGraphImpl cfr_ignored_0 = (ReadGraphImpl)graph;
                    entry.except((DatabaseException)t);
                    try {
                        procedure.exception((ReadGraph)parentGraph, t);
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                    }
                }
            });
            return entry.getResult();
        }
        catch (Throwable t) {
            entry.except(t);
            try {
                procedure.exception((ReadGraph)parentGraph, t);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            return entry.getResult();
        }
    }

    public Collection<CacheEntry> getRootList() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        for (CacheEntry cacheEntry : this.valueQueryMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry cacheEntry : this.directPredicatesMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry cacheEntry : this.directSuperRelationsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.objectsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.directObjectsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.principalTypesMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.superRelationsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.superTypesMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.typesMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.objectsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.assertedStatementsMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.readEntryMap.values()) {
            if (cacheEntry instanceof CacheEntry) {
                result.add(cacheEntry);
                continue;
            }
            System.err.println("e=" + cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.asyncReadEntryMap.values()) {
            if (cacheEntry instanceof CacheEntry) {
                result.add(cacheEntry);
                continue;
            }
            System.err.println("e=" + cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.externalReadEntryMap.values()) {
            result.add(cacheEntry);
        }
        for (CacheEntry<Object> cacheEntry : this.orderedSetMap.values()) {
            result.add(cacheEntry);
        }
        return result;
    }

    public int calculateCurrentSize() {
        int realSize = 0;
        realSize += this.directPredicatesMap.size();
        realSize += this.directSuperRelationsMap.size();
        realSize += this.principalTypesMap.size();
        realSize += this.uRIToResourceMap.size();
        realSize += this.childMapMap.size();
        realSize += this.relationInfoQueryMap.size();
        realSize += this.superTypesMap.size();
        realSize += this.typeHierarchyMap.size();
        realSize += this.superRelationsMap.size();
        realSize += this.typesMap.size();
        realSize += this.valueQueryMap.size();
        realSize += this.directObjectsMap.size();
        realSize += this.objectsMap.size();
        realSize += this.orderedSetMap.size();
        realSize += this.predicatesMap.size();
        realSize += this.statementsMap.size();
        realSize += this.assertedPredicatesMap.size();
        realSize += this.assertedStatementsMap.size();
        realSize += this.externalReadEntryMap.size();
        realSize += this.asyncReadEntryMap.size();
        realSize += this.readEntryMap.size();
        realSize += this.asyncMultiReadEntryMap.size();
        return realSize += this.multiReadEntryMap.size();
    }

    CacheCollectionResult allCaches(CacheCollectionResult result) {
        short s = Integer.MAX_VALUE;
        this.directPredicatesMap.values(s, result);
        this.directSuperRelationsMap.values(s, result);
        this.principalTypesMap.values(s, result);
        for (CacheEntryBase e : this.uRIToResourceMap.values()) {
            if (e.getLevel() > s) continue;
            result.add(e);
        }
        this.childMapMap.values(s, result);
        this.relationInfoQueryMap.values(s, result);
        this.superTypesMap.values(s, result);
        this.typeHierarchyMap.values(s, result);
        this.superRelationsMap.values(s, result);
        this.typesMap.values(s, result);
        this.valueQueryMap.values(s, result);
        this.directObjectsMap.values(s, result);
        this.objectsMap.values(s, result);
        this.orderedSetMap.values(s, result);
        this.predicatesMap.values(s, result);
        this.statementsMap.values(s, result);
        this.assertedPredicatesMap.values(s, result);
        this.assertedStatementsMap.values(s, result);
        this.externalReadEntryMap.values(s, result);
        this.asyncReadEntryMap.values(s, result);
        this.readEntryMap.values(s, result);
        this.asyncMultiReadEntryMap.values(s, result);
        this.multiReadEntryMap.values(s, result);
        return result;
    }

    public void scanPending() {
        ArrayList<CacheEntry<Object>> entries = new ArrayList<CacheEntry<Object>>();
        entries.addAll(this.directPredicatesMap.values());
        entries.addAll(this.directSuperRelationsMap.values());
        entries.addAll(this.principalTypesMap.values());
        entries.addAll(this.uRIToResourceMap.values());
        entries.addAll(this.childMapMap.values());
        entries.addAll(this.relationInfoQueryMap.values());
        entries.addAll(this.superTypesMap.values());
        entries.addAll(this.superRelationsMap.values());
        entries.addAll(this.typesMap.values());
        entries.addAll(this.valueQueryMap.values());
        entries.addAll(this.directObjectsMap.values());
        entries.addAll(this.objectsMap.values());
        entries.addAll(this.orderedSetMap.values());
        entries.addAll(this.predicatesMap.values());
        entries.addAll(this.orderedSetMap.values());
        entries.addAll(this.statementsMap.values());
        entries.addAll(this.assertedPredicatesMap.values());
        entries.addAll(this.assertedStatementsMap.values());
        entries.addAll(this.externalReadEntryMap.values());
        entries.addAll(this.asyncReadEntryMap.values());
        entries.addAll(this.externalReadEntryMap.values());
        entries.addAll(this.readEntryMap.values());
        entries.addAll(this.asyncMultiReadEntryMap.values());
        entries.addAll(this.multiReadEntryMap.values());
        entries.addAll(this.readEntryMap.values());
        System.out.println(String.valueOf(entries.size()) + " entries.");
        for (Object e : entries) {
            if (!(e instanceof CacheEntry)) continue;
            CacheEntry en = (CacheEntry)e;
            if (en.isPending()) {
                System.out.println("pending " + e);
            }
            if (en.isExcepted()) {
                System.out.println("excepted " + e);
            }
            if (en.isDiscarded()) {
                System.out.println("discarded " + e);
            }
            if (en.isRefuted()) {
                System.out.println("refuted " + e);
            }
            if (!en.isFresh()) continue;
            System.out.println("fresh " + e);
        }
    }

    public static void waitPending(ReadGraphImpl graph, CacheEntry entry) throws DatabaseException {
        int counter = 0;
        while (entry.isPending()) {
            try {
                boolean performed = false;
                if (performed) continue;
                Thread.sleep(1L);
                if (++counter <= 30000) continue;
                CacheEntryBase cfr_ignored_0 = (CacheEntryBase)entry;
                new Exception("Timeout waiting for request to complete: " + entry.getOriginalRequest()).printStackTrace();
                throw new DatabaseException("Timeout waiting for request to complete." + entry.getOriginalRequest());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Objects> entriesObjects(QueryProcessor processor, int r1) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = processor.cache.objectsMap;
        synchronized (doubleKeyQueryHashMap) {
            return processor.cache.objectsMap.values(r1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Objects> entriesObjects(QueryProcessor processor) {
        DoubleKeyQueryHashMap doubleKeyQueryHashMap = processor.cache.objectsMap;
        synchronized (doubleKeyQueryHashMap) {
            return processor.cache.objectsMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<CacheEntry> entriesDirectPredicates(QueryProcessor processor) {
        UnaryQueryHashMap unaryQueryHashMap = processor.cache.directPredicatesMap;
        synchronized (unaryQueryHashMap) {
            return processor.cache.directPredicatesMap.values();
        }
    }

    static final Collection<DirectObjects> entriesDirectObjects(QueryProcessor processor, int r1) {
        DoubleKeyQueryHashMap hash = processor.cache.directObjectsMap;
        return hash.values(r1);
    }

    static final Collection<Statements> entriesStatements(QueryProcessor processor, int r1) {
        return processor.cache.statementsMap.values(r1);
    }

    static final Types entryTypes(QueryProcessor processor, int r) {
        return (Types)processor.cache.typesMap.get(r);
    }

    static final PrincipalTypes entryPrincipalTypes(QueryProcessor processor, int r) {
        return (PrincipalTypes)processor.cache.principalTypesMap.get(r);
    }

    static final OrderedSet entryOrderedSet(QueryProcessor processor, int r) {
        return (OrderedSet)processor.cache.orderedSetMap.get(r);
    }

    static final ValueQuery entryValueQuery(QueryProcessor processor, int r) {
        return (ValueQuery)processor.cache.valueQueryMap.get(r);
    }

    static final DirectPredicates entryDirectPredicates(QueryProcessor processor, int r) {
        return (DirectPredicates)processor.cache.directPredicatesMap.get(r);
    }

    public static final ReadEntry entryRead(QueryProcessor processor, Read request) {
        return (ReadEntry)processor.cache.readEntryMap.get(request);
    }

    public static final MultiReadEntry entryMultiRead(QueryProcessor processor, MultiRead request) {
        return (MultiReadEntry)processor.cache.multiReadEntryMap.get(request);
    }

    public static final AsyncReadEntry entryAsyncRead(QueryProcessor processor, AsyncRead request) {
        return (AsyncReadEntry)processor.cache.asyncReadEntryMap.get(request);
    }

    public static final AsyncMultiReadEntry entryAsyncMultiRead(QueryProcessor processor, AsyncMultiRead request) {
        return (AsyncMultiReadEntry)processor.cache.asyncMultiReadEntryMap.get(request);
    }

    protected static final long keyR2(long r1, long r2) {
        long result = r1 << 32 | r2 & 0xFFFFFFFFL;
        return result;
    }

    protected static final <T> T id(T o) {
        return o;
    }

    protected static final int keyR(int r) {
        return r;
    }

    protected static final String keyID(String id) {
        return id;
    }

    public static <T> T resultExternalReadEntry(ReadGraphImpl graph, ExternalRead r, CacheEntry parent, ListenerBase listener, Procedure<T> procedure) throws DatabaseException {
        ExternalProcedureWrapper<T> wrap = new ExternalProcedureWrapper<T>(procedure);
        QueryCache.runnerExternalReadEntry(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static <T> T resultAsyncReadEntry(ReadGraphImpl graph, AsyncRead r, CacheEntry parent, ListenerBase listener, AsyncProcedure<T> procedure) throws DatabaseException {
        return (T)QueryCache.runnerAsyncReadEntry(graph, r, parent, listener, procedure, true);
    }

    public static byte[] resultValueQuery(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<byte[]> wrap = new InternalProcedureWrapper<byte[]>(null);
        QueryCache.runnerValueQuery(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static RelationInfo resultRelationInfoQuery(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<RelationInfo> wrap = new InternalProcedureWrapper<RelationInfo>(null);
        QueryCache.runnerRelationInfoQuery(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntSet resultSuperRelations(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<IntSet> wrap = new InternalProcedureWrapper<IntSet>(null);
        QueryCache.runnerSuperRelations(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntSet resultSuperTypes(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<IntSet> wrap = new InternalProcedureWrapper<IntSet>(null);
        QueryCache.runnerSuperTypes(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntSet resultTypes(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<IntSet> wrap = new InternalProcedureWrapper<IntSet>(null);
        QueryCache.runnerTypes(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntSet resultPredicates(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<IntSet> wrap = new InternalProcedureWrapper<IntSet>(null);
        QueryCache.runnerPredicates(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntSet resultDirectPredicates(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<IntSet> wrap = new InternalProcedureWrapper<IntSet>(null);
        QueryCache.runnerDirectPredicates(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    public static IntArray resultAssertedStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        TripleIntProcedureWrapper wrap = new TripleIntProcedureWrapper(null);
        QueryCache.runnerAssertedStatements(graph, r1, r2, parent, listener, wrap);
        return wrap.get();
    }

    public static Integer resultURIToResource(ReadGraphImpl graph, String id, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<Integer> wrap = new InternalProcedureWrapper<Integer>(null);
        QueryCache.runnerURIToResource(graph, id, parent, listener, wrap);
        return wrap.get();
    }

    public static ObjectResourceIdMap<String> resultChildMap(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener) throws DatabaseException {
        InternalProcedureWrapper<ObjectResourceIdMap<String>> wrap = new InternalProcedureWrapper<ObjectResourceIdMap<String>>(null);
        QueryCache.runnerChildMap(graph, r, parent, listener, wrap);
        return wrap.get();
    }

    static boolean shouldCache(QueryProcessor processor, int r) {
        return processor.isImmutable(r);
    }

    static boolean shouldCache(QueryProcessor processor, int r, int r2) {
        return processor.isImmutable(r);
    }

    static boolean shouldCache(QueryProcessor processor, Object o) {
        return false;
    }

    AssertedPredicates getOrCreateAssertedPredicates(int r) {
        AssertedPredicates entry = (AssertedPredicates)this.assertedPredicatesMap.get(r);
        if (entry == null) {
            entry = new AssertedPredicates(r);
            this.assertedPredicatesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    AssertedStatements getOrCreateAssertedStatements(int r1, int r2) {
        AssertedStatements entry = (AssertedStatements)this.assertedStatementsMap.get(r1, r2);
        if (entry == null) {
            entry = new AssertedStatements(r1, r2);
            this.assertedStatementsMap.put(QueryCacheBase.keyR2(r1, r2), entry);
        }
        return entry;
    }

    ChildMap getOrCreateChildMap(int r) {
        ChildMap entry = (ChildMap)this.childMapMap.get(r);
        if (entry == null) {
            entry = new ChildMap(r);
            this.childMapMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    DirectObjects getOrCreateDirectObjects(int r1, int r2) {
        DirectObjects entry = (DirectObjects)this.directObjectsMap.get(r1, r2);
        if (entry == null) {
            entry = new DirectObjects(r1, r2);
            this.directObjectsMap.put(QueryCacheBase.keyR2(r1, r2), entry);
        }
        return entry;
    }

    DirectPredicates getOrCreateDirectPredicates(int r) {
        DirectPredicates entry = (DirectPredicates)this.directPredicatesMap.get(r);
        if (entry == null) {
            entry = new DirectPredicates(r);
            this.directPredicatesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    Objects getOrCreateObjects(int r1, int r2) {
        Objects entry = (Objects)this.objectsMap.get(r1, r2);
        if (entry == null) {
            entry = new Objects(r1, r2);
            this.objectsMap.put(QueryCacheBase.keyR2(r1, r2), entry);
        }
        return entry;
    }

    OrderedSet getOrCreateOrderedSet(int r) {
        OrderedSet entry = (OrderedSet)this.orderedSetMap.get(r);
        if (entry == null) {
            entry = new OrderedSet(r);
            this.orderedSetMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    Predicates getOrCreatePredicates(int r) {
        Predicates entry = (Predicates)this.predicatesMap.get(r);
        if (entry == null) {
            entry = new Predicates(r);
            this.predicatesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    PrincipalTypes getOrCreatePrincipalTypes(int r) {
        PrincipalTypes entry = (PrincipalTypes)this.principalTypesMap.get(r);
        if (entry == null) {
            entry = new PrincipalTypes(r);
            this.principalTypesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    RelationInfoQuery getOrCreateRelationInfoQuery(int r) {
        RelationInfoQuery entry = (RelationInfoQuery)this.relationInfoQueryMap.get(r);
        if (entry == null) {
            entry = new RelationInfoQuery(r);
            this.relationInfoQueryMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    Statements getOrCreateStatements(int r1, int r2) {
        Statements entry = (Statements)this.statementsMap.get(r1, r2);
        if (entry == null) {
            entry = new Statements(r1, r2);
            this.statementsMap.put(QueryCacheBase.keyR2(r1, r2), entry);
        }
        return entry;
    }

    SuperRelations getOrCreateSuperRelations(int r) {
        SuperRelations entry = (SuperRelations)this.superRelationsMap.get(r);
        if (entry == null) {
            entry = new SuperRelations(r);
            this.superRelationsMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    SuperTypes getOrCreateSuperTypes(int r) {
        SuperTypes entry = (SuperTypes)this.superTypesMap.get(r);
        if (entry == null) {
            entry = new SuperTypes(r);
            this.superTypesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    TypeHierarchy getOrCreateTypeHierarchy(int r) {
        TypeHierarchy entry = (TypeHierarchy)this.typeHierarchyMap.get(r);
        if (entry == null) {
            entry = new TypeHierarchy(r);
            this.typeHierarchyMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    Types getOrCreateTypes(int r) {
        Types entry = (Types)this.typesMap.get(r);
        if (entry == null) {
            entry = new Types(r);
            this.typesMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    URIToResource getOrCreateURIToResource(String s) {
        URIToResource entry = (URIToResource)this.uRIToResourceMap.get((Object)s);
        if (entry == null) {
            entry = new URIToResource(s);
            this.uRIToResourceMap.put((Object)QueryCacheBase.keyID(s), (Object)entry);
        }
        return entry;
    }

    ValueQuery getOrCreateValueQuery(int r) {
        ValueQuery entry = (ValueQuery)this.valueQueryMap.get(r);
        if (entry == null) {
            entry = new ValueQuery(r);
            this.valueQueryMap.put(QueryCacheBase.keyR(r), entry);
        }
        return entry;
    }

    static class AsyncProcedureWrapper<T>
    implements AsyncProcedure<T> {
        private AsyncProcedure<T> procedure;
        private T result = null;
        private Throwable throwable = null;
        private Semaphore s = new Semaphore(0);

        AsyncProcedureWrapper(AsyncProcedure<T> procedure) {
            this.procedure = procedure;
        }

        public void execute(AsyncReadGraph graph, T result) {
            if (this.procedure != null) {
                this.procedure.execute(graph, result);
            }
            this.result = result;
            this.s.release();
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            if (this.procedure != null) {
                this.procedure.exception(graph, throwable);
            }
            this.throwable = throwable;
            this.s.release();
        }

        public T get() throws DatabaseException {
            try {
                this.s.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException(this.throwable);
            }
            return this.result;
        }
    }

    static class ExternalProcedureWrapper<T>
    implements AsyncProcedure<T> {
        private Procedure<T> procedure;
        private T result = null;
        private Throwable throwable = null;

        ExternalProcedureWrapper(Procedure<T> procedure) {
            this.procedure = procedure;
        }

        public void execute(AsyncReadGraph graph, T result) {
            if (this.procedure != null) {
                this.procedure.execute(result);
            }
            this.result = result;
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            if (this.procedure != null) {
                this.procedure.exception(throwable);
            }
            this.throwable = throwable;
        }

        public T get() throws DatabaseException {
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException(this.throwable);
            }
            return this.result;
        }
    }

    static class IntSetWrapper
    implements IntProcedure {
        private IntProcedure procedure;
        private final IntSet result;
        private Throwable throwable = null;

        IntSetWrapper(ReadGraphImpl graph, IntProcedure procedure) {
            this.procedure = procedure;
            this.result = new IntSet(graph.processor.querySupport);
        }

        @Override
        public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.execute(graph, i);
            }
            this.result.add(i);
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.exception(graph, throwable);
            }
            this.throwable = throwable;
        }

        @Override
        public void finished(ReadGraphImpl graph) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.finished(graph);
            }
        }

        public IntSet get() throws DatabaseException {
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException(this.throwable);
            }
            return this.result;
        }
    }

    static class InternalProcedureWrapper<T>
    implements InternalProcedure<T> {
        private InternalProcedure<T> procedure;
        private T result = null;
        private Throwable throwable = null;

        InternalProcedureWrapper(InternalProcedure<T> procedure) {
            this.procedure = procedure;
        }

        @Override
        public void execute(ReadGraphImpl graph, T result) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.execute(graph, result);
            }
            this.result = result;
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.exception(graph, throwable);
            }
            this.throwable = throwable;
        }

        public T get() throws DatabaseException {
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException(this.throwable);
            }
            return this.result;
        }
    }

    static class TripleIntProcedureWrapper
    implements TripleIntProcedure {
        private TripleIntProcedure procedure;
        private IntArray result = new IntArray();
        private Throwable throwable = null;

        TripleIntProcedureWrapper(TripleIntProcedure procedure) {
            this.procedure = procedure;
        }

        @Override
        public void execute(ReadGraphImpl graph, int i1, int i2, int i3) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.execute(graph, i1, i2, i3);
            }
            this.result.add(i1);
            this.result.add(i2);
            this.result.add(i3);
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.exception(graph, throwable);
            }
            this.throwable = throwable;
        }

        @Override
        public void finished(ReadGraphImpl graph) throws DatabaseException {
            if (this.procedure != null) {
                this.procedure.finished(graph);
            }
        }

        public IntArray get() throws DatabaseException {
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException(this.throwable);
            }
            return this.result;
        }
    }
}

