/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.Preference;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.utils.datastructures.collections.CollectionUtils;

public abstract class AbstractFactoryResolverQueryProcessor<Factory>
extends AbstractNodeQueryProcessor<Collection<Factory>> {
    private final EvaluatorData data;
    private final NodeContext.QueryKey<Collection<Factory>> identifier;

    public AbstractFactoryResolverQueryProcessor(EvaluatorData data, NodeContext.QueryKey<Collection<Factory>> identifier) {
        this.data = data;
        this.identifier = identifier;
    }

    public NodeContext.QueryKey<Collection<Factory>> getIdentifier() {
        return this.identifier;
    }

    public Collection<Factory> query(NodeQueryManager manager, NodeContext context) {
        assert (context != null);
        Object input = context.getConstant(BuiltinKeys.INPUT);
        assert (input != null);
        Collection<EvaluatorData.Evaluator> evals = this.data.get(input);
        if (evals.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Preference<Factory>> factories = new ArrayList<Preference<Factory>>(4);
        for (EvaluatorData.Evaluator eval : evals) {
            this.evaluateTree(manager, context, this.getEvaluatorTree(eval), factories);
        }
        if (factories.isEmpty()) {
            return Collections.emptyList();
        }
        if (factories.size() > 1) {
            Collections.sort(factories);
        }
        ArrayList result = new ArrayList(factories.size());
        for (Preference<Factory> p : factories) {
            result.add(p.object);
        }
        return result;
    }

    protected void evaluateTree(NodeQueryManager manager, NodeContext context, EvaluatorData.EvaluatorTree<Factory> tree, Collection<Preference<Factory>> result) {
        Tester test = tree.getTester();
        if (test.test(manager, context)) {
            CollectionUtils.checkedAdd(tree.getAcceptedFactories(), result);
            Collection<EvaluatorData.EvaluatorTree<Factory>> children = tree.getChildren();
            if (children == null) {
                return;
            }
            for (EvaluatorData.EvaluatorTree<Factory> e : children) {
                this.evaluateTree(manager, context, e, result);
            }
        }
    }

    protected abstract EvaluatorData.EvaluatorTree<Factory> getEvaluatorTree(EvaluatorData.Evaluator var1);
}

