/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.layer0.utils.triggers.Trigger;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.flags.LiftFlag;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ObjectUtils;

public class ComponentTypeUpdater
extends Trigger {
    private static final boolean DEBUG = false;
    protected Layer0 L0;
    protected Layer0X L0X;
    protected DiagramResource DIA;
    protected ModelingResources MOD;
    protected StructuralResource2 STR;
    protected Session session;
    private Resource configurationDiagram;
    private Resource configuration;
    private Resource componentType;

    public ComponentTypeUpdater(ReadGraph g, Resource mapping) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)g);
        this.L0X = Layer0X.getInstance((ReadGraph)g);
        this.DIA = DiagramResource.getInstance((ReadGraph)g);
        this.MOD = ModelingResources.getInstance((ReadGraph)g);
        this.STR = StructuralResource2.getInstance((ReadGraph)g);
        this.session = g.getSession();
        this.configurationDiagram = g.getPossibleObject(mapping, g.getInverse(this.L0X.HasTrigger));
        if (this.configurationDiagram != null) {
            this.configuration = g.getPossibleObject(this.configurationDiagram, this.MOD.DiagramToComposite);
            if (this.configuration != null) {
                this.componentType = g.getPossibleObject(this.configuration, this.STR.Defines);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComponentTypeUpdater)) {
            return false;
        }
        ComponentTypeUpdater map = (ComponentTypeUpdater)((Object)other);
        return ObjectUtils.objectEquals((Object)map.configurationDiagram, (Object)this.configurationDiagram) && ObjectUtils.objectEquals((Object)map.configuration, (Object)this.configuration) && ObjectUtils.objectEquals((Object)map.componentType, (Object)this.componentType);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.configurationDiagram) + 31 * (ObjectUtils.hashCode((Object)this.configuration) + 31 * ObjectUtils.hashCode((Object)this.componentType));
    }

    public IModification perform(ReadGraph graph) throws DatabaseException {
        if (this.componentType == null || this.configuration == null || this.configurationDiagram == null) {
            return null;
        }
        return null;
    }

    public class LiftedConnectionPointFixer
    implements IModification {
        private Resource componentType;

        public LiftedConnectionPointFixer(Resource componentType) {
            this.componentType = componentType;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            for (Resource connectionPoint : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.componentType, ComponentTypeUpdater.this.L0.DomainOf, ComponentTypeUpdater.this.STR.ConnectionRelation))) {
                for (Resource flag : graph.getObjects(connectionPoint, ComponentTypeUpdater.this.DIA.Lifts)) {
                    LiftFlag.LiftedConnectionPoint lcp = LiftFlag.calculateLiftedConnectionPointForFlag((ReadGraph)graph, flag);
                    String error = LiftFlag.isConnectionPointValid((ReadGraph)graph, this.componentType, connectionPoint, lcp);
                    if (error == null || (error = LiftFlag.validateConnectionPoint(graph, this.componentType, connectionPoint, lcp)) == null) continue;
                    System.out.println(String.valueOf(this.getClass().getSimpleName()) + " error: " + error);
                }
            }
        }
    }
}

