/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;
import org.simantics.basicexpression.Expressions;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ComponentTypeSubstructure;
import org.simantics.modeling.InvertBasicExpressionVisitorBase;
import org.simantics.modeling.ProceduralSubstructureMapRequest;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.Triple;

public class InvertBasicExpressionVisitor
extends InvertBasicExpressionVisitorBase {
    private static final String MAGIC = "_111_";

    private static String replaced(String expression) {
        return expression.replaceAll("\\.([A-Za-z])", "_111_$1");
    }

    public static void invert(WriteGraph graph, Variable base, String expression, Object value) throws DatabaseException {
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object result = visitor.getResult();
        if (result == null) {
            return;
        }
        if (result instanceof Triple) {
            Triple data = (Triple)result;
            String key = ((String)data.third).replace(MAGIC, ".");
            String path = InvertBasicExpressionVisitor.getVariablePath((ReadGraph)graph, base, key);
            Variable targetVariable = base.browse((ReadGraph)graph, path);
            if (value instanceof Number) {
                if (Math.abs((Double)data.first) > 1.0E-9) {
                    double inverted = (((Number)value).doubleValue() - (Double)data.second) / (Double)data.first;
                    Object invertedValue = InvertBasicExpressionVisitor.numericValueInType(inverted, value.getClass());
                    targetVariable.setValue(graph, invertedValue);
                }
            } else if (value instanceof Boolean) {
                targetVariable.setValue(graph, value);
            }
        }
    }

    private static Object numericValueInType(double value, Class<?> type) {
        if (type == Integer.class) {
            return (int)value;
        }
        if (type == Long.class) {
            return (long)value;
        }
        if (type == Byte.class) {
            return (byte)value;
        }
        if (type == Float.class) {
            return Float.valueOf((float)value);
        }
        return value;
    }

    private static String getVariablePath(ReadGraph graph, Variable base, String key) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource type = base.getPossibleType(graph);
        if (type == null) {
            return null;
        }
        boolean procedural = graph.isInstanceOf(type, STR.ProceduralComponentType);
        Pair pair = procedural ? (Pair)((THashMap)graph.sync((ReadInterface)new ProceduralSubstructureMapRequest(base))).get((Object)key) : ComponentTypeSubstructure.forType((RequestProcessor)graph, type).possibleTypedRVI(key);
        if (pair == null) {
            return null;
        }
        return (String)pair.first;
    }

    public static boolean isInvertible(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        if (expression == null) {
            throw new NullPointerException("null expression for variable " + base.getURI(graph));
        }
        if (expression.isEmpty()) {
            return false;
        }
        Resource type = base.getPossibleType(graph);
        if (type == null) {
            return false;
        }
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object pair = visitor.getResult();
        if (pair == null) {
            return false;
        }
        if (pair instanceof Triple) {
            Triple data = (Triple)pair;
            String key = ((String)data.third).replace(MAGIC, ".");
            return InvertBasicExpressionVisitor.getVariablePath(graph, base, key) != null;
        }
        return false;
    }

    private static Triple<Double, Double, String> possibleInvertibleExpression(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        if (base == null || expression == null || expression.isEmpty()) {
            return null;
        }
        InvertBasicExpressionVisitor visitor = new InvertBasicExpressionVisitor();
        Expressions.evaluate((String)InvertBasicExpressionVisitor.replaced(expression), (DepthFirstAdapter)visitor);
        Object result = visitor.getResult();
        if (result instanceof Triple) {
            return (Triple)result;
        }
        return null;
    }

    public static Variable possibleInvertibleExpressionReferencedProperty(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        Triple<Double, Double, String> data = InvertBasicExpressionVisitor.possibleInvertibleExpression(graph, base, expression);
        if (data == null) {
            return null;
        }
        String path = InvertBasicExpressionVisitor.getVariablePath(graph, base, ((String)data.third).replace(MAGIC, "."));
        return path != null ? base.browsePossible(graph, path) : null;
    }

    public static Triple<Double, Double, Variable> possibleInvertibleExpressionReferencedTransformedProperty(ReadGraph graph, Variable base, String expression) throws DatabaseException {
        Triple<Double, Double, String> data = InvertBasicExpressionVisitor.possibleInvertibleExpression(graph, base, expression);
        if (data == null) {
            return null;
        }
        String path = InvertBasicExpressionVisitor.getVariablePath(graph, base, ((String)data.third).replace(MAGIC, "."));
        if (path == null) {
            return null;
        }
        Variable targetVariable = base.browsePossible(graph, path);
        return targetVariable != null ? Triple.make((Object)((Double)data.first), (Object)((Double)data.second), (Object)targetVariable) : null;
    }
}

