/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import org.simantics.scenegraph.g2d.events.Event;

public abstract class KeyEvent
extends Event {
    private static final long serialVersionUID = 2802306097538088526L;
    public final char character;
    public final int keyCode;
    public final int stateMask;

    public KeyEvent(Object context, long time, char character, int keyCode, int stateMask) {
        super(context, time);
        this.character = character;
        this.keyCode = keyCode;
        this.stateMask = stateMask;
    }

    public boolean hasAnyModifier(int mask) {
        return (this.stateMask & mask) != 0;
    }

    public boolean hasAllModifiers(int mask) {
        return (this.stateMask & mask) == mask;
    }

    public boolean isShiftDown() {
        return (this.stateMask & 0x40) != 0;
    }

    public boolean isControlDown() {
        return (this.stateMask & 0x80) != 0;
    }

    public boolean isAltDown() {
        return (this.stateMask & 0x200) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.stateMask & 0x2000) != 0;
    }

    public static class KeyPressedEvent
    extends KeyEvent {
        private static final long serialVersionUID = -648528900110788474L;

        public KeyPressedEvent(Object context, long time, char character, int keyCode, int stateMask) {
            super(context, time, character, keyCode, stateMask);
        }

        @Override
        public String toString() {
            return "Key press: character='" + this.character + "', keyCode='" + this.keyCode + "', stateMask='" + this.stateMask + "'";
        }
    }

    public static class KeyReleasedEvent
    extends KeyEvent {
        private static final long serialVersionUID = -5434711507289906052L;

        public KeyReleasedEvent(Object context, long time, char character, int keyCode, int stateMask) {
            super(context, time, character, keyCode, stateMask);
        }

        @Override
        public String toString() {
            return "Key release: character='" + this.character + "', keyCode='" + this.keyCode + "', stateMask='" + this.stateMask + "'";
        }
    }
}

