/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.TypeString;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class SuperTypeString
extends BinaryRead<Resource, String, String> {
    public SuperTypeString(Resource type) {
        super(type, " ");
    }

    public SuperTypeString(Resource type, String separator) {
        super(type, separator);
        if (separator == null) {
            throw new NullPointerException("null separator");
        }
    }

    public String perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Set supers = graph.getSupertypes((Resource)this.parameter);
        StringBuilder b = new StringBuilder();
        String name = (String)graph.getPossibleRelatedValue((Resource)this.parameter, L0.HasName, (Binding)Bindings.STRING);
        if (name != null) {
            b.append(TypeString.escapeToken(name));
            for (Resource r : supers) {
                name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                if (name != null) {
                    b.append((String)this.parameter2);
                    b.append(TypeString.escapeToken(name));
                    continue;
                }
                Logger.defaultLogError(new DatabaseException("No name for type " + r));
            }
        } else {
            Logger.defaultLogError(new DatabaseException("No name for type " + this.parameter));
        }
        return b.toString();
    }
}

