/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.FocusableTooltipProvider;

public abstract class EditableTextTooltipProvider
implements FocusableTooltipProvider {
    private Frame frame;
    private TextField field;

    @Override
    public void showTooltip(final IElement element, int x, int y) {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
        this.frame = new Frame(this.getTooltipText(element));
        this.frame.setFocusableWindowState(false);
        this.frame.setUndecorated(true);
        this.frame.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                System.out.println("Lost " + arg0);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                System.out.println("Lost " + arg0);
            }
        });
        Label label = new Label("Press 'F9' to focus");
        this.field = new TextField(this.getTooltipText(element));
        this.field.setFocusable(false);
        this.field.setEditable(false);
        this.field.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    EditableTextTooltipProvider.this.setText(element, EditableTextTooltipProvider.this.field.getText());
                    EditableTextTooltipProvider.this.frame.setVisible(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.frame.setLayout(new BoxLayout(this.frame, 1));
        this.frame.add(label);
        this.frame.add(this.field);
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.setLocation(x, y - 32);
    }

    @Override
    public void hideTooltip(IElement element) {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void focus() {
        this.frame.setFocusableWindowState(true);
        this.frame.setFocusable(true);
        this.field.setFocusable(true);
        this.field.setEditable(true);
        this.frame.requestFocus();
        this.frame.requestFocusInWindow();
        System.out.println(String.valueOf(this.field.isFocusOwner()) + " " + this.frame.isFocused());
    }

    @Override
    public boolean hasFocus() {
        return this.field.isFocusOwner();
    }

    public abstract String getTooltipText(IElement var1);

    public abstract void setText(IElement var1, String var2);
}

