/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.Color;
import java.awt.Paint;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.BackgroundNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class BackgroundPainter
extends AbstractCanvasParticipant {
    protected BackgroundNode node = null;

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_BACKGROUND_COLOR")
    public void colorChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (this.node != null) {
            Color c = (Color)this.getHint(Hints.KEY_BACKGROUND_COLOR);
            this.node.setColor(c);
            this.setDirty();
        }
    }

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_BACKGROUND_PAINT")
    public void paintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (this.node != null) {
            Paint p = (Paint)this.getHint(Hints.KEY_BACKGROUND_PAINT);
            this.node.setPaint(p);
            this.setDirty();
        }
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        this.node = (BackgroundNode)parent.addNode("background", BackgroundNode.class);
        this.node.setZIndex(-1073741824);
        Color c = (Color)this.getHint(Hints.KEY_BACKGROUND_COLOR);
        Paint p = (Paint)this.getHint(Hints.KEY_BACKGROUND_PAINT);
        this.node.setColor(c);
        this.node.setPaint(p);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
    }
}

