/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.internal.DebugPolicy;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.ThreadUtils;

public class DelayedBatchElementPainter
extends AbstractDiagramParticipant {
    private static final boolean DEBUG = DebugPolicy.DEBUG_DELAYED_ELEMENT_PAINTER;
    private static final boolean DEBUG_MARKING = DebugPolicy.DEBUG_DELAYED_ELEMENT_PAINTER_MARKING;
    ScheduledExecutorService executor = ThreadUtils.getNonBlockingWorkExecutor();
    PickRequest.PickFilter elementFilter;
    long delay;
    TimeUnit delayUnit;
    Set<IElement> dirtyElements = new HashSet<IElement>();
    volatile ScheduledFuture<?> scheduled = null;
    long lastUpdateTime = 0L;
    private final ElementListener elementListener = new ElementListener();
    private Runnable updater = new Runnable(){

        @Override
        public void run() {
            if (DEBUG) {
                DelayedBatchElementPainter.this.debug("marking %d elements dirty\n", DelayedBatchElementPainter.this.dirtyElements.size());
            }
            for (IElement e : DelayedBatchElementPainter.this.dirtyElements) {
                e.setHint(Hints.KEY_DIRTY, Hints.VALUE_SG_DIRTY);
            }
            DelayedBatchElementPainter.this.dirtyElements.clear();
            DelayedBatchElementPainter.this.scheduled = null;
            DelayedBatchElementPainter.this.lastUpdateTime = System.currentTimeMillis();
            if (DEBUG) {
                DelayedBatchElementPainter.this.debug("marking last update time %d\n", DelayedBatchElementPainter.this.lastUpdateTime);
            }
            if (!DelayedBatchElementPainter.this.isRemoved()) {
                DelayedBatchElementPainter.this.setDirty();
            }
        }
    };
    private Runnable delayedUpdater = new Runnable(){

        @Override
        public void run() {
            if (DEBUG) {
                DelayedBatchElementPainter.this.debug("scheduling updater\n", new Object[0]);
            }
            DelayedBatchElementPainter.this.asyncExec(DelayedBatchElementPainter.this.updater);
        }
    };

    public DelayedBatchElementPainter(PickRequest.PickFilter elementFilter, long delay, TimeUnit delayUnit) {
        this.elementFilter = elementFilter;
        this.delay = delay;
        this.delayUnit = delayUnit;
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        ScheduledFuture<?> s = this.scheduled;
        if (s != null) {
            s.cancel(false);
        }
        super.removedFromContext(ctx);
    }

    @Override
    protected void onDiagramSet(IDiagram newValue, IDiagram oldValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue != null) {
            for (IElement e : oldValue.getElements()) {
                if (!this.elementFilter.accept(e)) continue;
                this.removeElement(e);
            }
            oldValue.removeCompositionListener(this.elementListener);
        }
        if (newValue != null) {
            for (IElement e : newValue.getElements()) {
                if (!this.elementFilter.accept(e)) continue;
                this.addElement(e);
            }
            newValue.addCompositionListener(this.elementListener);
        }
    }

    protected void addElement(IElement e) {
        if (DEBUG) {
            this.debug("addElement(%s)\n", e);
        }
        e.addKeyHintListener(Hints.KEY_DIRTY, this.elementListener);
    }

    protected void removeElement(IElement e) {
        if (DEBUG) {
            this.debug("removeElement(%s)\n", e);
        }
        e.removeKeyHintListener(Hints.KEY_DIRTY, this.elementListener);
    }

    protected void markDirty(IElement e) {
        if (DEBUG_MARKING) {
            this.debug("Marking element dirty: %s\n", e);
        }
        this.dirtyElements.add(e);
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        if (this.scheduled == null) {
            long timeNow = System.currentTimeMillis();
            long timeSinceLastUpdate = timeNow - this.lastUpdateTime;
            long requestedDelay = this.delayUnit.toMillis(this.delay);
            long scheduleDelay = Math.max(0L, Math.min(requestedDelay, requestedDelay - timeSinceLastUpdate));
            if (DEBUG) {
                this.debug("scheduling update with delay %dms (time=%d, time passed=%dms)\n", scheduleDelay, timeNow, timeSinceLastUpdate);
            }
            if (scheduleDelay == 0L) {
                this.asyncExec(this.updater);
            } else {
                this.scheduled = this.executor.schedule(this.delayedUpdater, scheduleDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void debug(String format, Object ... args) {
        if (DEBUG) {
            System.out.format(String.valueOf(this.getClass().getSimpleName()) + "[filter=" + this.elementFilter + ", delay=" + this.delayUnit.toMillis(this.delay) + "ms] " + format, args);
        }
    }

    class ElementListener
    implements IDiagram.CompositionListener,
    IHintListener {
        ElementListener() {
        }

        @Override
        public void onElementAdded(IDiagram d, IElement e) {
            if (DEBUG) {
                DelayedBatchElementPainter.this.debug("onElementAdded(%s, %s)\n", d, e);
            }
            if (DelayedBatchElementPainter.this.elementFilter.accept(e)) {
                DelayedBatchElementPainter.this.addElement(e);
            }
        }

        @Override
        public void onElementRemoved(IDiagram d, IElement e) {
            if (DEBUG) {
                DelayedBatchElementPainter.this.debug("onElementRemoved(%s, %s)\n", d, e);
            }
            if (DelayedBatchElementPainter.this.elementFilter.accept(e)) {
                DelayedBatchElementPainter.this.removeElement(e);
            }
        }

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_DIRTY && newValue == Hints.VALUE_SG_DELAYED_UPDATE && sender instanceof IElement) {
                DelayedBatchElementPainter.this.markDirty((IElement)sender);
            }
        }

        public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        }
    }
}

