/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.simantics.diagram.connection.rendering.ConnectionStyle;

public class BasicConnectionStyle
implements ConnectionStyle,
Serializable {
    private static final long serialVersionUID = -5799681720482456895L;
    final Color lineColor;
    final Color branchPointColor;
    final double branchPointRadius;
    final Stroke lineStroke;
    final Stroke routeLineStroke;
    final double degenerateLineLength;
    final double rounding;
    final double offset;
    transient Line2D line = new Line2D.Double();
    transient Ellipse2D ellipse = new Ellipse2D.Double();

    public BasicConnectionStyle(Color lineColor, Color branchPointColor, double branchPointRadius, Stroke lineStroke, Stroke routeLineStroke, double degenerateLineLength, double rounding, double offset) {
        this.lineColor = lineColor;
        this.branchPointColor = branchPointColor;
        this.branchPointRadius = branchPointRadius;
        this.lineStroke = lineStroke;
        this.routeLineStroke = routeLineStroke;
        this.degenerateLineLength = degenerateLineLength;
        this.rounding = rounding;
        this.offset = offset;
    }

    public BasicConnectionStyle(Color lineColor, Color branchPointColor, double branchPointRadius, Stroke lineStroke, Stroke routeLineStroke, double degenerateLineLength, double rounding) {
        this(lineColor, branchPointColor, branchPointRadius, lineStroke, routeLineStroke, degenerateLineLength, rounding, 0.0);
    }

    public BasicConnectionStyle(Color lineColor, Color branchPointColor, double branchPointRadius, Stroke lineStroke, Stroke routeLineStroke, double degenerateLineLength) {
        this(lineColor, branchPointColor, branchPointRadius, lineStroke, routeLineStroke, degenerateLineLength, 0.0, 0.0);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getBranchPointColor() {
        return this.branchPointColor;
    }

    public double getBranchPointRadius() {
        return this.branchPointRadius;
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public Stroke getRouteLineStroke() {
        return this.routeLineStroke;
    }

    @Override
    public void drawLine(Graphics2D g, double x1, double y1, double x2, double y2, boolean isTransient) {
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
        }
        if (isTransient) {
            g.setStroke(this.lineStroke);
            this.line.setLine(x1, y1, x2, y2);
            g.draw(this.line);
        } else {
            g.setStroke(this.routeLineStroke);
            this.line.setLine(x1, y1, x2, y2);
            g.draw(this.line);
        }
    }

    @Override
    public void drawPath(Graphics2D g, Path2D path, boolean isTransient) {
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
        }
        if (this.lineStroke != null) {
            g.setStroke(this.lineStroke);
        }
        if (this.rounding > 0.0) {
            Object oldRenderingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            path = this.round(path);
            if (this.offset != 0.0) {
                path = BasicConnectionStyle.offsetPath(path, this.offset);
            }
            g.draw(path);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldRenderingHint);
        } else {
            if (this.offset != 0.0) {
                path = BasicConnectionStyle.offsetPath(path, this.offset);
            }
            g.draw(path);
        }
    }

    private static Point2D getNormal(Point2D dir) {
        return new Point2D.Double(-dir.getY(), dir.getX());
    }

    private static Point2D normalize(Point2D v) {
        double d = Math.sqrt(v.getX() * v.getX() + v.getY() * v.getY());
        v.setLocation(v.getX() / d, v.getY() / d);
        return v;
    }

    private static Path2D offsetPath(Path2D path, double offset) {
        Path2D.Double result = new Path2D.Double();
        FlatteningPathIterator iter = new FlatteningPathIterator(path.getPathIterator(null), 0.05, 10);
        double[] c = new double[6];
        double initialX = 0.0;
        double initialY = 0.0;
        boolean first = true;
        Point2D.Double prevDir = null;
        Point2D prevPos = null;
        while (!iter.isDone()) {
            int i = iter.currentSegment(c);
            switch (i) {
                case 0: {
                    if (first) {
                        initialX = c[0];
                        initialY = c[1];
                        first = false;
                    }
                    if (prevDir != null) {
                        Point2D N = BasicConnectionStyle.normalize(BasicConnectionStyle.getNormal(prevDir));
                        ((Path2D)result).lineTo(prevPos.getX() + N.getX() * offset, prevPos.getY() + N.getY() * offset);
                    }
                    prevPos = new Point2D.Double(c[0], c[1]);
                    prevDir = null;
                    break;
                }
                case 1: 
                case 4: {
                    Point2D.Double currentDir;
                    if (i == 4) {
                        c[0] = initialX;
                        c[1] = initialY;
                    }
                    if (((Point2D)(currentDir = new Point2D.Double(c[0] - prevPos.getX(), c[1] - prevPos.getY()))).getX() == 0.0 && ((Point2D)currentDir).getY() == 0.0) break;
                    if (prevDir == null) {
                        Point2D N = BasicConnectionStyle.normalize(BasicConnectionStyle.getNormal(currentDir));
                        ((Path2D)result).moveTo(prevPos.getX() + N.getX() * offset, prevPos.getY() + N.getY() * offset);
                        prevPos = new Point2D.Double(c[0], c[i]);
                        prevDir = currentDir;
                        break;
                    }
                    Point2D N1 = BasicConnectionStyle.normalize(BasicConnectionStyle.getNormal(prevDir));
                    Point2D N2 = BasicConnectionStyle.normalize(BasicConnectionStyle.getNormal(currentDir));
                    Point2D N = BasicConnectionStyle.normalize(new Point2D.Double(N1.getX() + N2.getX(), N1.getY() + N2.getY()));
                    double dot = N1.getX() * N.getX() + N1.getY() * N.getY();
                    if (!Double.isFinite(dot) || Math.abs(dot) < 0.1) {
                        ((Path2D)result).lineTo(prevPos.getX() + (N1.getX() + N1.getY()) * offset, prevPos.getY() + (N1.getY() - N1.getX()) * offset);
                        ((Path2D)result).lineTo(prevPos.getX() + (N2.getX() + N1.getY()) * offset, prevPos.getY() + (N2.getY() - N1.getX()) * offset);
                        prevPos = new Point2D.Double(c[0], c[i]);
                        prevDir = currentDir;
                        break;
                    }
                    double Nx = N.getX() * offset / dot;
                    double Ny = N.getY() * offset / dot;
                    ((Path2D)result).lineTo(prevPos.getX() + Nx, prevPos.getY() + Ny);
                    prevPos = new Point2D.Double(c[0], c[i]);
                    prevDir = currentDir;
                }
            }
            iter.next();
        }
        if (prevDir != null) {
            Point2D N = BasicConnectionStyle.normalize(BasicConnectionStyle.getNormal(prevDir));
            ((Path2D)result).lineTo(prevPos.getX() + N.getX() * offset, prevPos.getY() + N.getY() * offset);
        }
        return result;
    }

    private Path2D round(Path2D path) {
        Path2D.Double newPath = new Path2D.Double();
        PathIterator it = path.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        double newX = 0.0;
        double newY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double oldX = 0.0;
        double oldY = 0.0;
        int state = 0;
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            if (type == 1) {
                newX = coords[0];
                newY = coords[1];
                if (state == 1) {
                    double dx1 = curX - oldX;
                    double dy1 = curY - oldY;
                    double dx2 = curX - newX;
                    double dy2 = curY - newY;
                    double r1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                    double r2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                    double maxRadius = 0.5 * Math.min(r1, r2);
                    double radius = Math.min(this.rounding, maxRadius);
                    double dx1Normalized = r1 > 0.0 ? dx1 / r1 : 0.0;
                    double dy1Normalized = r1 > 0.0 ? dy1 / r1 : 0.0;
                    double dx2Normalized = r2 > 0.0 ? dx2 / r2 : 0.0;
                    double dy2Normalized = r2 > 0.0 ? dy2 / r2 : 0.0;
                    ((Path2D)newPath).lineTo(curX - radius * dx1Normalized, curY - radius * dy1Normalized);
                    ((Path2D)newPath).curveTo(curX, curY, curX, curY, curX - radius * dx2Normalized, curY - radius * dy2Normalized);
                } else {
                    ++state;
                }
                oldX = curX;
                oldY = curY;
                curX = newX;
                curY = newY;
            } else {
                if (state > 0) {
                    ((Path2D)newPath).lineTo(curX, curY);
                    state = 0;
                }
                switch (type) {
                    case 0: {
                        curX = coords[0];
                        curY = coords[1];
                        ((Path2D)newPath).moveTo(curX, curY);
                        break;
                    }
                    case 2: {
                        curX = coords[2];
                        curY = coords[3];
                        ((Path2D)newPath).quadTo(coords[0], coords[1], coords[2], coords[3]);
                        break;
                    }
                    case 3: {
                        curX = coords[4];
                        curY = coords[5];
                        ((Path2D)newPath).curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                        break;
                    }
                    case 4: {
                        newPath.closePath();
                    }
                }
            }
            it.next();
        }
        if (state > 0) {
            ((Path2D)newPath).lineTo(curX, curY);
        }
        return newPath;
    }

    @Override
    public void drawBranchPoint(Graphics2D g, double x, double y) {
        g.setColor(this.branchPointColor);
        double r = this.branchPointRadius;
        double d = 2.0 * r;
        this.ellipse.setFrame(x - r, y - r, d, d);
        g.fill(this.ellipse);
    }

    @Override
    public void drawDegeneratedLine(Graphics2D g, double x, double y, boolean isHorizontal, boolean isTransient) {
        double d = this.getDegeneratedLineLength() * 0.5;
        if (isHorizontal) {
            this.line.setLine(x - d, y, x + d, y);
            g.draw(this.line);
        } else {
            this.line.setLine(x, y - d, x, y + d);
            g.draw(this.line);
        }
    }

    @Override
    public double getDegeneratedLineLength() {
        return this.degenerateLineLength;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.branchPointColor == null ? 0 : this.branchPointColor.hashCode());
        long temp = Double.doubleToLongBits(this.branchPointRadius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.degenerateLineLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.lineColor == null ? 0 : this.lineColor.hashCode());
        result = 31 * result + (this.lineStroke == null ? 0 : this.lineStroke.hashCode());
        temp = Double.doubleToLongBits(this.rounding);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.routeLineStroke == null ? 0 : this.routeLineStroke.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicConnectionStyle other = (BasicConnectionStyle)obj;
        if (this.branchPointColor == null ? other.branchPointColor != null : !this.branchPointColor.equals(other.branchPointColor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.branchPointRadius) != Double.doubleToLongBits(other.branchPointRadius)) {
            return false;
        }
        if (Double.doubleToLongBits(this.degenerateLineLength) != Double.doubleToLongBits(other.degenerateLineLength)) {
            return false;
        }
        if (this.lineColor == null ? other.lineColor != null : !this.lineColor.equals(other.lineColor)) {
            return false;
        }
        if (this.lineStroke == null ? other.lineStroke != null : !this.lineStroke.equals(other.lineStroke)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rounding) != Double.doubleToLongBits(other.rounding)) {
            return false;
        }
        return !(this.routeLineStroke == null ? other.routeLineStroke != null : !this.routeLineStroke.equals(other.routeLineStroke));
    }

    public double getRounding() {
        return this.rounding;
    }

    public double getOffset() {
        return this.offset;
    }
}

