/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class Utils {
    public static final String SERVICE_CONTEXT = "/vs/service";
    public static final String RETURN_TYPE = "returnType";
    public static final String NO_CATEGORY = "noCategory";
    public static final String XML = "xml";
    public static final String JSON = "json";
    public static final String HTML = "html";
    public static final long AGENT = 1L;
    public static final long PREFERENCE = 2L;
    public static final long ABOUT_PLUGIN = 3L;

    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static void transferContent(InputStream inputStream, OutputStream out) throws IOException {
        try {
            BufferedInputStream dataStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = dataStream.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception exception) {}
    }

    public static String updateResponse(String response) {
        response = Utils.removeString(response, "advanced/synchWithToc.js");
        response = Utils.removeString(response, "index.jsp");
        return response;
    }

    private static String removeString(String response, String remove) {
        StringBuilder buff = new StringBuilder(response);
        int index = buff.indexOf(remove);
        if (index > -1) {
            int start = buff.lastIndexOf("<script", index);
            int end = buff.indexOf("</script>", index);
            if (start > -1 && end > -1 && start < end) {
                buff.delete(start, end + "</script>".length());
            }
        }
        return buff.toString();
    }
}

