/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sg;

import java.awt.Color;
import java.awt.event.AWTEventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.DefaultConnectionClassFactory;
import org.simantics.diagram.adapter.FlagClassFactory;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.handler.CopyPasteStrategy;
import org.simantics.diagram.handler.DefaultCopyPasteStrategy;
import org.simantics.diagram.handler.DeleteHandler;
import org.simantics.diagram.handler.SimpleElementTransformHandler;
import org.simantics.diagram.participant.ConnectionCrossingsParticipant;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.runtime.RuntimeDiagramManager;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.g2d.multileveldiagram.ZoomTransitionParticipant;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.MultitouchPanZoomRotateInteractor;
import org.simantics.g2d.participant.Notifications;
import org.simantics.g2d.participant.PageBorderParticipant;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ComponentCopyAdvisor;
import org.simantics.modeling.mapping.ElementCopyAdvisor;
import org.simantics.modeling.mapping.MappedElementCopyAdvisor;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.modeling.ui.diagramEditor.PopulateElementMonitorDropParticipant;
import org.simantics.modeling.ui.diagramEditor.handlers.HeadlessStructuralBrowsingHandler;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.adapter.AWTRemoteEventAdapter;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramSceneGraphProvider
implements ICanvasSceneGraphProvider,
HeadlessStructuralBrowsingHandler.IDiagramUpdateSupport {
    protected boolean isSymbol = false;
    protected Resource resource;
    protected ResourceArray structuralPath = null;
    protected IDiagram diagram = null;
    protected CanvasContext ctx = null;
    protected boolean ownsContext = false;
    protected GraphToDiagramSynchronizer synchronizer = null;
    protected String view = null;
    protected Boolean navigation = null;
    protected AWTRemoteEventAdapter listener = null;
    final IHintContext initialHints = new HintContext();

    public DiagramSceneGraphProvider(ReadGraph g, Resource diagramOrComposite) {
        this.structuralPath = new ResourceArray(new Resource[0]);
        try {
            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
            Resource diagram = diagramOrComposite;
            if (!g.isInstanceOf(diagram, DIA.Composite)) {
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
                diagram = g.getPossibleObject(diagramOrComposite, mr.CompositeToDiagram);
                if (diagram == null) {
                    Resource type = g.getSingleType(diagramOrComposite, sr.Component);
                    if (type == null) {
                        return;
                    }
                    Resource definedBy = g.getPossibleObject(type, sr.IsDefinedBy);
                    if (definedBy == null) {
                        return;
                    }
                    this.structuralPath = new ResourceArray(new Resource[]{diagramOrComposite});
                    diagram = g.getPossibleObject(definedBy, mr.CompositeToDiagram);
                }
            } else {
                Resource possibleSymbol = g.getPossibleObject(diagram, sr.Defines);
                if (possibleSymbol != null && g.isInstanceOf(possibleSymbol, DIA.ElementClass)) {
                    this.isSymbol = true;
                }
            }
            this.resource = diagram;
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (NoSingleResultException e) {
            e.printStackTrace();
        }
    }

    public GraphToDiagramSynchronizer getGraphToDiagramSynchronizer() {
        return this.synchronizer;
    }

    protected CopyPasteStrategy getCopyPasteStrategy() {
        try {
            CopyPasteStrategy cpStrategy = (CopyPasteStrategy)Simantics.getSession().syncRequest((Read)new PossibleAdapter(this.resource, CopyPasteStrategy.class));
            if (cpStrategy != null) {
                return cpStrategy;
            }
        }
        catch (DatabaseException databaseException) {}
        return new DefaultCopyPasteStrategy();
    }

    protected CopyAdvisor getCopyAdvisor() {
        try {
            CopyAdvisor advisor = (CopyAdvisor)Simantics.getSession().syncRequest((Read)new PossibleAdapter(this.resource, CopyAdvisor.class));
            if (advisor != null) {
                return advisor;
            }
        }
        catch (DatabaseException databaseException) {}
        return new MappedElementCopyAdvisor((CopyAdvisor)new ElementCopyAdvisor(), (CopyAdvisor)new ComponentCopyAdvisor());
    }

    protected void initContext(CanvasContext ctx) {
        boolean unlock = false;
        if (!ctx.isLocked()) {
            ctx.setLocked(true);
            unlock = true;
        }
        IHintContext h = ctx.getDefaultHintContext();
        ctx.add((Object)new TransformUtil());
        ctx.add((Object)new MouseUtil());
        ctx.add((Object)new KeyUtil());
        ctx.add((Object)new CanvasGrab());
        ctx.add((Object)new SymbolUtil());
        ctx.add((Object)new TimeParticipant());
        ctx.add((Object)new CanvasBoundsParticipant());
        ctx.add((Object)new Notifications());
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        ctx.add((Object)new PanZoomRotateHandler(this.navigation == null || this.navigation != false));
        ctx.add((Object)new MultitouchPanZoomRotateInteractor());
        ctx.add((Object)new ZoomToAreaHandler());
        ctx.add((Object)new SimpleElementTransformHandler());
        if (this.navigation == null || this.navigation.booleanValue()) {
            ctx.add((Object)new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        }
        h.setHint(RulerPainter.KEY_RULER_ENABLED, (Object)false);
        h.setHint(GridPainter.KEY_GRID_ENABLED, (Object)false);
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new RulerPainter());
        ctx.add((Object)new BackgroundPainter());
        h.setHint(Hints.KEY_DISPLAY_PAGE, (Object)Boolean.FALSE);
        h.setHint(Hints.KEY_DISPLAY_MARGINS, (Object)Boolean.TRUE);
        ctx.add((Object)new PageBorderParticipant());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.95f, 0.95f, 0.95f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        ctx.add((Object)new PointerInteractor(false, false, false, false, true, true, this.synchronizer.getElementClassProvider(), null));
        ctx.add((Object)new ElementInteractor());
        ctx.add((Object)new Selection());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter(true));
        ctx.add((Object)new ConnectionCrossingsParticipant(this.resource));
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new ZoomTransitionParticipant(TransitionFunction.SIGMOID));
        ctx.add((Object)new PopulateElementDropParticipant(this.synchronizer));
        ctx.add((Object)new PopulateElementMonitorDropParticipant(this.synchronizer, 0.5, 0.5));
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)1000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)10.0);
        ISessionContext sessionContext = Simantics.getSessionContext();
        ctx.add((Object)new HeadlessStructuralBrowsingHandler(this, sessionContext, this.structuralPath));
        PageDesc pageDesc = PageDesc.DEFAULT.withOrientation(PageOrientation.Landscape);
        h.setHint(Hints.KEY_PAGE_DESC, (Object)pageDesc);
        ctx.add((Object)new CopyPasteHandler(this.getCopyPasteStrategy()));
        ctx.add((Object)new DeleteHandler(null));
        if (this.resource != null) {
            this.loadPageSettings((ICanvasContext)ctx, this.resource);
        }
        ctx.assertParticipantDependencies();
        if (unlock) {
            ctx.setLocked(false);
        }
    }

    protected void loadPageSettings(final ICanvasContext ctx, Resource diagramResource) {
        try {
            DiagramDesc diagramDesc = (DiagramDesc)Simantics.getSession().syncRequest(DiagramRequests.getDiagramDesc((Resource)diagramResource));
            if (diagramDesc != null) {
                this.setDiagramDesc(ctx, diagramDesc);
            }
            Simantics.getSession().asyncRequest(DiagramRequests.getDiagramDesc((Resource)diagramResource), (Listener)new Listener<DiagramDesc>(){

                public void execute(DiagramDesc result) {
                    if (result != null && ctx != null) {
                        ThreadUtils.asyncExec((IThreadWorkQueue)ctx.getThreadAccess(), () -> {
                            if (ctx != null) {
                                DiagramSceneGraphProvider.this.setDiagramDesc(ctx, result);
                            }
                        });
                    }
                }

                public void exception(Throwable t) {
                    ErrorLogger.defaultLogError((Throwable)t);
                }

                public boolean isDisposed() {
                    return DiagramSceneGraphProvider.this.ctx == null;
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    protected void setDiagramDesc(ICanvasContext ctx, DiagramDesc diagramDesc) {
        IHintContext hints = ctx.getDefaultHintContext();
        hints.setHint(Hints.KEY_PAGE_DESC, (Object)diagramDesc.getPageDesc());
        hints.setHint(Hints.KEY_DISPLAY_PAGE, (Object)diagramDesc.isPageBordersVisible());
        hints.setHint(Hints.KEY_DISPLAY_MARGINS, (Object)diagramDesc.isMarginsVisible());
    }

    public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg) {
        return this.initializeSceneGraph(sg, null);
    }

    public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg, String view) {
        return this.initializeSceneGraph(sg, "", "", view);
    }

    public G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg, String modelURI, String RVI) {
        return this.initializeSceneGraph(sg, modelURI, RVI, "");
    }

    public G2DSceneGraph initializeSceneGraph(ICanvasContext context, String modelURI, String RVI) {
        G2DSceneGraph sg = context.getSceneGraph();
        return this.initializeSceneGraph(context, sg, modelURI, RVI, "");
    }

    private G2DSceneGraph initializeSceneGraph(G2DSceneGraph sg, String modelURI, String RVI, String view) {
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        this.ctx = new CanvasContext(thread, sg);
        return this.initializeSceneGraph((ICanvasContext)this.ctx, sg, modelURI, RVI, view);
    }

    private G2DSceneGraph initializeSceneGraph(ICanvasContext context, G2DSceneGraph sg, String modelURI, String RVI, String view) {
        this.ctx = (CanvasContext)context;
        this.view = view;
        if (view != null) {
            this.initialHints.setHint(DiagramHints.KEY_FIXED_LAYERS, (Object)new String[]{view});
        }
        try {
            this.fillInitialDiagramHints(this.initialHints);
            final RuntimeDiagramManager runtimeDiagramManager = RuntimeDiagramManager.create((Session)Simantics.getSession(), (Resource)this.resource, (String)modelURI, (String)RVI);
            this.synchronizer = (GraphToDiagramSynchronizer)Simantics.getSession().syncRequest((Read)new Read<GraphToDiagramSynchronizer>(){

                public GraphToDiagramSynchronizer perform(ReadGraph graph) throws DatabaseException {
                    DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                    Boolean val = (Boolean)graph.getPossibleRelatedValue(DiagramSceneGraphProvider.this.resource, dr.NavigationEnabled, (Binding)Bindings.BOOLEAN);
                    if (val != null && DiagramSceneGraphProvider.this.navigation == null) {
                        DiagramSceneGraphProvider.this.navigation = val;
                    }
                    GraphToDiagramSynchronizer sync = new GraphToDiagramSynchronizer((RequestProcessor)graph, (ICanvasContext)DiagramSceneGraphProvider.this.ctx, DiagramSceneGraphProvider.this.createElementClassProvider(graph));
                    sync.set(ModelingSynchronizationHints.MODELING_RESOURCE, (Object)ModelingResources.getInstance((ReadGraph)graph));
                    DiagramSceneGraphProvider.this.diagram = sync.loadDiagram((IProgressMonitor)new NullProgressMonitor(), graph, null, DiagramSceneGraphProvider.this.resource, runtimeDiagramManager.getRuntimeDiagram(), DiagramSceneGraphProvider.this.structuralPath, (IHintObservable)DiagramSceneGraphProvider.this.initialHints);
                    return sync;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.ctx.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)this.diagram);
        this.initContext(this.ctx);
        return this.ctx.getSceneGraph();
    }

    protected void fillInitialDiagramHints(IHintContext initialHints) throws DatabaseException {
        IModelingRules modelingRules = (IModelingRules)Simantics.getSession().syncRequest(DiagramRequests.getModelingRules((Resource)this.resource, null));
        if (modelingRules != null) {
            initialHints.setHint(DiagramModelHints.KEY_MODELING_RULES, (Object)modelingRules);
        }
        initialHints.setHint(SynchronizationHints.COPY_ADVISOR, (Object)this.getCopyAdvisor());
    }

    protected IElementClassProvider createElementClassProvider(ReadGraph graph) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        return ElementClassProviders.mappedProvider((Object[])new Object[]{ElementClasses.CONNECTION, DefaultConnectionClassFactory.CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)dr.Connection)}), ElementClasses.FLAG, FlagClassFactory.createFlagClass((Resource)dr.Flag, (Resource)dr.Flag_Terminal)});
    }

    public void dispose() {
        if (this.ctx != null) {
            if (this.ownsContext) {
                this.ctx.dispose();
            }
            this.ctx = null;
        }
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
            this.synchronizer = null;
        }
        if (this.diagram != null) {
            this.diagram.dispose();
            this.diagram = null;
        }
    }

    public ICanvasContext getCanvasContext() {
        return this.ctx;
    }

    public AWTEventListener getEventListener() {
        if (this.ctx == null) {
            return null;
        }
        if (this.listener == null) {
            this.listener = new AWTRemoteEventAdapter((Object)this.ctx, this.ctx.getEventQueue());
        }
        return this.listener;
    }

    @Override
    public void updateDiagram(final ResourceArray structuralPath) {
        HintContext hints = new HintContext();
        if (this.view != null) {
            System.out.println("using layer '" + this.view + "'");
            hints.setHint(DiagramHints.KEY_FIXED_LAYERS, (Object)new String[]{this.view});
        }
        try {
            this.diagram = (IDiagram)Simantics.getSession().syncRequest((Read)new Read<IDiagram>((IHintContext)hints){
                private final /* synthetic */ IHintContext val$hints;
                {
                    this.val$hints = iHintContext;
                }

                public IDiagram perform(ReadGraph graph) throws DatabaseException {
                    IDiagram d = DiagramSceneGraphProvider.this.synchronizer.loadDiagram((IProgressMonitor)new NullProgressMonitor(), graph, null, structuralPath.resources[0], null, structuralPath.removeFromBeginning(0), (IHintObservable)this.val$hints);
                    return d;
                }
            });
            this.ctx.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)this.diagram);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void setExperiment(ReadGraph g, String identifier) {
        if (this.diagram == null) {
            return;
        }
        this.diagram.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, (Object)identifier);
        this.initialHints.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, (Object)identifier);
    }

    public void setHint(Object key, Object value) {
        if (DiagramModelHints.KEY_SESSION_ID.equals(key)) {
            if (this.diagram != null) {
                this.diagram.setHint(DiagramModelHints.KEY_SESSION_ID, value);
            }
            this.initialHints.setHint(DiagramModelHints.KEY_SESSION_ID, value);
        } else if (DiagramModelHints.KEY_ACTIVE_EXPERIMENT.equals(key)) {
            if (this.diagram != null) {
                this.diagram.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, value);
            }
            this.initialHints.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, value);
        } else if (DiagramHints.KEY_NAVIGATION_ENABLED.equals(key)) {
            this.navigation = (Boolean)value;
        }
    }
}

