/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.common.IssueUtils;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeledActions
extends DynamicMenuContribution
implements IExecutableExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueUtils.class);
    public static final Set<String> defaultBrowseContexts = Collections.singleton("http://www.simantics.org/Project-1.2/ProjectActionContext");
    protected Set<String> browseContexts = defaultBrowseContexts;
    public static final Comparator<Action> ACTION_COMPARATOR = new Comparator<Action>(){

        @Override
        public int compare(Action o1, Action o2) {
            String t1 = o1.getText();
            String t2 = o2.getText();
            if (t1 == null) {
                if (t2 == null) {
                    return 0;
                }
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.compareTo(t2);
        }
    };

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] parms;
            String str = (String)data;
            String[] stringArray = parms = str.split(";");
            int n = parms.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                String parm = stringArray[n2];
                String[] keyValue = parm.split("=");
                if (keyValue.length == 2 && "context".equals(key = keyValue[0].trim())) {
                    this.browseContexts = Collections.singleton(keyValue[1]);
                }
                ++n2;
            }
        }
    }

    protected Collection<String> getBrowseContexts() {
        return this.browseContexts;
    }

    protected Collection<Resource> getBrowseContextResources(ReadGraph graph) throws DatabaseException {
        Collection<String> names = this.getBrowseContexts();
        ArrayList<Resource> result = new ArrayList<Resource>(names.size());
        for (String name : names) {
            result.add(graph.getResource(name));
        }
        return result;
    }

    protected List<NodeContext> getContexts(Object[] selection) {
        if (selection.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeContext> result = new ArrayList<NodeContext>(selection.length);
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            NodeContext nodeContext;
            Object o = objectArray[n2];
            if (o instanceof IAdaptable && (nodeContext = (NodeContext)((IAdaptable)o).getAdapter(NodeContext.class)) != null) {
                result.add(nodeContext);
            } else {
                try {
                    Resource res = WorkbenchSelectionUtils.getPossibleResource((Object)o);
                    if (res != null) {
                        result.add(NodeContextBuilder.buildWithInput((Object)res));
                    }
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to get node contexts for selection.", (Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }

    protected List<NodeContext> getContexts(ReadGraph graph, Object[] selection) throws DatabaseException {
        return this.getContexts(selection);
    }

    protected static IContributionItem[] toContributionItems(Map<IActionCategory, List<Action>> map) {
        if (map.isEmpty()) {
            return NONE;
        }
        IActionCategory[] categories = map.keySet().toArray(new IActionCategory[map.size()]);
        Arrays.sort(categories, IActionCategory.ACTION_CATEGORY_COMPARATOR);
        ArrayList<Object> items = new ArrayList<Object>();
        boolean first = true;
        IActionCategory[] iActionCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IActionCategory category = iActionCategoryArray[n2];
            List<Action> actions = map.get(category);
            Collections.sort(actions, ACTION_COMPARATOR);
            if (category != null && category.isSubmenu()) {
                MenuManager manager = new MenuManager(category.getLabel());
                for (Action action : actions) {
                    manager.add((IContributionItem)new ActionContributionItem((IAction)action));
                }
                items.add(manager);
            } else {
                if (first) {
                    first = false;
                } else {
                    items.add(new Separator(category == null ? "" : category.getLabel()));
                }
                for (Action action : actions) {
                    items.add(new ActionContributionItem((IAction)action));
                }
            }
            ++n2;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    protected Object[] getSelectedObjects() {
        Object[] sel = super.getSelectedObjects();
        List<NodeContext> contexts = this.getContexts(sel);
        return contexts.toArray(NodeContext.NONE);
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        List<NodeContext> contexts = Arrays.asList((NodeContext[])selection);
        if (contexts.isEmpty()) {
            return NONE;
        }
        try {
            HashMap result;
            NodeContext nodeContext = contexts.get(0);
            ActionBrowseContext defaultContext = ActionBrowseContext.create((ReadGraph)graph, this.getBrowseContextResources(graph));
            ActionBrowseContext browseContext = ActionBrowseContext.get((ReadGraph)graph, (NodeContext)nodeContext, (ActionBrowseContext)defaultContext);
            HashMap current = result = browseContext.getActions(graph, nodeContext, contexts);
            int i = 1;
            while (i < contexts.size()) {
                browseContext = ActionBrowseContext.get((ReadGraph)graph, (NodeContext)nodeContext, (ActionBrowseContext)defaultContext);
                Map m = browseContext.getActions(graph, contexts.get(i), contexts);
                result = new HashMap();
                for (Map.Entry entry : m.entrySet()) {
                    List exist = (List)current.get(entry.getKey());
                    if (exist == null) continue;
                    ArrayList<Action> l = new ArrayList<Action>();
                    for (Action e : exist) {
                        String id = e.getId();
                        boolean found = false;
                        for (Action a : (List)entry.getValue()) {
                            if (!id.equals(a.getId())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        l.add(e);
                    }
                    if (l.isEmpty()) continue;
                    result.put((IActionCategory)entry.getKey(), l);
                }
                current = result;
                ++i;
            }
            return ModeledActions.toContributionItems(result);
        }
        catch (InvalidContribution e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", NLS.bind((String)Messages.ModeledActions_ActivatorInvalidContributionsEncounteredIn, (Object)((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e));
            return NONE;
        }
    }
}

