/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableNodeReadRunnable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NodeIsNotValidAnymoreException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeValueRequest
extends ParametrizedPrimitiveRead<Pair<VariableNode, Binding>, Variant>
implements VariableNodeReadRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeValueRequest.class);
    private Listener<Variant> listener = null;
    private Variant value = Variables.PENDING_NODE_VALUE;
    private boolean wasRun = false;

    public NodeValueRequest(VariableNode node) {
        super((Object)Pair.make((Object)node, null));
    }

    public NodeValueRequest(VariableNode node, Binding binding) {
        super((Object)Pair.make((Object)node, (Object)binding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ReadGraph graph, Listener<Variant> procedure) {
        VariableNode node = (VariableNode)((Pair)this.parameter).first;
        if (procedure.isDisposed()) {
            Variant result = node.support.valueCache.get(node.node);
            if (result != null) {
                procedure.execute((Object)result);
            } else {
                Probe probe = new Probe((Pair<VariableNode, Binding>)((Pair)this.parameter));
                node.support.manager.getRealm().asyncExec((Runnable)probe);
                if (probe.result != null) {
                    procedure.execute((Object)probe.result);
                } else {
                    procedure.execute((Object)Variables.PENDING_NODE_VALUE);
                }
            }
            return;
        }
        this.listener = procedure;
        node.support.manager.addNodeListener(node.node, (Runnable)this);
        NodeValueRequest nodeValueRequest = this;
        synchronized (nodeValueRequest) {
            if (this.wasRun) {
                procedure.execute((Object)this.value);
            } else {
                Variant result = node.support.valueCache.get(node.node);
                if (result != null) {
                    procedure.execute((Object)result);
                } else {
                    procedure.execute((Object)Variables.PENDING_NODE_VALUE);
                }
            }
        }
    }

    public void unregistered() {
        VariableNode node = (VariableNode)((Pair)this.parameter).first;
        node.support.manager.removeNodeListener(node.node, (Runnable)this);
        node.support.valueCache.removeListening(node.node);
        this.listener = null;
    }

    public static Variant get(Pair<VariableNode, Binding> parameter) throws NodeManagerException, BindingException {
        VariableNode node = (VariableNode)parameter.first;
        Binding binding = (Binding)parameter.second;
        if (binding != null) {
            Object raw = node.support.manager.getValue(node.node, binding);
            if (raw == null) {
                return null;
            }
            if (NodeManager.PENDING_NODE_VALUE == raw) {
                return NodeManager.PENDING_NODE_VALUE;
            }
            return new Variant(binding, raw);
        }
        return node.support.manager.getValue(node.node);
    }

    @Override
    public synchronized void run() {
        VariableNode node = (VariableNode)((Pair)this.parameter).first;
        try {
            Variant newValue = NodeValueRequest.get((Pair<VariableNode, Binding>)((Pair)this.parameter));
            if (this.wasRun && ObjectUtils.objectEquals((Object)this.value, (Object)newValue)) {
                return;
            }
            this.value = newValue;
            node.support.valueCache.put(node.node, this.value);
        }
        catch (Throwable e) {
            Listener<Variant> listener;
            if (!(e instanceof NodeIsNotValidAnymoreException)) {
                LOGGER.error("Error while computing node value", e);
            }
            if ((listener = this.listener) != null) {
                listener.exception((Throwable)new DatabaseException("External data access error", e));
            }
            this.wasRun = true;
            return;
        }
        Listener<Variant> listener = this.listener;
        if (listener != null) {
            listener.execute((Object)this.value);
        }
        this.wasRun = true;
    }

    public String toString() {
        return "NodeValueRequest.run " + ((VariableNode)((Pair)this.parameter).first).node + " " + ((VariableNode)((Pair)this.parameter).first).support.manager + " " + System.identityHashCode(this);
    }

    static class NodeListener
    implements VariableNodeReadRunnable {
        private VariableNode node;
        private NodeValueRequest request;

        public NodeListener(VariableNode node, NodeValueRequest request) {
            this.node = node;
            this.request = request;
        }

        @Override
        public void run() {
            this.node.support.manager.addNodeListener(this.node.node, (Runnable)this.request);
        }
    }

    static class Probe
    implements Runnable {
        private Pair<VariableNode, Binding> parameter;
        public Variant result;

        public Probe(Pair<VariableNode, Binding> parameter) {
            this.parameter = parameter;
        }

        @Override
        public void run() {
            try {
                this.result = NodeValueRequest.get(this.parameter);
                ((VariableNode)this.parameter.first).support.valueCache.put(((VariableNode)this.parameter.first).node, this.result, 1000000000L);
            }
            catch (NodeManagerException e) {
                e.printStackTrace();
            }
            catch (BindingException e) {
                e.printStackTrace();
            }
        }
    }
}

