/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.operation.Layer0X;

public class ApplyTemplatesRequest {
    Map<String, Object> parameters;
    Collection<Resource> contexts;

    public ApplyTemplatesRequest(Map<String, Object> parameters, Collection<Resource> contexts) {
        this.parameters = parameters;
        this.contexts = contexts;
    }

    public ApplyTemplatesRequest(Map<String, Object> parameters) {
        this(parameters, new ArrayList<Resource>(2));
    }

    public ApplyTemplatesRequest() {
        this(new HashMap<String, Object>());
    }

    public void perform(WriteGraph g, Resource resource) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        this.parameters.put("", resource);
        if (this.contexts.isEmpty()) {
            this.contexts.add(L0X.HasTemplate);
        }
        HashSet templates = new HashSet();
        for (Resource context : this.contexts) {
            templates.addAll(g.getObjects(resource, context));
        }
        for (Resource template : templates) {
            ((Template)g.adapt(template, Template.class)).apply(g, this.parameters);
        }
    }

    public void addContext(Resource context) {
        this.contexts.add(context);
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public <T> T getParameter(String key) {
        return (T)this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }
}

