/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.map.hash.TObjectByteHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.issues.common.preferences.IssuePrefs;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class ModelVisibleIssues
extends BinaryRead<Resource, Boolean, Set<Variable>> {
    public ModelVisibleIssues(Resource model) {
        super((Object)model, (Object)Boolean.FALSE);
    }

    public ModelVisibleIssues(Resource model, boolean onlyUnresolved) {
        super((Object)model, (Object)onlyUnresolved);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        Collection issues;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Resource project = Simantics.getProjectResource();
        boolean showHidden = false;
        boolean showNormal = true;
        boolean showUser = true;
        if (project != null) {
            showHidden = IssuePrefs.showHiddenIssues(graph, project);
            showNormal = IssuePrefs.showNormalIssues(graph, project);
            showUser = IssuePrefs.showUserIssues(graph, project);
        }
        Instances issueIndex = (Instances)graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        TObjectByteHashMap sourceActivenessCache = new TObjectByteHashMap();
        THashSet result = new THashSet(1013);
        Collection modelIssues = (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, ISSUE.Issue));
        List indexedIssues = issueIndex != null ? issueIndex.find(graph, (Resource)this.parameter) : Collections.emptyList();
        Collection collection = issues = !indexedIssues.isEmpty() ? new THashSet(modelIssues.size() + indexedIssues.size()) : modelIssues;
        if (!indexedIssues.isEmpty()) {
            issues.addAll(modelIssues);
            issues.addAll(indexedIssues);
        }
        for (Resource issue : issues) {
            Variable var;
            boolean normal;
            boolean resolved = graph.hasStatement(issue, ISSUE.Resolved);
            if (((Boolean)this.parameter2).booleanValue() && resolved) continue;
            boolean hidden = graph.hasStatement(issue, ISSUE.Hidden);
            boolean user = graph.hasStatement(issue, ISSUE.UserIssue);
            boolean bl = normal = !hidden && !user;
            if (!showHidden && hidden || !showUser && user || !showNormal && normal) continue;
            Resource source = graph.getPossibleObject(issue, ISSUE.IssueSource_Manages_Inverse);
            if (source != null) {
                boolean active;
                byte cache = sourceActivenessCache.get((Object)source);
                boolean bl2 = active = cache == 2;
                if (cache == 0) {
                    active = Boolean.TRUE.equals(graph.getPossibleRelatedValue(source, ISSUE.IssueSource_active));
                    sourceActivenessCache.put((Object)source, active ? (byte)2 : 1);
                }
                if (!active) continue;
            }
            if ((var = Variables.getPossibleVariable((ReadGraph)graph, (Resource)issue)) == null) continue;
            result.add(var);
        }
        return result;
    }
}

