/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.bytes;

public class LEFloat {
    public static byte[] toBytes(float value) {
        byte[] array = new byte[4];
        int l = Float.floatToIntBits(value);
        array[3] = (byte)(l & 0xFF);
        array[2] = (byte)(l >> 8 & 0xFF);
        array[1] = (byte)(l >> 16 & 0xFF);
        array[0] = (byte)(l >> 24 & 0xFF);
        return array;
    }

    public static void write(float value, byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        int l = Float.floatToIntBits(value);
        array[3 + offset] = (byte)(l & 0xFF);
        array[2 + offset] = (byte)(l >> 8);
        array[1 + offset] = (byte)(l >> 16);
        array[0 + offset] = (byte)(l >> 24);
    }

    public static void write(float value, byte[] array) {
        if (array.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        int l = Float.floatToIntBits(value);
        array[3] = (byte)(l & 0xFF);
        array[2] = (byte)(l >> 8);
        array[1] = (byte)(l >> 16);
        array[0] = (byte)(l >> 24);
    }

    public static float toFloat(byte[] array, int offset) {
        if (offset + 4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        return Float.intBitsToFloat(array[3 + offset] & 0xFF | (array[2 + offset] & 0xFF) << 8 | (array[1 + offset] & 0xFF) << 16 | (array[0 + offset] & 0xFF) << 24);
    }

    public static float toFloat(byte[] array) {
        if (4 > array.length) {
            throw new IndexOutOfBoundsException();
        }
        return Float.intBitsToFloat(array[3] & 0xFF | (array[2] & 0xFF) << 8 | (array[1] & 0xFF) << 16 | (array[0] & 0xFF) << 24);
    }

    public static void main(String[] args) {
        System.out.println("min=1.4E-45 max=3.4028235E38");
        float value = -0.123123124f;
        byte[] array = LEFloat.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        LEFloat.printByteArray(array);
        System.out.println();
        LEFloat.write(value, array, 0);
        System.out.print(value);
        System.out.print(" = ");
        LEFloat.printByteArray(array);
        System.out.println();
        LEFloat.write(value, array);
        System.out.print(value);
        System.out.print(" = ");
        LEFloat.printByteArray(array);
        System.out.println();
        value = LEFloat.toFloat(array, 0);
        LEFloat.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
        value = LEFloat.toFloat(array);
        LEFloat.printByteArray(array);
        System.out.print(" = ");
        System.out.print(value);
        System.out.println();
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }
}

