/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util;

import java.util.Formatter;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.simantics.databoard.primitives.MutableInteger;

public class ClassDistribution {
    private transient double lastEnteredValue;
    private transient int lastClass;
    double base;
    private transient double log_base;
    TreeMap<Integer, MutableInteger> distribution;

    public ClassDistribution() {
        this(2.0);
    }

    public ClassDistribution(double base) {
        this.base = base;
        this.log_base = Math.log(base);
        this.lastEnteredValue = 0.001;
        this.lastClass = (int)Math.floor(Math.log(0.001) / this.log_base);
        this.distribution = new TreeMap();
    }

    public ClassDistribution(double base, TreeMap<Integer, MutableInteger> initialBreakdown) {
        this.base = base;
        this.log_base = Math.log(base);
        this.lastEnteredValue = 0.001;
        this.lastClass = (int)Math.floor(Math.log(0.001) / this.log_base);
        this.distribution = new TreeMap<Integer, MutableInteger>((SortedMap<Integer, MutableInteger>)initialBreakdown);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.log_base = Math.log(base);
    }

    public double getSmallest() {
        if (this.distribution.isEmpty()) {
            return 1.0;
        }
        int clazz = this.distribution.firstKey();
        return this.getClassAvg(clazz);
    }

    public double getMedian() {
        int n = 0;
        for (MutableInteger v : this.distribution.values()) {
            n += v.value;
        }
        double median = (double)n / 2.0;
        double sum = 0.0;
        for (Map.Entry<Integer, MutableInteger> e : this.distribution.entrySet()) {
            if ((sum += (double)e.getValue().value) == median) {
                int c = e.getKey();
                Integer nextC = this.distribution.higherKey(c);
                if (nextC == null) {
                    return this.getClassMax(c);
                }
                return (this.getClassMax(c) + this.getClassMin(nextC)) / 2.0;
            }
            if (!(sum > median)) continue;
            int c = e.getKey();
            return this.getClassAvg(c);
        }
        return 0.0;
    }

    public int getLargestClassIndex() {
        int result = 0;
        int nResult = -1;
        for (Map.Entry<Integer, MutableInteger> e : this.distribution.entrySet()) {
            if (e.getValue().value <= nResult) continue;
            nResult = e.getValue().value;
            result = e.getKey();
        }
        return result;
    }

    public void getDistribution(Map<Integer, Integer> result) {
        result.clear();
        for (Map.Entry<Integer, MutableInteger> e : this.distribution.entrySet()) {
            result.put(e.getKey(), e.getValue().value);
        }
    }

    public void setDistribution(Map<Integer, Integer> map) {
        this.distribution.clear();
        for (Map.Entry<Integer, Integer> e : map.entrySet()) {
            this.distribution.put(e.getKey(), new MutableInteger(e.getValue().intValue()));
        }
    }

    public TreeMap<Integer, Integer> getDistribution() {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        this.getDistribution(result);
        return result;
    }

    public void addValue(double value) {
        Integer k = this.getClassIndex(value);
        MutableInteger r = this.distribution.get(k);
        if (r == null) {
            r = new MutableInteger();
            this.distribution.put(k, r);
        }
        ++r.value;
    }

    public double getClassMin(int intervalClass) {
        return Math.pow(this.base, intervalClass);
    }

    public double getClassMax(int intervalClass) {
        return Math.pow(this.base, intervalClass + 1);
    }

    public double getClassAvg(int intervalClass) {
        double min = this.getClassMin(intervalClass);
        double max = this.getClassMax(intervalClass);
        return (max - min) / 2.0 + min;
    }

    public int getClassIndex(double interval) {
        if (interval == this.lastEnteredValue) {
            return this.lastClass;
        }
        this.lastClass = (int)Math.floor(Math.log(interval) / this.log_base);
        this.lastEnteredValue = interval;
        return this.lastClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        sb.append("Index Range Count\n");
        for (Map.Entry<Integer, MutableInteger> e : this.distribution.entrySet()) {
            String format;
            int ic = e.getKey();
            double start = this.getClassMin(ic);
            double end = this.getClassMax(ic);
            double avg = this.getClassAvg(ic);
            int count = e.getValue().value;
            if (start < 0.001) {
                start *= 1000.0;
                end *= 1000.0;
                avg *= 1000.0;
                format = "  %+3d   [ %(,8fm .. %(,8fm ) = %d, avg = %(,8fm\n";
            } else if (start < 1.0) {
                start *= 1000.0;
                end *= 1000.0;
                avg *= 1000.0;
                format = "  %+3d   [ %(,8.2fm .. %(,8.2fm ) = %d, avg = %(,8.2fm\n";
            } else {
                format = "  %+3d   [ %(9.0f .. %(9.0f ) = %d, avg = %(8.1f\n";
            }
            f.format(format, ic, start, end, count, avg);
        }
        return sb.toString();
    }
}

