/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.ui.ExpressionTextListener;
import org.simantics.spreadsheet.ui.TableSelection;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.ui.selection.VariableWorkbenchSelectionElement;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SelectionListener
implements ListSelectionListener {
    final JTable table;
    final JTextField expression;
    final ExpressionTextListener etl;
    final ActiveSelectionProvider selectionProvider;
    final Adaptable serverModel;
    final ClientModel clientModel;

    SelectionListener(JTable table, JTextField expression, ExpressionTextListener etl, ActiveSelectionProvider selectionProvider, Adaptable serverModel, ClientModel clientModel) {
        assert (table != null);
        assert (selectionProvider != null);
        this.table = table;
        this.expression = expression;
        this.etl = etl;
        this.selectionProvider = selectionProvider;
        this.serverModel = serverModel;
        this.clientModel = clientModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        final int[] selectedColumns = this.table.getSelectedColumns();
        final int[] selectedRows = this.table.getSelectedRows();
        if (selectedColumns.length == 1 && selectedRows.length == 1) {
            final TableSelection tableSelection = new TableSelection(){

                @Override
                public int[] getColumns() {
                    return selectedColumns;
                }

                @Override
                public int[] getRows() {
                    return selectedRows;
                }
            };
            final Variable sheet = (Variable)this.serverModel.getAdapter(Variable.class);
            final Object cell = this.table.getValueAt(selectedRows[0], selectedColumns[0]);
            if (cell != null) {
                Variant content;
                String expression = "";
                Object expressionO = this.clientModel.getPossiblePropertyAt(Spreadsheets.cellName((int)selectedRows[0], (int)selectedColumns[0]), "content#expression");
                if (expressionO instanceof String) {
                    expression = (String)expressionO;
                } else if (expressionO instanceof Variant) {
                    expression = ((Variant)expressionO).toString();
                }
                expression = expression == null ? ((content = SpreadsheetUtils.getSafeClientVariant((ClientModel)this.clientModel, (String)Spreadsheets.cellName((int)selectedRows[0], (int)selectedColumns[0]), (String)"content")) != null ? content.getValue().toString() : "") : "=" + expression;
                if (this.etl != null) {
                    if (expression != null) {
                        this.etl.setCell(expression, selectedRows[0], selectedColumns[0]);
                    } else {
                        this.etl.setCell("", -1, -1);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (sheet != null) {
                            SelectionListener.this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)new VariableWorkbenchSelectionElement(sheet)));
                        } else {
                            SelectionListener.this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{cell, "", tableSelection}));
                        }
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SelectionListener.this.selectionProvider == null) {
                            return;
                        }
                        if (sheet != null) {
                            SelectionListener.this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{sheet, "", tableSelection}));
                        } else {
                            SelectionListener.this.selectionProvider.setSelection((ISelection)new StructuredSelection(new Object[]{"", "", tableSelection}));
                        }
                    }
                });
            }
        }
        e.getValueIsAdjusting();
    }
}

