/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fileimport.dropins;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.fileimport.Activator;
import org.simantics.fileimport.FileImportService;

public class FileImportDropins {
    private static Thread watcherThread = null;
    private static DropinsFolderWatcher watcher = null;

    public static void watchDropinsFolder() {
        if (watcher == null && watcherThread == null) {
            try {
                watcher = new DropinsFolderWatcher(Activator.getDropinsFolder());
                watcherThread = new Thread((Runnable)watcher, "Simantics Dropins Folder watcher thread");
                watcherThread.setDaemon(true);
                watcherThread.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void unwatchDropinsFolder() {
        if (watcher == null) {
            return;
        }
        watcher.stop();
        try {
            watcherThread.join(500L);
            if (watcherThread.isAlive()) {
                watcherThread.interrupt();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        watcherThread = null;
        watcher = null;
    }

    private static class DropinsFolderWatcher
    implements Runnable {
        private final Path dropinsFolder;
        private final WatchService ws;
        private final AtomicBoolean stopped = new AtomicBoolean(true);
        private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();

        public DropinsFolderWatcher(Path dropinsFolder) throws IOException {
            this.dropinsFolder = dropinsFolder;
            FileSystem fs = dropinsFolder.getFileSystem();
            this.ws = fs.newWatchService();
            this.registerAll(this.dropinsFolder);
        }

        private static void syncPath(Path f) throws IOException {
            boolean synced = false;
            int count = 0;
            while (!synced) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (RandomAccessFile raf = new RandomAccessFile(f.toFile(), "rw");){
                        raf.getFD().sync();
                        synced = true;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (count == 3) {
                        throw e;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    ++count;
                }
            }
        }

        @Override
        public void run() {
            this.stopped.set(false);
            while (!this.stopped.get()) {
                try {
                    WatchKey key = this.ws.take();
                    for (WatchEvent<?> watchEvent : key.pollEvents()) {
                        if (StandardWatchEventKinds.OVERFLOW == watchEvent.kind()) continue;
                        WatchEvent<?> pathEvent = watchEvent;
                        WatchEvent.Kind<?> kind = pathEvent.kind();
                        Path parent = this.keys.get(key);
                        Path newPath = parent.resolve((Path)pathEvent.context());
                        if (".simanticsdb".equals(newPath.getFileName().toString())) continue;
                        if (StandardWatchEventKinds.ENTRY_CREATE == kind) {
                            System.out.println("New path created: " + newPath);
                            int current = 0;
                            while (!Files.isWritable(newPath) && current <= 10) {
                                System.out.println("Sleeping for file import (current=" + current + ")");
                                Thread.sleep(200L);
                                ++current;
                            }
                            FileImportService.performFileImport(newPath, Optional.empty(), Optional.of(t -> {
                                if (t instanceof FileSystemException || t instanceof FileNotFoundException) {
                                    try {
                                        DropinsFolderWatcher.syncPath(newPath);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    FileImportService.performFileImport(newPath, Optional.empty(), Optional.empty());
                                } else {
                                    t.printStackTrace();
                                }
                            }));
                            this.register(newPath);
                            continue;
                        }
                        if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                            System.out.println("New path modified: " + newPath);
                            continue;
                        }
                        if (StandardWatchEventKinds.ENTRY_DELETE != kind) continue;
                        System.out.println("New path deleted: " + newPath);
                        FileImportService.removeResourceForFile(newPath.toAbsolutePath(), Optional.empty());
                    }
                    if (key.reset()) continue;
                    this.keys.remove(key);
                }
                catch (InterruptedException e) {
                    if (this.stopped.get()) continue;
                    e.printStackTrace();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }

        public void stop() {
            this.stopped.set(true);
        }

        private void registerAll(Path path) throws IOException {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    this.register(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private void register(Path path) throws IOException {
            if (Files.isDirectory(path, new LinkOption[0])) {
                WatchKey key = path.toAbsolutePath().register(this.ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.keys.put(key, path);
            }
        }
    }
}

