/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads.test;

import java.util.Random;

import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;


public class Test {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		final WorkerThread list[] = new WorkerThread[10];
		for (int i =0; i<list.length; i++)
			list[i] = new WorkerThread();
		
		for (WorkerThread t : list)
			t.start();
		
		final Random r = new Random();
		
		ExampleObject obj = new ExampleObject();
		
		ExampleListener l = new ExampleListener() {
			@Override
			public void onMessage(ExampleObject sender, String msg) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {}
				System.out.println(Thread.currentThread()+": "+msg);
				ThreadUtils.syncExec(
						list[r.nextInt(list.length)],
						new Runnable() {
							@Override
							public void run() {
								try {
									Thread.sleep(1000);
								} catch (InterruptedException e) {}
								System.out.println("blaa");
								try {
									Thread.sleep(1000);
								} catch (InterruptedException e) {}
							}});
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {}
			}};
		
		for (WorkerThread t : list)						
			obj.addListener(t, l);
		
		obj.fireMessage("Test");
		System.out.println("jeps");

		for (WorkerThread t : list)
			t.stopDispatchingEvents(true);
	}

}
