/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.utils.threads.test;

import java.lang.reflect.Method;

import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;


public class ExampleObject {

	SyncListenerList<ExampleListener> listeners = new SyncListenerList<ExampleListener>(ExampleListener.class);
	
	public void addListener(IThreadWorkQueue thread, ExampleListener l)
	{
		listeners.add(thread, l);		
	}
	
	public void removeListener(IThreadWorkQueue thread, ExampleListener l)
	{
		listeners.remove(thread, l);
	}
	
	static final Method onMessage = SyncListenerList.getMethod(ExampleListener.class, "onMessage");
	public void fireMessage(String message)
	{
		listeners.fireEventSync(onMessage, this, message);
	}
	
}
