/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.workbench.editor;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public interface IEditorRegistry {

    /**
     * @param id
     * @return
     */
    EditorAdapterDescriptor getExtensionById(String id);

    /**
     * @param id
     * @return
     */
    EditorAdapter getAdapterById(String id);

    /**
     * @return
     */
    EditorAdapterDescriptor[] getEditorAdapters();

    /**
     * @param g
     * @param r
     * @return
     */
    EditorAdapter[] getAdaptersFor(ReadGraph g, Object r) throws DatabaseException;

    /**
     * @return
     */
    EditorMapping getMappings();

    /**
     * @param g
     * @param r
     * @return
     */
    EditorAdapter[] getDefaultAdaptersFor(ReadGraph g, Object r) throws DatabaseException;

}