/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.contribution;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.utils.collections.IContextualList;
import org.simantics.layer0.utils.operations.IOperation;
import org.simantics.project.IProject;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.persistent.ContextMap;


public abstract class OperationsMenuContribution extends DynamicMenuContribution {

    protected abstract Resource getListResource(ReadGraph g) throws Exception;

    protected void assignParameters(ContextMap parameters) {
    }

    @Override
    protected boolean preAcceptSelection(Object[] selection) {
        if(selection == null || selection.length != 1)
            return false;
        Resource r = ResourceAdaptionUtils.adaptToResource(selection[0]);
        return r != null;
    }

    @Override
    protected IAction[] getActions(ReadGraph g, Object[] selection) throws DatabaseException {
        if(selection.length == 1) {
            final Resource r = WorkbenchSelectionUtils.getPossibleResourceFromSelection(g, selection[0]);
            if(r == null)
            	return NO_ACTIONS;
            try {
                return g.syncRequest(new Read<IAction[]>() {

                    @Override
                    public IAction[] perform(ReadGraph g) throws DatabaseException {
                        IContextualList list;
                        try {
                            list = g.adapt(getListResource(g), IContextualList.class);
                        } catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                        final ContextMap parameters = new ContextMap();
                        parameters.put(IOperation.SUBJECT, r);
                        IProject project = Simantics.peekProject();
                        if (project != null)
                            parameters.put(IOperation.PROJECT, project.get());
                        assignParameters(parameters);
                        Collection<Resource> operations = new ArrayList<Resource>();
                        list.fill(g, parameters, operations);

                        if(!operations.isEmpty()) {
                            IAction[] actions = new IAction[operations.size()];
                            int i=0;
                            for(Resource opRes : operations) {
                                final IOperation op = g.adapt(opRes, IOperation.class);
                                final ImageDescriptor imgDesc = ImageUtil.adaptImageDescriptor(g, opRes);
                                final WeakReference<Session> sessionRef = new WeakReference<Session>(g.getSession());
                                actions[i++] = new Action(op.getName(), imgDesc) {

                                    @Override
                                    public void run() {
                                        Session session = sessionRef.get();
                                        if (session != null)
                                            op.exec(session, parameters);
                                    }

                                };
                            }
                            return actions;
                        } else {
                            return null;
                        }
                    }

                });
            } catch (DatabaseException e) {
                e.printStackTrace();
            }

        }
        return NO_ACTIONS;
    }

}
