package org.simantics.structural2.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public interface StructuralChangeVisitor {

    /**
     * This method is called for components when
     * <ul>
     *     <li>They are created</li>
     *     <li>Their children are removed</li>
     *     <li>Their properties are changed</li>
     *     <li>Their connections are modified</li>
     * </ul>
     * Flag {@code onlySubstructureChanged} is false, if only the children of the component are removed.
     */
    void visitComponentChange(ReadGraph graph, Resource component, boolean componentItselfModified) throws DatabaseException;

}
