/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.queries;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public class StructuralChildMapOfResource extends ResourceRead<Map<String, Resource>> {

    public StructuralChildMapOfResource(Resource resource) {
        super(resource);
    }

    @Override
    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        Resource type = graph.getPossibleType(resource, STR.Component);
        if (type != null) {
            Resource definition = graph.getPossibleObject(type, STR.IsDefinedBy);
            if (definition != null) {
                Map<String, Resource> map = graph.syncRequest(new UnescapedChildMapOfResource(definition));
                if (!map.isEmpty())
                    return map;
            }
        }
        return graph.syncRequest(new UnescapedChildMapOfResource(resource));
    }

}