package org.simantics.scl.osgi.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.osgi.SCLOsgi;

public class TestUtils {
    public static List<TestRunnable> getTests() {
        ArrayList<TestRunnable> result = new ArrayList<TestRunnable>();
        SCLOsgi.TEST_REPOSITORY.collectTests(result);
        Collections.sort(result, new Comparator<TestRunnable>() {
            @Override
            public int compare(TestRunnable o1, TestRunnable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }
}
