package org.simantics.scenegraph.loader.function;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.loader.SceneGraphContext;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scl.reflection.annotations.SCLValue;

public class All {

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Variable")
    public static Variable defaultRuntimeVariable(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	SceneGraphContext vc = ScenegraphLoaderUtils.getContext(graph, context);
    	if(vc == null) return null;
    	
    	ScenegraphResources SG = ScenegraphResources.getInstance(graph);
    	String uri = graph.getRelatedValue(vc.getRuntime(), SG.Runtime_HasVariable, Bindings.STRING);
    	return Variables.getVariable(graph, uri);
    	
    }

    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Resource")
    public static Resource defaultRuntimeResource(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	SceneGraphContext vc = ScenegraphLoaderUtils.getContext(graph, context);
    	if(vc == null) return null;
    	
    	ScenegraphResources SG = ScenegraphResources.getInstance(graph);
    	return graph.getSingleObject(vc.getRuntime(), SG.Runtime_HasResource);
    	
    }

    
	private static Object walk(ReadGraph graph, Variable context, String name) throws DatabaseException {
		
		Variable var = context.getPossibleProperty(graph, name);
		if(var != null) return var.getValue(graph);
		
		Variable parent = context.getParent(graph);
		if(parent == null) return null; 
		
		return walk(graph, parent, name);
		
	}
	
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> a")
    public static Object liftedProperty(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
    	
    	ScenegraphResources SG = ScenegraphResources.getInstance(graph);
    	final Resource predicate = graph.getSingleObject(converter, SG.LiftedProperty_HasPredicate);
    	
		try {
			Layer0 L0 = Layer0.getInstance(graph);
			Variable parent = context.getParent(graph);
			String name = graph.getRelatedValue(predicate, L0.HasName, Bindings.STRING);
			return walk(graph, parent, name);
		} catch (DatabaseException e) {
			e.printStackTrace();
			return null;
		}
        
    }
	
    @SCLValue(type = "ReadGraph -> Resource -> Variable -> Variable")
    public static Variable singleVariableSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
    	return ScenegraphLoaderUtils.getVariableSelection(graph, context);
    }
    
}
