/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message;

import org.simantics.message.IMessageSchemeHandler;
import org.simantics.message.MessageSchemeException;

public abstract class AbstractMessageSchemeHandler<T>
implements IMessageSchemeHandler {
    private String scheme;
    private Class<?> expectedDataClass;

    public AbstractMessageSchemeHandler(String scheme, Class<?> expectedDataClass) {
        this.scheme = scheme;
        this.expectedDataClass = expectedDataClass;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void perform(Object o) throws MessageSchemeException {
        if (this.expectedDataClass.isInstance(o)) {
            this.doPerform(o);
        } else {
            this.handleInvalidData(o);
        }
    }

    public void handleInvalidData(Object o) {
        throw new RuntimeException("Object " + o + " is not an instance of " + this.expectedDataClass.getCanonicalName());
    }

    public abstract void doPerform(T var1) throws MessageSchemeException;
}

